/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.datagen;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import xxrexraptorxx.advancedtools.datagen.ItemModelGen;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModItems;
import xxrexraptorxx.advancedtools.registry.ModTags;
import xxrexraptorxx.advancedtools.utils.ToolUtils;

public class RecipeGen
extends RecipeProvider {
    public RecipeGen(HolderLookup.Provider lookupProvider, RecipeOutput recipeOutput) {
        super(lookupProvider, recipeOutput);
    }

    protected void buildRecipes() {
        for (String handle : ModItems.HANDLE_MATERIALS) {
            TagKey<Item> rodTag = ModTags.createItemTag("c", "rods/" + ToolUtils.transformMaterialNames(handle));
            AdvancedTools.LOGGER.info("Generate Recipes with " + handle + "-handle of tag [" + String.valueOf(rodTag.location()) + "]");
            for (String tool : ModItems.TOOL_TYPES) {
                if (handle.equals("wood")) continue;
                AdvancedTools.LOGGER.info("Try smithing for [" + handle + "_stick_netherite_" + tool + "]");
                this.netheriteSmithing((Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_diamond_" + tool)), (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_netherite_" + tool)), handle);
            }
            for (String head : ModItems.TOOL_HEAD_MATERIALS) {
                if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(head) && handle.equals("wood")) continue;
                TagKey<Item> craftingMaterialTag = ModTags.createItemTag("c", ToolUtils.transformMaterialNames(head) + "_tool_materials");
                AdvancedTools.LOGGER.info("Generate Recipes with " + head + "-head of tag [" + String.valueOf(craftingMaterialTag.location()) + "]");
                this.swordRecipe(rodTag, craftingMaterialTag, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_sword")));
                this.axeRecipe(rodTag, craftingMaterialTag, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_axe")));
                this.pickaxeRecipe(rodTag, craftingMaterialTag, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_pickaxe")));
                this.shovelRecipe(rodTag, craftingMaterialTag, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_shovel")));
                this.hoeRecipe(rodTag, craftingMaterialTag, (Item)BuiltInRegistries.ITEM.getValue(RecipeGen.getItemLoc(handle + "_stick_" + head + "_hoe")));
            }
        }
    }

    public void swordRecipe(TagKey<Item> handle, TagKey<Item> material, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handle).define(Character.valueOf('X'), material).pattern("X").pattern("X").pattern("#").unlockedBy("has_" + material.location().getPath(), this.has(material)).save(this.output.withConditions(new ICondition[]{new AndCondition(List.of(new NotCondition((ICondition)new TagEmptyCondition(handle)), new NotCondition((ICondition)new TagEmptyCondition(material))))}));
    }

    public void pickaxeRecipe(TagKey<Item> handle, TagKey<Item> material, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handle).define(Character.valueOf('X'), material).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_" + material.location().getPath(), this.has(material)).save(this.output.withConditions(new ICondition[]{new AndCondition(List.of(new NotCondition((ICondition)new TagEmptyCondition(handle)), new NotCondition((ICondition)new TagEmptyCondition(material))))}));
    }

    public void axeRecipe(TagKey<Item> handle, TagKey<Item> material, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handle).define(Character.valueOf('X'), material).pattern("XX").pattern("#X").pattern("# ").unlockedBy("has_" + material.location().getPath(), this.has(material)).save(this.output.withConditions(new ICondition[]{new AndCondition(List.of(new NotCondition((ICondition)new TagEmptyCondition(handle)), new NotCondition((ICondition)new TagEmptyCondition(material))))}));
    }

    public void shovelRecipe(TagKey<Item> handle, TagKey<Item> material, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handle).define(Character.valueOf('X'), material).pattern("X").pattern("#").pattern("#").unlockedBy("has_" + material.location().getPath(), this.has(material)).save(this.output.withConditions(new ICondition[]{new AndCondition(List.of(new NotCondition((ICondition)new TagEmptyCondition(handle)), new NotCondition((ICondition)new TagEmptyCondition(material))))}));
    }

    public void hoeRecipe(TagKey<Item> handle, TagKey<Item> material, Item result) {
        AdvancedTools.LOGGER.info("Generate crafting recipe for " + RecipeGen.getItemName((ItemLike)result));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)result).define(Character.valueOf('#'), handle).define(Character.valueOf('X'), material).pattern("XX").pattern("# ").pattern("# ").unlockedBy("has_" + material.location().getPath(), this.has(material)).save(this.output.withConditions(new ICondition[]{new AndCondition(List.of(new NotCondition((ICondition)new TagEmptyCondition(handle)), new NotCondition((ICondition)new TagEmptyCondition(material))))}));
    }

    @Deprecated
    public void toolRecyclingRecipes() {
        for (String handle : ModItems.HANDLE_MATERIALS) {
            for (String tool : ModItems.TOOL_TYPES) {
                Item result = (Item)BuiltInRegistries.ITEM.getValue(ItemModelGen.getItemLoc(handle + "_stick_iron_" + tool));
                AdvancedTools.LOGGER.info("Generate smelting recipes for " + RecipeGen.getItemName((ItemLike)result));
                SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)result), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, (float)0.1f, (int)200).unlockedBy(RecipeGen.getHasName((ItemLike)result), this.has((ItemLike)result)).save(this.output, "advancedtools:smelting/" + handle + "_stick_iron_" + tool);
                SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike)result), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, (float)0.1f, (int)100).unlockedBy(RecipeGen.getHasName((ItemLike)result), this.has((ItemLike)result)).save(this.output, "advancedtools:blasting/" + handle + "_stick_iron_" + tool);
                result = (Item)BuiltInRegistries.ITEM.getValue(ItemModelGen.getItemLoc(handle + "_stick_gold_" + tool));
                AdvancedTools.LOGGER.info("Generate smelting recipes for " + RecipeGen.getItemName((ItemLike)result));
                SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)result), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, (float)0.1f, (int)200).unlockedBy(RecipeGen.getHasName((ItemLike)result), this.has((ItemLike)result)).save(this.output, "advancedtools:smelting/" + handle + "_stick_gold_" + tool);
                SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike)result), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, (float)0.1f, (int)100).unlockedBy(RecipeGen.getHasName((ItemLike)result), this.has((ItemLike)result)).save(this.output, "advancedtools:blasting/" + handle + "_stick_gold_" + tool);
            }
        }
    }

    private void netheriteSmithing(Item item, Item result, String conditionalMaterial) {
        AdvancedTools.LOGGER.info("Generate smithing recipe for " + RecipeGen.getItemName((ItemLike)result) + " from " + String.valueOf(item));
        TagKey<Item> rodTag = ModTags.createItemTag("c", "rods/" + ToolUtils.transformMaterialNames(conditionalMaterial));
        TagKey<Item> craftingMaterialTag = ModTags.createItemTag("c", ToolUtils.transformMaterialNames(conditionalMaterial) + "_tool_materials");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)item), (Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_INGOT), (RecipeCategory)RecipeCategory.COMBAT, (Item)result).unlocks("has_netherite_ingot", this.has((ItemLike)Items.NETHERITE_INGOT)).save(this.output.withConditions(new ICondition[]{new AndCondition(List.of(new NotCondition((ICondition)new TagEmptyCondition(rodTag)), new NotCondition((ICondition)new TagEmptyCondition(craftingMaterialTag))))}), "advancedtools:smithing/" + RecipeGen.getItemName((ItemLike)result));
    }

    private static ResourceLocation getItemLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)name);
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
            return new RecipeGen(provider, output);
        }

        public String getName() {
            return "advancedtools_recipes";
        }
    }
}

