/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.registry;

import java.util.Arrays;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.registry.ModItems;
import xxrexraptorxx.advancedtools.utils.Config;
import xxrexraptorxx.advancedtools.utils.ToolUtils;

public class CreativeModeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"advancedtools");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MAIN_TAB = CREATIVE_MODE_TABS.register("advancedtools", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.advancedtools_tab")).icon(() -> ((Item)BuiltInRegistries.ITEM.getValue(CreativeModeTabs.getItemLoc("iron_stick_diamond_pickaxe"))).getDefaultInstance()).displayItems((params, output) -> {
        for (String handle : ModItems.HANDLE_MATERIALS) {
            if (ToolUtils.isRod(handle)) continue;
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                AdvancedTools.LOGGER.info("Register rod in creative tab: " + handle + " " + String.valueOf(BuiltInRegistries.ITEM.getValue(CreativeModeTabs.getStickLoc(handle))));
            }
            if (!ToolUtils.isValidRodForCreative(handle)) continue;
            output.accept((ItemLike)BuiltInRegistries.ITEM.getValue(CreativeModeTabs.getStickLoc(handle)));
        }
        for (String handle : ModItems.HANDLE_MATERIALS) {
            for (String head : ModItems.TOOL_HEAD_MATERIALS) {
                if (Arrays.asList(ModItems.VANILLA_HEAD_MATERIALS).contains(head) && handle.equals("wood")) continue;
                if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                    AdvancedTools.LOGGER.info("Register tools in creative tab: " + handle + " handle + " + head + " head.");
                }
                if (!ToolUtils.isValidForCreative(head, handle)) continue;
                for (String tool : ModItems.TOOL_TYPES) {
                    output.accept((ItemLike)BuiltInRegistries.ITEM.getValue(CreativeModeTabs.getItemLoc(handle + "_stick_" + head + "_" + tool)));
                }
            }
        }
        output.accept((ItemLike)ModItems.IRON_BOW.get());
        output.accept((ItemLike)ModItems.GOLD_BOW.get());
        output.accept((ItemLike)ModItems.DIAMOND_BOW.get());
        output.accept((ItemLike)ModItems.NETHERITE_BOW.get());
    }).build());

    public static void init(IEventBus bus) {
        CREATIVE_MODE_TABS.register(bus);
    }

    private static ResourceLocation getStickLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)("stick_" + name));
    }

    private static ResourceLocation getItemLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"advancedtools", (String)name);
    }
}

