/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.utils.Config;
import xxrexraptorxx.advancedtools.utils.ToolUtils;

public class ModTags {
    public static TagKey<Item> createItemTag(String id, String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id, (String)name));
    }

    public static TagKey<Item> createCItemTag(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static TagKey<Block> createBlockTag(String id, String name) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id, (String)name));
    }

    public static TagKey<Block> createCBlockTag(String name) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static boolean isTagValidAndHasMatchingItems(String material) {
        if (Minecraft.getInstance().level != null) {
            RegistryAccess lookupProvider = Minecraft.getInstance().level.registryAccess();
            List<TagKey<Item>> tagKeys = ModTags.getPossibleTagsForMaterial(material);
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                AdvancedTools.LOGGER.info("Searching for items of material [" + ToolUtils.transformMaterialNames(material) + "] in multiple possible tags");
            }
            for (TagKey<Item> tagKey : tagKeys) {
                HolderLookup holderLookup;
                Optional tagEntries;
                Optional lookup = lookupProvider.lookup(BuiltInRegistries.ITEM.key());
                if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                    AdvancedTools.LOGGER.info("Checking tag [" + String.valueOf(tagKey.location()) + "]");
                }
                if (!lookup.isPresent() || !(tagEntries = (holderLookup = (HolderLookup)lookup.get()).get(tagKey)).isPresent() || !((HolderSet.Named)tagEntries.get()).isBound()) continue;
                for (Holder itemHolder : (HolderSet.Named)tagEntries.get()) {
                    ResourceLocation itemName = BuiltInRegistries.ITEM.getKey((Object)((Item)itemHolder.value()));
                    if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                        AdvancedTools.LOGGER.info("Entry found: " + String.valueOf(itemName));
                    }
                    if (!BuiltInRegistries.ITEM.containsKey(itemName)) continue;
                    if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                        AdvancedTools.LOGGER.info("Item is registered!");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isTagContainedInAnother(TagKey<Block> innerTag, TagKey<Block> outerTag) {
        if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
            AdvancedTools.LOGGER.info("Compare if block tag [" + String.valueOf(innerTag.location()) + "] is in [" + String.valueOf(outerTag.location()) + "]");
        }
        if (Minecraft.getInstance().level != null) {
            Registry blockLookup = Minecraft.getInstance().level.registryAccess().lookupOrThrow(Registries.BLOCK);
            HolderSet.Named innerSet = blockLookup.getOrThrow(innerTag);
            HolderSet.Named outerSet = blockLookup.getOrThrow(outerTag);
            return innerSet.stream().anyMatch(arg_0 -> ((HolderSet.Named)outerSet).contains(arg_0));
        }
        return false;
    }

    public static List<TagKey<Item>> getPossibleTagsForMaterial(String material) {
        ArrayList<TagKey<Item>> tags = new ArrayList<TagKey<Item>>();
        if (ToolUtils.isSpecial(material = ToolUtils.transformMaterialNames(material))) {
            if (material.equals("wither_bone")) {
                tags.add(ModTags.createCItemTag("bones/wither"));
            } else if (material.equals("bone")) {
                tags.add(ModTags.createCItemTag("bones/regular"));
            } else if (material.equals("carbon")) {
                tags.add(ModTags.createCItemTag("plates/carbon"));
                tags.add(ModTags.createCItemTag("ingots/carbon"));
            } else if (material.equals("plastic")) {
                tags.add(ModTags.createCItemTag("pellets/plastic"));
                tags.add(ModTags.createCItemTag("plastic_sheets"));
                tags.add(ModTags.createCItemTag("plastic"));
            } else if (material.equals("silicon")) {
                tags.add(ModTags.createCItemTag("silicon"));
                tags.add(ModTags.createCItemTag("ingots/silicon"));
            } else if (material.equals("bedrock")) {
                tags.add(ModTags.createCItemTag("ingots/bedrock"));
                tags.add(ModTags.createCItemTag("ingots/refined_bedrock"));
            } else if (material.equals("redstone")) {
                tags.add(ModTags.createCItemTag("ingots/redstone"));
                tags.add(ModTags.createCItemTag("ingots/refined_redstone"));
                tags.add(ModTags.createCItemTag("ingots/redstone_alloy"));
            } else if (material.equals("glowstone")) {
                tags.add(ModTags.createCItemTag("ingots/glowstone"));
                tags.add(ModTags.createCItemTag("ingots/refined_glowstone"));
                tags.add(ModTags.createCItemTag("ingots/glowstone_alloy"));
            } else if (material.equals("obsidian")) {
                tags.add(ModTags.createCItemTag("ingots/obsidian"));
                tags.add(ModTags.createCItemTag("ingots/refined_obsidian"));
            } else if (material.equals("superconductor")) {
                tags.add(ModTags.createCItemTag("ingots/superconductor"));
                tags.add(ModTags.createCItemTag("ingots/superconductor_alloy"));
            } else {
                tags.add(ModTags.createCItemTag("rods/" + material));
            }
        } else if (ToolUtils.isGem(material)) {
            tags.add(ModTags.createCItemTag("gems/" + material));
        } else {
            tags.add(ModTags.createCItemTag("ingots/" + material));
        }
        return tags;
    }
}

