/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.advancedtools.world;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import xxrexraptorxx.advancedtools.main.AdvancedTools;
import xxrexraptorxx.advancedtools.utils.Config;
import xxrexraptorxx.advancedtools.utils.FormattingUtils;
import xxrexraptorxx.advancedtools.utils.ToolUtils;

@EventBusSubscriber(modid="advancedtools", bus=EventBusSubscriber.Bus.GAME)
public class Events {
    private static boolean hasShownUp = false;
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        if (Config.UPDATE_CHECKER != null && ((Boolean)Config.UPDATE_CHECKER.get()).booleanValue() && !hasShownUp && Minecraft.getInstance().screen == null) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            ModContainer modContainer = ModList.get().getModContainerById("advancedtools").orElse(null);
            if (modContainer != null) {
                VersionChecker.CheckResult versionCheckResult = VersionChecker.getResult((IModInfo)modContainer.getModInfo());
                if (versionCheckResult.status() == VersionChecker.Status.OUTDATED || versionCheckResult.status() == VersionChecker.Status.BETA_OUTDATED) {
                    MutableComponent url = Component.translatable((String)(String.valueOf(ChatFormatting.GREEN) + "Click here to update!")).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create("https://www.curseforge.com/minecraft/mc-mods/advanced-sticks"))));
                    player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "A newer version of " + String.valueOf(ChatFormatting.YELLOW) + "Advanced Tools" + String.valueOf(ChatFormatting.BLUE) + " is available!")), false);
                    player.displayClientMessage((Component)url, false);
                    hasShownUp = true;
                } else if (versionCheckResult.status() == VersionChecker.Status.FAILED) {
                    AdvancedTools.LOGGER.error("Advanced Tools's version checker failed!");
                    hasShownUp = true;
                }
            }
        }
    }

    @SubscribeEvent
    public static void SupporterRewards(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer serverPlayer;
        Player player = event.getEntity();
        Level level = player.level();
        if (((Boolean)Config.PATREON_REWARDS.get()).booleanValue() && !player.getInventory().contains(new ItemStack((ItemLike)Items.PAPER)) && player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).getStats().getValue(Stats.CUSTOM, (Object)Stats.PLAY_TIME) < 5) {
            CompletableFuture.runAsync(() -> {
                if (Events.SupporterCheck(URI.create("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Supporter"), player)) {
                    Events.giveSupporterReward(player, level);
                }
                if (Events.SupporterCheck(URI.create("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Premium%20Supporter"), player)) {
                    Events.givePremiumSupporterReward(player, level);
                }
                if (Events.SupporterCheck(URI.create("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Elite"), player)) {
                    Events.giveEliteReward(player);
                }
            });
        }
    }

    private static boolean SupporterCheck(URI uri, Player player) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            List<String> supporterList = List.of(response.body().split("\\R"));
            return supporterList.contains(player.getName().getString());
        }
        catch (Exception e) {
            AdvancedTools.LOGGER.error("Failed to fetch or process supporter list from URI: {}", (Object)uri, (Object)e);
            return false;
        }
    }

    private static void giveSupporterReward(Player player, Level level) {
        ItemStack certificate = new ItemStack((ItemLike)Items.PAPER);
        certificate.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Thank you for supporting me in my work!").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)" - XxRexRaptorxX").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GREEN)));
        ItemStack reward = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        GameProfile profile = new GameProfile(player.getUUID(), player.getName().getString());
        reward.set(DataComponents.PROFILE, (Object)new ResolvableProfile(profile));
        level.playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
        player.getInventory().add(reward);
        player.getInventory().add(certificate);
    }

    private static void givePremiumSupporterReward(Player player, Level level) {
        ItemStack reward = new ItemStack((ItemLike)Items.DIAMOND_SWORD, 1);
        Registry enchantmentsRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        reward.enchant((Holder)enchantmentsRegistry.getOrThrow(Enchantments.MENDING), 1);
        reward.enchant((Holder)enchantmentsRegistry.getOrThrow(Enchantments.SHARPNESS), 3);
        reward.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)reward.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)));
        player.getInventory().add(reward);
    }

    private static void giveEliteReward(Player player) {
        ItemStack star = new ItemStack((ItemLike)Items.NETHER_STAR);
        star.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Elite Star"));
        player.getInventory().add(star);
    }

    @SubscribeEvent
    public static void addingToolTips(ItemTooltipEvent event) {
        Item item = event.getItemStack().getItem();
        String namespace = BuiltInRegistries.ITEM.getKey((Object)item).getNamespace();
        String name = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        if (((Boolean)Config.SHOW_STICK_TYPE.get()).booleanValue() && !namespace.equals("tconstruct") && !namespace.equals("silentgems") && !namespace.equals("tetra") && item.components().has(DataComponents.TOOL) && (name.contains("pickaxe") || name.contains("axe") || name.contains("sword") || name.contains("shovel") || name.contains("hoe"))) {
            if (namespace.equals("advancedtools")) {
                if (Screen.hasShiftDown() && ((Boolean)Config.SHOW_MATERIAL_STATS.get()).booleanValue()) {
                    event.getToolTip().add(2, ToolUtils.getToolStatDescription(Objects.requireNonNull(ToolUtils.getPartsFromTool(name))[0], Objects.requireNonNull(ToolUtils.getPartsFromTool(name))[1]));
                } else {
                    event.getToolTip().add(1, FormattingUtils.setModLangComponent("message", "handle").withStyle(ChatFormatting.GRAY));
                    event.getToolTip().add(2, Component.literal((String)(" " + ToolUtils.getStickFromName(item))).withStyle(ChatFormatting.DARK_GRAY));
                }
            } else if (namespace.equals("minecraft")) {
                if (Screen.hasShiftDown() && ((Boolean)Config.SHOW_MATERIAL_STATS.get()).booleanValue()) {
                    event.getToolTip().add(2, ToolUtils.getToolStatDescription("wood", ToolUtils.getBaseMaterialFromVanillaItem(name)));
                } else {
                    event.getToolTip().add(1, FormattingUtils.setModLangComponent("message", "handle").withStyle(ChatFormatting.GRAY));
                    event.getToolTip().add(2, Component.literal((String)" ").append((Component)FormattingUtils.setModLangComponent("item", "stick_wood")).withStyle(ChatFormatting.DARK_GRAY));
                }
            } else if (namespace.equals("bedrockminer")) {
                event.getToolTip().add(1, FormattingUtils.setModLangComponent("message", "handle").withStyle(ChatFormatting.GRAY));
                event.getToolTip().add(2, Component.literal((String)" ").append((Component)FormattingUtils.setModLangComponent("item", "stick_diamond")).withStyle(ChatFormatting.DARK_GRAY));
            } else {
                event.getToolTip().add(1, FormattingUtils.setModLangComponent("message", "handle").withStyle(ChatFormatting.GRAY));
                event.getToolTip().add(2, Component.literal((String)" ").append((Component)FormattingUtils.setModLangComponent("item", "stick_wood")).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Path configDir = FMLPaths.CONFIGDIR.get();
        Path marker = configDir.resolve("#STOP_MOD_REPOSTS.txt");
        try {
            if (Files.notExists(marker, new LinkOption[0])) {
                String fileContent = "    Sites like 9minecraft.net, mc-mod.net, and many others, are known for reuploading mod files without permission from the authors. These sites will also contain a bunch of ads, to try to make money from mods they did not create.\n\n    These sites will use various methods to appear higher in Google when you search for the mod name, so a lot of people will download mods from them instead of the proper place. If you were linked to this site, you're one of these people.\n\n    FOR YOU, AS A PLAYER, THIS CAN MEAN ANY OF THE FOLLOWING:\n    > Getting versions of the mods advertised for the wrong Minecraft versions, which will 100% crash when you load them.\n    > Getting old, and broken, versions of the mods, possibly causing problems in your game.\n    > Getting modified versions of the mods, which may contain malware and viruses.\n    > Having your information stolen from malicious ads in the sites.\n    > Taking money and views away from the official authors, which may cause them to stop making new mods.\n\n    WHAT DO I DO NOW?\n    The most important thing to do now is to make sure you stop visiting these sites, and get the mods from official sources. We also recommend you do the following:\n\n    > Delete all the mods you've downloaded from these sites.\n    > Install the StopModReposts plugin, which makes sure you never visit them again.\n    > Run a virus/malware scan. We recommend MalwareBytes.\n    > Check out the #StopModReposts campaign, that tries to put an end to these sites. (https://stopmodreposts.org/)\n    > Spread the word. If you have any friends that use these sites, inform them to keep them safe.\n\n    WHERE DO I GET MODS NOW?\n    Here's a bunch of links to places where you can download official versions of mods, hosted by their real authors:\n\n    > CurseForge, where most modders host their mods. If it exists, it's probably there.\n    > Modrinth, a new hosting platform for mods that's also legit and more popular by the day.\n    > OptiFine.net, the official OptiFine site.\n    > Neoforged.net, which you need for any other Neoforge mods.\n    > FabricMC.net, which you need for any other Fabric mods.\n    > MinecraftForge Files, which you need for any other Forge mods.\n\n    This doesn't mean other sites aren't legit. In general, the first place to look for a mod is CurseForge and Modrinth, so look there first.\n\n    FAQ\n    Q: What if I've never had problems before?\n    > Just because you've never had problems with these sites before doesn't mean they're good. You should still avoid them for all the reasons listed above.\n\n    Q: Is there a list of these sites I can check out?\n    > Yes, however, due to these showing up all the time, it's possible to be incomplete. (https://github.com/StopModReposts/Illegal-Mod-Sites/blob/master/SITES.md)\n\n    Q: Why can't you just take these sites down?\n    > Unfortunately, these sites are often hosted in countries like Russia or Vietnam, where doing so isn't as feasible.\n\n    Q: What if it says \"Official Download\" on the sites?\n    > Sometimes they'll do that to trick you. If you're uncertain, you should verify with the StopModReposts list linked above.\n\n\n    Credits: XxRexRaptorxX, Vazkii, StopModReposts campaign\n";
                Files.writeString(marker, (CharSequence)fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
                String launcher = FMLLoader.getLauncherInfo().toLowerCase();
                if (!(launcher.contains("curseforge") && launcher.contains("modrinth") && launcher.contains("prism"))) {
                    player2.sendSystemMessage((Component)Component.literal((String)"Important information about mod reposts:\n").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.DARK_RED));
                    player2.sendSystemMessage((Component)Component.literal((String)"Sites like 9minecraft.net, mc-mod.net, etc. are known for reuploading mod files without permissions. \nThese sites will also contain a bunch of ads, to try to make money from mods they did not create.\n").withStyle(ChatFormatting.RED));
                    player2.sendSystemMessage((Component)Component.literal((String)"For you, this can mean any of the following:").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.RED));
                    player2.sendSystemMessage((Component)Component.literal((String)"- Modified versions of mods, which may contain malware & viruses").withStyle(ChatFormatting.YELLOW));
                    player2.sendSystemMessage((Component)Component.literal((String)"- Having your information stolen from malicious ads").withStyle(ChatFormatting.YELLOW));
                    player2.sendSystemMessage((Component)Component.literal((String)"- Old and broken mod versions that can corrupt your world").withStyle(ChatFormatting.YELLOW));
                    player2.sendSystemMessage((Component)Component.literal((String)"- Taking money and views away from the real authors, which may cause them to stop making mods").withStyle(ChatFormatting.YELLOW));
                    MutableComponent url = Component.translatable((String)(String.valueOf(ChatFormatting.GOLD) + "* Click here for more information *")).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create("https://vazkii.net/repost/"))));
                    player2.sendSystemMessage((Component)url);
                }
            }
        }
        catch (IOException e) {
            AdvancedTools.LOGGER.error((Object)e);
        }
    }
}

