package net.mcreator.elaboratedevelopment.item;

import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.api.distmarker.Dist;

import net.minecraft.world.level.Level;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Item;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionHand;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.core.registries.Registries;

import net.mcreator.elaboratedevelopment.procedures.SinfulSyphonScytheRightclickedProcedure;
import net.mcreator.elaboratedevelopment.procedures.SinfulSyphonScytheLivingEntityIsHitWithToolProcedure;

public class SinfulSyphonScytheItem extends Item {
	private static final ToolMaterial TOOL_MATERIAL = new ToolMaterial(BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 2843, 9f, 0, 2, TagKey.create(Registries.ITEM, ResourceLocation.parse("elaborate_development:sinful_syphon_scythe_repair_items")));

	public SinfulSyphonScytheItem(Item.Properties properties) {
		super(properties.sword(TOOL_MATERIAL, 7f, -2.2f).fireResistant().rarity(Rarity.EPIC));
	}

	@Override
	public void hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
		super.hurtEnemy(itemstack, entity, sourceentity);
		SinfulSyphonScytheLivingEntityIsHitWithToolProcedure.execute(sourceentity);
	}

	@Override
	public InteractionResult use(Level world, Player entity, InteractionHand hand) {
		InteractionResult ar = super.use(world, entity, hand);
		SinfulSyphonScytheRightclickedProcedure.execute(world, entity);
		return ar;
	}

	@Override
	@OnlyIn(Dist.CLIENT)
	public boolean isFoil(ItemStack itemstack) {
		return true;
	}
}