package net.mcreator.elaboratedevelopment.procedures;

import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.bus.api.Event;

import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.resources.ResourceKey;
import net.minecraft.core.registries.Registries;

import net.mcreator.elaboratedevelopment.init.ElaborateDevelopmentModItems;

import javax.annotation.Nullable;

@EventBusSubscriber
public class CompactProcedure {
	@SubscribeEvent
	public static void onPlayerTick(PlayerTickEvent.Post event) {
		execute(event, event.getEntity().level(), event.getEntity());
	}

	public static void execute(LevelAccessor world, Entity entity) {
		execute(null, world, entity);
	}

	private static void execute(@Nullable Event event, LevelAccessor world, Entity entity) {
		if (entity == null)
			return;
		double wheat = 0;
		double carrot = 0;
		double potato = 0;
		double beetroot = 0;
		double netherwart = 0;
		if ((entity instanceof LivingEntity _livEnt ? _livEnt.getMainHandItem() : ItemStack.EMPTY)
				.getEnchantmentLevel(world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ResourceKey.create(Registries.ENCHANTMENT, ResourceLocation.parse("elaborate_development:compacting")))) != 0) {
			if (entity.getCapability(Capabilities.ItemHandler.ENTITY, null) instanceof IItemHandlerModifiable _modHandlerIter) {
				for (int _idx = 0; _idx < _modHandlerIter.getSlots(); _idx++) {
					ItemStack itemstackiterator = _modHandlerIter.getStackInSlot(_idx).copy();
					if (itemstackiterator.getItem() == Items.WHEAT) {
						wheat = wheat + itemstackiterator.getCount();
					} else if (itemstackiterator.getItem() == Items.CARROT) {
						carrot = carrot + itemstackiterator.getCount();
					} else if (itemstackiterator.getItem() == Items.POTATO) {
						potato = potato + itemstackiterator.getCount();
					} else if (itemstackiterator.getItem() == Items.BEETROOT) {
						beetroot = beetroot + itemstackiterator.getCount();
					} else if (itemstackiterator.getItem() == Items.NETHER_WART) {
						netherwart = netherwart + itemstackiterator.getCount();
					}
				}
			}
			for (int index0 = 0; index0 < (int) Math.floor(wheat / 9); index0++) {
				if (entity instanceof Player _player) {
					ItemStack _stktoremove = new ItemStack(Items.WHEAT);
					_player.getInventory().clearOrCountMatchingItems(p -> _stktoremove.getItem() == p.getItem(), 9, _player.inventoryMenu.getCraftSlots());
				}
				if (entity instanceof Player _player) {
					ItemStack _setstack = new ItemStack(Blocks.HAY_BLOCK).copy();
					_setstack.setCount(1);
					ItemHandlerHelper.giveItemToPlayer(_player, _setstack);
				}
			}
			for (int index1 = 0; index1 < (int) Math.floor(carrot / 9); index1++) {
				if (entity instanceof Player _player) {
					ItemStack _stktoremove = new ItemStack(Items.CARROT);
					_player.getInventory().clearOrCountMatchingItems(p -> _stktoremove.getItem() == p.getItem(), 9, _player.inventoryMenu.getCraftSlots());
				}
				if (entity instanceof Player _player) {
					ItemStack _setstack = new ItemStack(ElaborateDevelopmentModItems.COMPACTED_CARROT.get()).copy();
					_setstack.setCount(1);
					ItemHandlerHelper.giveItemToPlayer(_player, _setstack);
				}
			}
			for (int index2 = 0; index2 < (int) Math.floor(potato / 9); index2++) {
				if (entity instanceof Player _player) {
					ItemStack _stktoremove = new ItemStack(Items.POTATO);
					_player.getInventory().clearOrCountMatchingItems(p -> _stktoremove.getItem() == p.getItem(), 9, _player.inventoryMenu.getCraftSlots());
				}
				if (entity instanceof Player _player) {
					ItemStack _setstack = new ItemStack(ElaborateDevelopmentModItems.COMPACTED_POTATO.get()).copy();
					_setstack.setCount(1);
					ItemHandlerHelper.giveItemToPlayer(_player, _setstack);
				}
			}
			for (int index3 = 0; index3 < (int) Math.floor(beetroot / 9); index3++) {
				if (entity instanceof Player _player) {
					ItemStack _stktoremove = new ItemStack(Items.BEETROOT);
					_player.getInventory().clearOrCountMatchingItems(p -> _stktoremove.getItem() == p.getItem(), 9, _player.inventoryMenu.getCraftSlots());
				}
				if (entity instanceof Player _player) {
					ItemStack _setstack = new ItemStack(ElaborateDevelopmentModItems.COMPACTED_BEETROOT.get()).copy();
					_setstack.setCount(1);
					ItemHandlerHelper.giveItemToPlayer(_player, _setstack);
				}
			}
			for (int index4 = 0; index4 < (int) Math.floor(netherwart / 9); index4++) {
				if (entity instanceof Player _player) {
					ItemStack _stktoremove = new ItemStack(Items.NETHER_WART);
					_player.getInventory().clearOrCountMatchingItems(p -> _stktoremove.getItem() == p.getItem(), 9, _player.inventoryMenu.getCraftSlots());
				}
				if (entity instanceof Player _player) {
					ItemStack _setstack = new ItemStack(ElaborateDevelopmentModItems.COMPACTED_NETHER_WART.get()).copy();
					_setstack.setCount(1);
					ItemHandlerHelper.giveItemToPlayer(_player, _setstack);
				}
			}
		}
	}
}