package net.mcreator.elaboratedevelopment.recipe.brewing;

import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.bus.api.SubscribeEvent;

import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ItemStack;

import net.mcreator.elaboratedevelopment.init.ElaborateDevelopmentModItems;
import net.mcreator.elaboratedevelopment.init.ElaborateDevelopmentModBlocks;

@EventBusSubscriber
public class ChocolateSyrupRecipeBrewingRecipe implements IBrewingRecipe {
	@SubscribeEvent
	public static void init(RegisterBrewingRecipesEvent event) {
		event.getBuilder().addRecipe(new ChocolateSyrupRecipeBrewingRecipe());
	}

	@Override
	public boolean isInput(ItemStack input) {
		return Ingredient.of(Items.GLASS_BOTTLE).test(input);
	}

	@Override
	public boolean isIngredient(ItemStack ingredient) {
		return Ingredient.of(ElaborateDevelopmentModBlocks.CHOCOLATE_PRISM.get().asItem()).test(ingredient);
	}

	@Override
	public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
		if (isInput(input) && isIngredient(ingredient)) {
			return new ItemStack(ElaborateDevelopmentModItems.CHOCOLATE_SYRUP.get());
		}
		return ItemStack.EMPTY;
	}
}