/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.netheriteBlocker;

import de.scholle.netheriteBlocker.Main;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class NetheriteBlocker
implements Listener {
    private final Main plugin;

    public NetheriteBlocker(Main plugin) {
        this.plugin = plugin;
    }

    private boolean isNetheriteArmor(Material m) {
        return m == Material.NETHERITE_HELMET || m == Material.NETHERITE_CHESTPLATE || m == Material.NETHERITE_LEGGINGS || m == Material.NETHERITE_BOOTS;
    }

    private boolean isNetheriteMaterial(Material m) {
        return m == Material.NETHERITE_SWORD || m == Material.NETHERITE_AXE || m == Material.NETHERITE_PICKAXE || m == Material.NETHERITE_SHOVEL || m == Material.NETHERITE_HOE || this.isNetheriteArmor(m);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!this.plugin.getConfig().getBoolean("noNetherite", true)) {
            return;
        }
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        ItemStack cursor = e.getCursor();
        ItemStack current = e.getCurrentItem();
        if (cursor != null && this.isNetheriteArmor(cursor.getType()) || current != null && this.isNetheriteArmor(current.getType())) {
            e.setCancelled(true);
            p.sendMessage("\u00a7cNetherite-R\u00fcstung hier nicht erlaubt!");
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!this.plugin.getConfig().getBoolean("noNetherite", true)) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack item = e.getItem();
        if (item != null && this.isNetheriteArmor(item.getType()) && e.getHand() == EquipmentSlot.HAND) {
            e.setCancelled(true);
            p.sendMessage("\u00a7cNetherite-R\u00fcstung darf nicht angelegt werden!");
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (!this.plugin.getConfig().getBoolean("noNetherite", true)) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        if (item != null && this.isNetheriteMaterial(item.getType())) {
            e.setCancelled(true);
            p.sendMessage("\u00a7cNetherite-Werkzeug nicht erlaubt!");
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent e) {
        if (!this.plugin.getConfig().getBoolean("noNetherite", true)) {
            return;
        }
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        ItemStack item = p.getInventory().getItemInMainHand();
        if (item != null && this.isNetheriteMaterial(item.getType())) {
            e.setCancelled(true);
            p.sendMessage("\u00a7cNetherite-Waffe nicht erlaubt!");
        }
    }

    @EventHandler
    public void onBlockDispenseArmor(BlockDispenseArmorEvent e) {
        if (!this.plugin.getConfig().getBoolean("noNetherite", true)) {
            return;
        }
        LivingEntity target = e.getTargetEntity();
        if (target instanceof Player) {
            Player p = (Player)target;
            ItemStack armor = e.getItem();
            if (armor != null && this.isNetheriteArmor(armor.getType())) {
                e.setCancelled(true);
                p.sendMessage("\u00a7cNetherite-R\u00fcstung darf nicht vom Dispenser getragen werden!");
            }
        }
    }
}

