/*
 * Decompiled with CFR 0.152.
 */
package de.ducky.autorestart;

import de.ducky.autorestart.RestartCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AutoRestartPlugin
extends JavaPlugin {
    private int restartHours;
    private boolean autoRestartEnabled;

    public void onEnable() {
        this.saveDefaultConfig();
        this.getCommand("svrestart").setExecutor((CommandExecutor)new RestartCommand(this));
        this.autoRestartEnabled = this.getConfig().getBoolean("auto-restart-enabled", true);
        this.restartHours = this.getConfig().getInt("auto-restart-hours", 2);
        if (this.autoRestartEnabled) {
            this.startAutoRestartTimer();
            this.getLogger().info("AutoRestart aktiv: All " + this.restartHours + " hours.");
        } else {
            this.getLogger().info("AutoRestart disabled.");
        }
    }

    private void startAutoRestartTimer() {
        long ticks = (long)this.restartHours * 60L * 60L * 20L;
        new BukkitRunnable(this){

            public void run() {
                Bukkit.broadcastMessage((String)"\u00a7c\u00a7lAutomatischer Server Restart startet jetzt!");
                Bukkit.getServer().shutdown();
            }
        }.runTaskTimer((Plugin)this, ticks, ticks);
    }
}

