/*
 * Decompiled with CFR 0.152.
 */
package fun.xingwangzhe.webmapview.client;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import fun.xingwangzhe.webmapview.client.PlayerInformation;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class API {
    private static HttpServer server;
    private static List<PlayerInformation> localPlayers;
    private static ScheduledExecutorService scheduler;

    public static void startLocalHttpServer(int port, List<PlayerInformation> players) {
        try {
            localPlayers = players == null ? new ArrayList<PlayerInformation>() : new ArrayList<PlayerInformation>(players);
            API.addCurrentPlayerInfo();
            server = HttpServer.create(new InetSocketAddress(port), 0);
            server.createContext("/local-players.json", new HttpHandler(){

                @Override
                public void handle(HttpExchange exchange) {
                    try {
                        String response = PlayerInformation.generatePlayerJson(localPlayers, 100, true);
                        exchange.getResponseHeaders().set("Content-Type", "application/json");
                        exchange.sendResponseHeaders(200, response.getBytes().length);
                        OutputStream os = exchange.getResponseBody();
                        os.write(response.getBytes());
                        os.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            server.start();
            API.startPlayerInfoUpdater();
            System.out.println("Local HTTP server started on port " + port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopLocalHttpServer() {
        if (server != null) {
            server.stop(0);
            System.out.println("Local HTTP server stopped.");
        }
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdown();
            try {
                if (!scheduler.awaitTermination(1L, TimeUnit.SECONDS)) {
                    scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
            System.out.println("Player info updater stopped.");
        }
    }

    public static void updateLocalPlayers(List<PlayerInformation> players) {
        localPlayers = players == null ? new ArrayList<PlayerInformation>() : new ArrayList<PlayerInformation>(players);
        API.addCurrentPlayerInfo();
    }

    private static void addCurrentPlayerInfo() {
        try {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null && client.field_1687 != null) {
                String currentPlayerName = client.field_1724.method_5477().getString();
                boolean playerExists = localPlayers.stream().anyMatch(player -> player.getName().equals(currentPlayerName));
                if (!playerExists) {
                    PlayerInformation currentPlayer = new PlayerInformation(client.field_1724.method_5667().toString(), currentPlayerName, "[fp]" + client.field_1724.method_5476().getString(), client.field_1724.method_23317(), client.field_1724.method_23321(), client.field_1687.method_27983().method_29177().toString().replace(":", "_"), client.field_1724.method_36454(), (int)client.field_1724.method_6032(), client.field_1724.method_6096(), "", false, "");
                    localPlayers.add(currentPlayer);
                    System.out.println("Added current player to local player list: " + currentPlayerName);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to add current player info: " + e.getMessage());
        }
    }

    private static void startPlayerInfoUpdater() {
        scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(() -> {
            try {
                API.updateCurrentPlayerInfo();
            }
            catch (Exception e) {
                System.err.println("Error updating player info: " + e.getMessage());
                e.printStackTrace();
            }
        }, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    private static void updateCurrentPlayerInfo() {
        block3: {
            try {
                class_310 client = class_310.method_1551();
                if (client.field_1724 == null || client.field_1687 == null) break block3;
                String currentPlayerName = client.field_1724.method_5477().getString();
                for (PlayerInformation player : localPlayers) {
                    if (!player.getName().equals(currentPlayerName) || player.isVirtual()) continue;
                    player.setX(client.field_1724.method_23317());
                    player.setZ(client.field_1724.method_23321());
                    player.setYaw(client.field_1724.method_36454());
                    player.setHealth((int)client.field_1724.method_6032());
                    player.setArmor(client.field_1724.method_6096());
                    player.setWorld(client.field_1687.method_27983().method_29177().toString().replace(":", "_"));
                    break;
                }
            }
            catch (Exception e) {
                System.err.println("Failed to update current player info: " + e.getMessage());
            }
        }
    }
}

