/*
 * Decompiled with CFR 0.152.
 */
package fun.xingwangzhe.webmapview.client;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFBrowser;
import com.mojang.blaze3d.systems.RenderSystem;
import fun.xingwangzhe.webmapview.client.API;
import fun.xingwangzhe.webmapview.client.UrlManager;
import fun.xingwangzhe.webmapview.client.WebmapviewClient;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_9801;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefDisplayHandler;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class BasicBrowser
extends class_437 {
    private static final int BROWSER_DRAW_OFFSET = 20;
    private MCEFBrowser browser;
    private boolean isInitializing = false;
    private boolean initializationFailed = false;
    private boolean resourcesReloading = false;
    private long lastResourceReloadTime = 0L;
    private static int retryCount = 0;
    private static final int MAX_RETRY_COUNT = 2;
    private boolean isAutoRecovering = false;
    private volatile boolean shouldStopInjection = false;
    private volatile boolean injectionSuccessful = false;
    private final class_310 minecraft = class_310.method_1551();

    public BasicBrowser(class_2561 title) {
        super(title);
    }

    protected void method_25426() {
        super.method_25426();
        if (this.browser == null && !this.isInitializing) {
            API.startLocalHttpServer(8080, List.of());
            if (this.isResourcePackReady()) {
                this.initializeBrowserAsync();
            } else {
                this.waitForResourcePackAndInitialize();
            }
        }
    }

    private boolean isResourcePackReady() {
        try {
            if (this.minecraft.method_1478() == null) {
                return false;
            }
            if (this.minecraft.method_1531() == null) {
                return false;
            }
            if (this.minecraft.field_1772 == null) {
                return false;
            }
            if (this.minecraft.method_22683() == null || this.minecraft.method_22683().method_4490() == 0L) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastResourceReloadTime < 2000L) {
                return false;
            }
            return !this.resourcesReloading;
        }
        catch (Exception e) {
            System.err.println(class_2561.method_43469((String)"debug.resource_pack.check_failed", (Object[])new Object[]{e.getMessage()}).getString());
            return false;
        }
    }

    private void injectJavaScriptContent() {
        if (this.browser != null) {
            try {
                String jsCode = "(function() {\n    console.log('JavaScript\u6ce8\u5165\u6210\u529f: ' + new Date().toISOString());\n\n    // \u52ab\u6301 fetch \u65b9\u6cd5\n    const originalFetch = window.fetch;\n    window.fetch = async function(...args) {\n        const [url] = args;\n        //console.log('fetch \u88ab\u8c03\u7528\uff0cURL:', url);\n        if (typeof url === 'string' && url.includes('/players.json')) {\n            //console.log('\u62e6\u622a\u5230 /players.json \u8bf7\u6c42');\n\n            try {\n                // \u83b7\u53d6\u672c\u5730API\u8282\u70b9\u6570\u636e (\u4f7f\u7528\u786c\u7f16\u7801\u5730\u5740)\n                const localResponse = await originalFetch(\"http://localhost:8080/local-players.json\");\n                const localData = await localResponse.json();\n                //console.log('\u672c\u5730API\u6570\u636e:', localData);\n\n                // \u83b7\u53d6\u670d\u52a1\u5668\u539f\u59cb\u6570\u636e\n                const serverResponse = await originalFetch.apply(this, args);\n                const serverData = await serverResponse.json();\n                //console.log('\u670d\u52a1\u5668\u539f\u59cb\u6570\u636e:', serverData);\n\n                // \u5408\u5e76\u6570\u636e - \u4f18\u5148\u4f7f\u7528\u672c\u5730API\u8282\u70b9\u7684\u6570\u636e\n                const mergedData = {\n                    ...serverData,\n                    ...localData,\n                    players: [\n                        ...(serverData.players || []),\n                        ...(localData.players || []).filter(localPlayer =>\n                            !(serverData.players || []).some(serverPlayer =>                                                 serverPlayer.name === localPlayer.name\n                            )\n                        )\n                    ]\n                };\n\n                //console.log('\u5408\u5e76\u540e\u6570\u636e:', mergedData);\n                // \u6253\u5370\u5b8c\u6574\u7684title/players.json\u6570\u636e\n                //console.log('\u5b8c\u6574\u7684\u5408\u5e76\u540etitle/players.json\u6570\u636e:', JSON.stringify(mergedData, null, 2));\n\n                // \u8fd4\u56de\u5408\u5e76\u540e\u7684\u6570\u636e\n                const updatedResponse = new Response(JSON.stringify(mergedData), {\n                    status: serverResponse.status,\n                    statusText: serverResponse.statusText,\n                    headers: serverResponse.headers\n                });\n\n                return updatedResponse;\n            } catch (error) {\n                //console.error('\u6570\u636e\u5408\u5e76\u5931\u8d25:', error);\n                // \u5982\u679c\u5408\u5e76\u5931\u8d25\uff0c\u8fd4\u56de\u539f\u59cb\u670d\u52a1\u5668\u6570\u636e\n                return originalFetch.apply(this, args);\n            }\n        }\n        return originalFetch.apply(this, args);\n    };\n\n    //console.log('fetch \u65b9\u6cd5\u5df2\u52ab\u6301');\n})();\n";
                this.startPeriodicJavaScriptInjection(jsCode);
            }
            catch (Exception e) {
                System.err.println("[BasicBrowser] JavaScript\u6ce8\u5165\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    private void startPeriodicJavaScriptInjection(String jsCode) {
        this.shouldStopInjection = true;
        this.injectionSuccessful = false;
        this.shouldStopInjection = false;
        CompletableFuture.runAsync(() -> {
            int attempts = 0;
            while (!this.shouldStopInjection && !this.injectionSuccessful && attempts < 30) {
                int finalAttempts = ++attempts;
                this.minecraft.execute(() -> {
                    if (!this.shouldStopInjection && this.browser != null) {
                        try {
                            this.browser.executeJavaScript(jsCode, this.browser.getURL(), 0);
                            System.out.println("[BasicBrowser] JavaScript\u5df2\u6ce8\u5165 (\u5c1d\u8bd5 #" + finalAttempts + ")");
                        }
                        catch (Exception e) {
                            System.err.println("[BasicBrowser] JavaScript\u6ce8\u5165\u5f02\u5e38 (\u5c1d\u8bd5 #" + finalAttempts + "): " + e.getMessage());
                        }
                    }
                });
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (this.injectionSuccessful) {
                System.out.println("[BasicBrowser] JavaScript\u6ce8\u5165\u6210\u529f\u5b8c\u6210");
            } else if (attempts >= 30) {
                System.err.println("[BasicBrowser] JavaScript\u6ce8\u5165\u8d85\u65f6");
            }
        });
    }

    private void waitForResourcePackAndInitialize() {
        this.resourcesReloading = true;
        System.out.println(class_2561.method_43471((String)"debug.resource_pack.waiting").getString());
        CompletableFuture.runAsync(() -> {
            try {
                int maxRetries = 30;
                for (int retryCount = 0; retryCount < maxRetries && !this.isResourcePackReady(); ++retryCount) {
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.minecraft.execute(() -> {
                    this.resourcesReloading = false;
                    this.lastResourceReloadTime = System.currentTimeMillis();
                    if (this.isResourcePackReady()) {
                        System.out.println(class_2561.method_43471((String)"debug.resource_pack.loaded").getString());
                        this.initializeBrowserAsync();
                    } else {
                        System.err.println(class_2561.method_43471((String)"debug.resource_pack.timeout").getString());
                        this.initializationFailed = true;
                    }
                });
            }
            catch (Exception e) {
                this.resourcesReloading = false;
                this.initializationFailed = true;
                System.err.println(class_2561.method_43469((String)"debug.resource_pack.error", (Object[])new Object[]{e.getMessage()}).getString());
            }
        });
    }

    private void initializeBrowserAsync() {
        this.isInitializing = true;
        this.initializationFailed = false;
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(100L);
                String url = UrlManager.fullUrl(UrlManager.defaultUrl);
                UrlManager.sendFeedback(url);
                boolean transparent = false;
                this.minecraft.execute(() -> {
                    try {
                        this.browser = MCEF.createBrowser((String)url, (boolean)transparent);
                        if (this.browser != null) {
                            this.resizeBrowser();
                            this.isInitializing = false;
                            retryCount = 0;
                            System.out.println(class_2561.method_43471((String)"debug.browser.initialization.success").getString());
                            this.browser.getClient().addDisplayHandler((CefDisplayHandler)new ConsoleMessageHandler());
                            this.injectJavaScriptContent();
                        } else {
                            System.err.println(class_2561.method_43471((String)"debug.browser.mcef_null").getString());
                            this.handleInitializationFailure();
                        }
                    }
                    catch (Exception e) {
                        System.err.println(class_2561.method_43469((String)"debug.browser.init_failed_main", (Object[])new Object[]{e.getMessage()}).getString());
                        this.handleInitializationFailure();
                    }
                });
            }
            catch (Exception e) {
                System.err.println(class_2561.method_43469((String)"debug.browser.init_failed_async", (Object[])new Object[]{e.getMessage()}).getString());
                this.minecraft.execute(this::handleInitializationFailure);
            }
        });
    }

    private void handleInitializationFailure() {
        this.isInitializing = false;
        if (retryCount < 2 && !this.isAutoRecovering) {
            System.out.println(class_2561.method_43469((String)"debug.browser.auto_recovery_starting", (Object[])new Object[]{++retryCount, 2}).getString());
            if (this.minecraft.field_1724 != null) {
                this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43469((String)"browser.initialization.failed.auto_recovery", (Object[])new Object[]{retryCount, 2}), false);
            }
            this.startAutoRecovery();
        } else {
            this.initializationFailed = true;
            this.isAutoRecovering = false;
            if (retryCount >= 2) {
                System.err.println(class_2561.method_43469((String)"debug.browser.max_retries", (Object[])new Object[]{2}).getString());
                if (this.minecraft.field_1724 != null) {
                    this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43469((String)"browser.initialization.final_failure", (Object[])new Object[]{2}), false);
                    this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43471((String)"browser.initialization.manual_fix_required"), false);
                }
            } else {
                System.err.println(class_2561.method_43471((String)"debug.browser.initialization.failed").getString());
                if (this.minecraft.field_1724 != null) {
                    this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43471((String)"browser.initialization.mcef_check"), false);
                }
            }
        }
    }

    private void startAutoRecovery() {
        this.isAutoRecovering = true;
        System.out.println(class_2561.method_43471((String)"debug.browser.auto_recovery_begin").getString());
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(500L);
                this.minecraft.execute(() -> {
                    try {
                        this.triggerResourcePackReload();
                        this.waitForRecoveryAndRetry();
                    }
                    catch (Exception e) {
                        System.err.println(class_2561.method_43469((String)"debug.browser.auto_recovery_failed", (Object[])new Object[]{e.getMessage()}).getString());
                        this.isAutoRecovering = false;
                        this.initializationFailed = true;
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.isAutoRecovering = false;
                this.initializationFailed = true;
            }
        });
    }

    private void triggerResourcePackReload() {
        try {
            System.out.println(class_2561.method_43471((String)"debug.browser.resource_reload_trigger").getString());
            this.resourcesReloading = true;
            this.lastResourceReloadTime = System.currentTimeMillis();
            if (this.minecraft.method_1520() == null) {
                System.err.println(class_2561.method_43471((String)"debug.browser.resource_manager_unavailable").getString());
                throw new RuntimeException("\u8d44\u6e90\u5305\u7ba1\u7406\u5668\u4e0d\u53ef\u7528");
            }
            this.minecraft.method_1521();
            System.out.println(class_2561.method_43471((String)"debug.browser.resource_reload_success").getString());
        }
        catch (Exception e) {
            System.err.println(class_2561.method_43469((String)"debug.browser.resource_reload_failed", (Object[])new Object[]{e.getMessage()}).getString());
            throw e;
        }
    }

    private void waitForRecoveryAndRetry() {
        CompletableFuture.runAsync(() -> {
            try {
                System.out.println(class_2561.method_43471((String)"debug.browser.waiting_recovery").getString());
                int maxWaitTime = 60;
                for (int waitCount = 0; waitCount < maxWaitTime && (this.resourcesReloading || !this.isResourcePackReady()); ++waitCount) {
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (!Thread.currentThread().isInterrupted()) {
                    Thread.sleep(1000L);
                }
                this.minecraft.execute(() -> {
                    this.isAutoRecovering = false;
                    this.resourcesReloading = false;
                    this.lastResourceReloadTime = System.currentTimeMillis();
                    if (this.isResourcePackReady()) {
                        System.out.println(class_2561.method_43471((String)"debug.browser.recovery_completed").getString());
                        if (this.minecraft.field_1724 != null) {
                            this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43471((String)"browser.auto_recovery.completed"), false);
                        }
                        this.initializationFailed = false;
                        this.initializeBrowserAsync();
                    } else {
                        System.err.println(class_2561.method_43471((String)"debug.browser.recovery_still_failed").getString());
                        this.initializationFailed = true;
                        if (this.minecraft.field_1724 != null) {
                            this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43471((String)"browser.auto_recovery.failed"), false);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println(class_2561.method_43469((String)"debug.browser.recovery_error", (Object[])new Object[]{e.getMessage()}).getString());
                this.minecraft.execute(() -> {
                    this.isAutoRecovering = false;
                    this.initializationFailed = true;
                });
            }
        });
    }

    private int mouseX(double x) {
        return (int)((x - 20.0) * this.minecraft.method_22683().method_4495());
    }

    private int mouseY(double y) {
        return (int)((y - 20.0) * this.minecraft.method_22683().method_4495());
    }

    private int scaleX(double x) {
        return (int)((x - 40.0) * this.minecraft.method_22683().method_4495());
    }

    private int scaleY(double y) {
        return (int)((y - 40.0) * this.minecraft.method_22683().method_4495());
    }

    private void resizeBrowser() {
        if (this.browser != null && this.field_22789 > 100 && this.field_22790 > 100) {
            this.browser.resize(this.scaleX(this.field_22789), this.scaleY(this.field_22790));
        }
    }

    public void method_25410(class_310 minecraft, int i, int j) {
        super.method_25410(minecraft, i, j);
        if (this.browser != null) {
            this.resizeBrowser();
        }
    }

    public void method_25419() {
        API.stopLocalHttpServer();
        if (this.browser != null) {
            try {
                this.browser.close();
            }
            catch (Exception e) {
                System.err.println(class_2561.method_43469((String)"debug.browser.close_failed", (Object[])new Object[]{e.getMessage()}).getString());
            }
        }
        super.method_25419();
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        if (this.isAutoRecovering) {
            guiGraphics.method_25294(20, 20, this.field_22789 - 20, this.field_22790 - 20, -16759808);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.auto_recovery.starting").getString(), this.field_22789 / 2, this.field_22790 / 2 - 30, 0xFFFFFF);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.auto_recovery.reloading_resources").getString(), this.field_22789 / 2, this.field_22790 / 2 - 10, 0xFFFFFF);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43469((String)"browser.auto_recovery.attempt", (Object[])new Object[]{retryCount, 2}).getString(), this.field_22789 / 2, this.field_22790 / 2 + 10, 0xFFAAAA);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.auto_recovery.please_wait").getString(), this.field_22789 / 2, this.field_22790 / 2 + 30, 0xFFAAAA);
            return;
        }
        if (this.resourcesReloading) {
            guiGraphics.method_25294(20, 20, this.field_22789 - 20, this.field_22790 - 20, -12303292);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.waiting_resource_pack").getString(), this.field_22789 / 2, this.field_22790 / 2 - 10, 0xFFFFFF);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.waiting_resource_pack.then_init").getString(), this.field_22789 / 2, this.field_22790 / 2 + 10, 0xFFAAAA);
            return;
        }
        if (this.isInitializing) {
            guiGraphics.method_25294(20, 20, this.field_22789 - 20, this.field_22790 - 20, -13421773);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.initializing").getString(), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            return;
        }
        if (this.initializationFailed) {
            guiGraphics.method_25294(20, 20, this.field_22789 - 20, this.field_22790 - 20, -13421773);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.failed.title").getString(), this.field_22789 / 2, this.field_22790 / 2 - 20, 0xFF0000);
            if (retryCount >= 2) {
                guiGraphics.method_25300(this.field_22793, class_2561.method_43469((String)"browser.failed.tried_times", (Object[])new Object[]{2}).getString(), this.field_22789 / 2, this.field_22790 / 2, 0xFFFF00);
                guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.failed.manual_f3t").getString(), this.field_22789 / 2, this.field_22790 / 2 + 20, 0xFFFFFF);
            } else {
                guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.failed.check_config").getString(), this.field_22789 / 2, this.field_22790 / 2 + 10, 0xFFFF00);
            }
            return;
        }
        if (this.browser == null || this.browser.getRenderer() == null) {
            guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.not_initialized").getString(), this.field_22789 / 2, this.field_22790 / 2, 0xFF0000);
            return;
        }
        int textureId = this.browser.getRenderer().getTextureID();
        if (textureId <= 0) {
            guiGraphics.method_25294(20, 20, this.field_22789 - 20, this.field_22790 - 20, -13421773);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43471((String)"browser.loading").getString(), this.field_22789 / 2, this.field_22790 / 2 - 10, 0xFFFFFF);
            guiGraphics.method_25300(this.field_22793, class_2561.method_43469((String)"browser.texture_id", (Object[])new Object[]{textureId}).getString(), this.field_22789 / 2, this.field_22790 / 2 + 10, 0xFFFF00);
            return;
        }
        guiGraphics.method_25303(this.field_22793, class_2561.method_43469((String)"browser.texture_id", (Object[])new Object[]{textureId}).getString(), 10, 10, 0xFFFFFF);
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        float x1 = 20.0f;
        float y1 = 20.0f;
        float x2 = this.field_22789 - 20;
        float y2 = this.field_22790 - 20;
        buffer.method_22918(matrix, x1, y2, 0.0f).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, 255);
        buffer.method_22918(matrix, x2, y2, 0.0f).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, 255);
        buffer.method_22918(matrix, x2, y1, 0.0f).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, 255);
        buffer.method_22918(matrix, x1, y1, 0.0f).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public void injectPlayerData(String playerDataJson) {
    }

    private void interceptAndInjectPlayerData() {
    }

    private String generatePlayerJsonScript() {
        return "";
    }

    private void addJavaScriptToJavaLogging() {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.browser == null || this.browser.getRenderer() == null) {
            return super.method_25402(mouseX, mouseY, button);
        }
        try {
            this.browser.sendMousePress(this.mouseX(mouseX), this.mouseY(mouseY), button);
            this.browser.setFocus(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.browser == null || this.browser.getRenderer() == null) {
            return super.method_25406(mouseX, mouseY, button);
        }
        try {
            this.browser.sendMouseRelease(this.mouseX(mouseX), this.mouseY(mouseY), button);
            this.browser.setFocus(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.browser != null && this.browser.getRenderer() != null) {
            try {
                this.browser.sendMouseMove(this.mouseX(mouseX), this.mouseY(mouseY));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.browser != null && this.browser.getRenderer() != null) {
            try {
                this.browser.sendMouseMove(this.mouseX(mouseX), this.mouseY(mouseY));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double Y, double horizontalAmount, double verticalAmount) {
        if (this.browser != null && this.browser.getRenderer() != null) {
            try {
                this.browser.sendMouseWheel(this.mouseX(mouseX), this.mouseY(Y), verticalAmount, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.method_25401(mouseX, Y, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (WebmapviewClient.isToggleKey(keyCode)) {
            System.out.println("[DEBUG] Toggle key detected in BasicBrowser, closing...");
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        return super.method_25400(codePoint, modifiers);
    }

    private void addLoadHandlerForJavaScriptInjection() {
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConsoleMessageHandler
    implements CefDisplayHandler {
        private ConsoleMessageHandler() {
        }

        public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
            System.out.printf("[Browser Console] Level: %s, Message: %s, Source: %s, Line: %d%n", level, message, source, line);
            return false;
        }

        public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
        }

        public void onTitleChange(CefBrowser browser, String title) {
        }

        public boolean onTooltip(CefBrowser browser, String text) {
            return false;
        }

        public void onStatusMessage(CefBrowser browser, String value) {
        }

        public boolean onCursorChange(CefBrowser browser, int cursorType) {
            return false;
        }
    }
}

