/*
 * Decompiled with CFR 0.152.
 */
package fun.xingwangzhe.webmapview.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PlayerInformation {
    private String uuid;
    private String name;
    private String displayName;
    private double x;
    private double z;
    private String world;
    private double yaw;
    private int health;
    private int armor;
    private String headUrl;
    private boolean isVirtual;
    private String icon;

    public PlayerInformation(String uuid, String name, String displayName, double x, double z, String world, double yaw, int health, int armor, String headUrl, boolean isVirtual, String icon) {
        this.uuid = uuid;
        this.name = name;
        this.displayName = displayName;
        this.x = x;
        this.z = z;
        this.world = world;
        this.yaw = yaw;
        this.health = health;
        this.armor = armor;
        this.headUrl = headUrl;
        this.isVirtual = isVirtual;
        this.icon = icon;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public double getYaw() {
        return this.yaw;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public int getArmor() {
        return this.armor;
    }

    public void setArmor(int armor) {
        this.armor = armor;
    }

    public String getHeadUrl() {
        return this.headUrl;
    }

    public void setHeadUrl(String headUrl) {
        this.headUrl = headUrl;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean virtual) {
        this.isVirtual = virtual;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public static String generatePlayerJson(List<PlayerInformation> players, int maxPlayers, boolean includeVirtual) {
        Gson gson = new Gson();
        JsonObject root = new JsonObject();
        root.addProperty("max", (Number)maxPlayers);
        JsonArray playersArray = new JsonArray();
        for (PlayerInformation player : players) {
            if (!includeVirtual && player.isVirtual()) continue;
            JsonObject playerJson = new JsonObject();
            playerJson.addProperty("uuid", player.getUuid());
            playerJson.addProperty("name", player.getName());
            playerJson.addProperty("display_name", player.getDisplayName());
            playerJson.addProperty("x", (Number)player.getX());
            playerJson.addProperty("y", (Number)66);
            playerJson.addProperty("z", (Number)player.getZ());
            playerJson.addProperty("world", player.getWorld());
            playerJson.addProperty("yaw", (Number)player.getYaw());
            playerJson.addProperty("health", (Number)player.getHealth());
            playerJson.addProperty("armor", (Number)player.getArmor());
            playerJson.addProperty("is_virtual", Boolean.valueOf(player.isVirtual()));
            playersArray.add((JsonElement)playerJson);
        }
        root.add("players", (JsonElement)playersArray);
        return gson.toJson((JsonElement)root);
    }
}

