/*
 * Decompiled with CFR 0.152.
 */
package fun.xingwangzhe.webmapview.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class UrlManager {
    private static final String URL_FILE_NAME = "urls.txt";
    private static final String DEFAULT_URL_FILE_NAME = "default_url.txt";
    private static List<String> urlList = new ArrayList<String>();
    public static String defaultUrl = "squaremap-demo.jpenilla.xyz";
    public static boolean webmapview = true;

    public static void addUrl(String url) {
        if (!urlList.contains(url)) {
            urlList.add(url);
            UrlManager.saveUrls();
            UrlManager.sendFeedback((class_2561)class_2561.method_43469((String)"feedback.url.added", (Object[])new Object[]{url}));
        } else {
            UrlManager.sendFeedback((class_2561)class_2561.method_43469((String)"feedback.url.exists", (Object[])new Object[]{url}));
        }
    }

    public static void setDefaultUrl(String url) {
        if (urlList.contains(url)) {
            defaultUrl = url;
            UrlManager.saveDefaultUrl();
            UrlManager.sendFeedback((class_2561)class_2561.method_43469((String)"feedback.default.url.updated", (Object[])new Object[]{url}));
        } else {
            UrlManager.sendFeedback((class_2561)class_2561.method_43469((String)"feedback.url.not_found", (Object[])new Object[]{url}));
        }
    }

    public static List<String> getUrlList() {
        return urlList;
    }

    public static String getDefaultUrl() {
        return defaultUrl;
    }

    private static void saveUrls() {
        Path configPath = UrlManager.getConfigDirectory().resolve(URL_FILE_NAME);
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            for (String url : urlList) {
                writer.write(url);
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadUrls() {
        Path configPath = UrlManager.getConfigDirectory().resolve(URL_FILE_NAME);
        urlList.clear();
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                String line;
                while ((line = reader.readLine()) != null) {
                    urlList.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void saveDefaultUrl() {
        Path defaultUrlPath = UrlManager.getConfigDirectory().resolve(DEFAULT_URL_FILE_NAME);
        try (BufferedWriter writer = Files.newBufferedWriter(defaultUrlPath, new OpenOption[0]);){
            if (defaultUrl != null && !defaultUrl.trim().isEmpty()) {
                writer.write(defaultUrl);
            } else {
                Files.deleteIfExists(defaultUrlPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadDefaultUrl() {
        Path defaultUrlPath = UrlManager.getConfigDirectory().resolve(DEFAULT_URL_FILE_NAME);
        if (Files.exists(defaultUrlPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(defaultUrlPath);){
                String line = reader.readLine();
                if (line != null) {
                    defaultUrl = line;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static Path getConfigDirectory() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return configDir;
    }

    public static void sendFeedback(String message) {
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)message), false);
        }
    }

    public static void sendFeedback(class_2561 textMessage) {
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353(textMessage, false);
        }
    }

    public static void removeUrl(String url) {
        if (urlList.remove(url)) {
            UrlManager.saveUrls();
            if (defaultUrl != null && defaultUrl.equals(url)) {
                UrlManager.clearDefaultUrl();
            }
            UrlManager.sendFeedback((class_2561)class_2561.method_43469((String)"feedback.url.removed", (Object[])new Object[]{url}));
        } else {
            UrlManager.sendFeedback((class_2561)class_2561.method_43469((String)"feedback.url.not_found", (Object[])new Object[]{url}));
        }
    }

    private static void clearDefaultUrl() {
        defaultUrl = null;
        Path defaultUrlPath = UrlManager.getConfigDirectory().resolve(DEFAULT_URL_FILE_NAME);
        try {
            Files.deleteIfExists(defaultUrlPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String fullUrl(String baseUrl) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null || !webmapview) {
            UrlManager.sendFeedback((class_2561)class_2561.method_43471((String)"feedback.player_or_world_not_available"));
            return baseUrl;
        }
        int playerX = (int)client.field_1724.method_23317();
        int playerZ = (int)client.field_1724.method_23321();
        String worldName = client.field_1687.method_27983().method_29177().toString();
        if (Objects.equals(worldName, "minecraft:overworld")) {
            worldName = "world";
        } else if (Objects.equals(worldName, "minecraft:the_nether")) {
            worldName = "world_nether";
        } else if (Objects.equals(worldName, "minecraft:the_end")) {
            worldName = "world_the_end";
        }
        StringBuilder fullUrlBuilder = new StringBuilder();
        if (!baseUrl.startsWith("http://") && !baseUrl.startsWith("https://")) {
            fullUrlBuilder.append("https://");
        }
        fullUrlBuilder.append(baseUrl).append("/");
        if (!baseUrl.contains("?")) {
            fullUrlBuilder.append("?");
        } else {
            fullUrlBuilder.append("&");
        }
        fullUrlBuilder.append("x=").append(playerX).append("&z=").append(playerZ).append("&zoom=").append("4").append("&world=").append(worldName);
        return fullUrlBuilder.toString();
    }

    static {
        UrlManager.loadUrls();
        UrlManager.loadDefaultUrl();
    }
}

