/*
 * Decompiled with CFR 0.152.
 */
package fun.xingwangzhe.webmapview.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fun.xingwangzhe.webmapview.client.BasicBrowser;
import fun.xingwangzhe.webmapview.client.UrlManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class WebmapviewClient
implements ClientModInitializer {
    private class_304 keyBinding;
    private static WebmapviewClient instance;
    private static long lastResourcePackCheckTime;

    private static CompletableFuture<Suggestions> suggestUrls(CommandContext<?> context, SuggestionsBuilder builder) {
        List<String> urls = UrlManager.getUrlList();
        urls.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static class_304 getToggleKeyBinding() {
        return instance != null ? WebmapviewClient.instance.keyBinding : null;
    }

    public static boolean isToggleKey(int keyCode) {
        class_304 binding = WebmapviewClient.getToggleKeyBinding();
        if (binding != null) {
            return binding.method_1417(keyCode, 0);
        }
        return false;
    }

    private static boolean isResourcePackFullyLoaded() {
        try {
            class_310 minecraft = class_310.method_1551();
            if (minecraft.method_1478() == null) {
                return false;
            }
            if (minecraft.method_1531() == null) {
                return false;
            }
            if (minecraft.field_1772 == null) {
                return false;
            }
            if (minecraft.method_22683() == null || minecraft.method_22683().method_4490() == 0L) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastResourcePackCheckTime < 3000L) {
                return false;
            }
            lastResourcePackCheckTime = currentTime;
            return true;
        }
        catch (Exception e) {
            System.err.println(class_2561.method_43469((String)"debug.resource_pack.check_failed", (Object[])new Object[]{e.getMessage()}).getString());
            return false;
        }
    }

    public void onInitializeClient() {
        instance = this;
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"urladd").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String url = StringArgumentType.getString((CommandContext)context, (String)"url");
                UrlManager.addUrl(url);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"urlremove").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.string()).suggests(WebmapviewClient::suggestUrls).executes(context -> {
                String url = StringArgumentType.getString((CommandContext)context, (String)"url");
                UrlManager.removeUrl(url);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"urllist").executes(context -> {
                List<String> urls = UrlManager.getUrlList();
                StringBuilder listMessage = new StringBuilder("Available URLs:\n");
                for (int i = 0; i < urls.size(); ++i) {
                    listMessage.append(i + 1).append(": ").append(urls.get(i)).append("\n");
                }
                ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)listMessage.toString()));
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"urlset").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.string()).suggests(WebmapviewClient::suggestUrls).executes(context -> {
                String url = StringArgumentType.getString((CommandContext)context, (String)"url");
                UrlManager.setDefaultUrl(url);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"webmapviewoption").then(ClientCommandManager.argument((String)"url", (ArgumentType)StringArgumentType.string()).executes(context -> {
                boolean bl = UrlManager.webmapview = !UrlManager.webmapview;
                if (UrlManager.webmapview) {
                    UrlManager.sendFeedback("webmapview is enabled");
                } else {
                    UrlManager.sendFeedback("webmapview is not enabled");
                }
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"webmapview").then(ClientCommandManager.literal((String)"help").executes(context -> {
                String helpMessage = "/urladd: " + class_2561.method_43471((String)"command.urladd.description").getString() + "\n/urlremove: " + class_2561.method_43471((String)"command.urlremove.description").getString() + "\n/urllist: " + class_2561.method_43471((String)"command.urllist.description").getString() + "\n/urlset: " + class_2561.method_43471((String)"command.urlset.description").getString() + "\n/webmapviewoption: " + class_2561.method_43471((String)"command.webmapviewoption.description").getString() + "\n";
                UrlManager.sendFeedback(helpMessage);
                return 1;
            })));
        });
        this.keyBinding = new class_304("key.webmapview.open_basic_browser", 72, "category.webmapview");
        KeyBindingHelper.registerKeyBinding((class_304)this.keyBinding);
        class_310 minecraft = class_310.method_1551();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            block7: {
                if (this.keyBinding.method_1436()) {
                    System.out.println("[DEBUG] KeyBinding detected! Current screen: " + (minecraft.field_1755 == null ? "null" : minecraft.field_1755.getClass().getSimpleName()));
                    if (minecraft.field_1755 instanceof BasicBrowser) {
                        System.out.println("[DEBUG] Closing BasicBrowser");
                        minecraft.method_1507(null);
                    } else {
                        System.out.println("[DEBUG] Opening BasicBrowser");
                        if (!WebmapviewClient.isResourcePackFullyLoaded()) {
                            if (minecraft.field_1724 != null) {
                                minecraft.field_1724.method_7353((class_2561)class_2561.method_43471((String)"browser.resource_pack.not_loaded"), false);
                            }
                            System.out.println(class_2561.method_43471((String)"debug.key_handler.resource_not_ready").getString());
                            return;
                        }
                        try {
                            System.out.println(class_2561.method_43471((String)"browser.resource_pack.ready").getString());
                            minecraft.method_1507((class_437)new BasicBrowser((class_2561)class_2561.method_43471((String)"browser.title")));
                        }
                        catch (Exception e) {
                            System.err.println(class_2561.method_43469((String)"debug.key_handler.creation_failed", (Object[])new Object[]{e.getMessage()}).getString());
                            if (minecraft.field_1724 == null) break block7;
                            minecraft.field_1724.method_7353((class_2561)class_2561.method_43471((String)"browser.creation.failed"), false);
                        }
                    }
                }
            }
        });
    }

    static {
        lastResourcePackCheckTime = 0L;
    }
}

