/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan123.heartcanisters.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class Common {
    public static ForgeConfigSpec.BooleanValue limitUses;
    public static ForgeConfigSpec.DoubleValue canisterIncreaseValue;
    public static ForgeConfigSpec.DoubleValue heartHealValue;
    public static ForgeConfigSpec.IntValue canisterMaxUses;
    public static ForgeConfigSpec.IntValue goldenHeartTicksDuration;
    public static ForgeConfigSpec.BooleanValue dropNormalOnlyMissingHP;
    public static ForgeConfigSpec.BooleanValue dropGoldenOnlyFullyHP;
    public static ForgeConfigSpec.IntValue normalDropChance;
    public static ForgeConfigSpec.IntValue goldenDropChance;

    public static void init(ForgeConfigSpec.Builder common) {
        common.comment("Common Config");
        limitUses = common.comment("Sets the canister use limitable.").define("common.limitUses", false);
        canisterMaxUses = common.comment("Only works if limitUses is true. Sets the max uses for canisters.").defineInRange("common.canisterMaxUses", 50, 1, 10000);
        canisterIncreaseValue = common.comment("Sets the health value increment of canisters.").defineInRange("common.canisterIncreaseValue", 2.0, 1.0, 1000.0);
        heartHealValue = common.comment("Sets the heal value of normal hearts.").defineInRange("common.heartHealValue", 1.0, 1.0, 1000.0);
        goldenHeartTicksDuration = common.comment("Duration of absorption effect. (20 ticks = 1 second)").defineInRange("common.goldenHeartTicksDuration", 2400, 1, 10000);
        dropNormalOnlyMissingHP = common.comment(new String[]{"Drops normal hearts only when not on full hp. Not suggested to change this.", "It could ruin its purpose and make it a lot easier to have hearts in the inventory."}).define("common.dropNormalOnlyMissingHP", true);
        dropGoldenOnlyFullyHP = common.comment("Drops golden hearts only when on full hp. Not suggested to change this.").define("common.dropGoldenOnlyFullyHP", true);
        normalDropChance = common.comment("Sets the drop chance of normal hearts in percentage.").defineInRange("common.normalDropChance", 25, 1, 100);
        goldenDropChance = common.comment("Sets the drop chance of golden hearts in percentage.").defineInRange("common.goldenDropChance", 5, 1, 100);
    }
}

