/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan123.heartcanisters;

import com.baranhan123.heartcanisters.config.Config;
import com.baranhan123.heartcanisters.handlers.DataHandler;
import com.baranhan123.heartcanisters.handlers.DropsHandler;
import com.baranhan123.heartcanisters.handlers.TickHandler;
import com.baranhan123.heartcanisters.items.CanisterItem;
import com.baranhan123.heartcanisters.items.HeartItem;
import com.baranhan123.heartcanisters.items.ItemsList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="heartcanisters")
public class Main {
    public static final String MOD_ID = "heartcanisters";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"heartcanisters");
    public static final RegistryObject<CreativeModeTab> HEART_CANISTERS_TAB = CREATIVE_MODE_TABS.register("heartcanisters", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257737_(() -> new ItemStack((ItemLike)ItemsList.cut_diamond)).m_257941_((Component)Component.m_237113_((String)"Health Canisters")).m_257501_((parameters, output) -> {
        output.m_246326_((ItemLike)ItemsList.heart);
        output.m_246326_((ItemLike)ItemsList.golden_heart);
        output.m_246326_((ItemLike)ItemsList.cut_diamond);
        output.m_246326_((ItemLike)ItemsList.canister_base);
        output.m_246326_((ItemLike)ItemsList.empty_canister);
        output.m_246326_((ItemLike)ItemsList.heart_canister);
    }).m_257652_());

    public Main() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        CREATIVE_MODE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.loadConfig(Config.configcommon, FMLPaths.CONFIGDIR.get().resolve("heartcanisters-common.toml").toString());
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new DataHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DropsHandler());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegisterEvent e) {
            e.register(ForgeRegistries.Keys.ITEMS, h -> {
                ItemsList.heart = new HeartItem(new Item.Properties());
                h.register(new ResourceLocation(Main.MOD_ID, "heart"), (Object)ItemsList.heart);
                ItemsList.cut_diamond = new Item(new Item.Properties());
                h.register(new ResourceLocation(Main.MOD_ID, "cut_diamond"), (Object)ItemsList.cut_diamond);
                ItemsList.canister_base = new Item(new Item.Properties());
                h.register(new ResourceLocation(Main.MOD_ID, "canister_base"), (Object)ItemsList.canister_base);
                ItemsList.empty_canister = new CanisterItem(new Item.Properties().m_41487_(1));
                h.register(new ResourceLocation(Main.MOD_ID, "empty_canister"), (Object)ItemsList.empty_canister);
                ItemsList.heart_canister = new CanisterItem(new Item.Properties().m_41487_(1));
                h.register(new ResourceLocation(Main.MOD_ID, "heart_canister"), (Object)ItemsList.heart_canister);
                ItemsList.golden_heart = new HeartItem(new Item.Properties());
                h.register(new ResourceLocation(Main.MOD_ID, "golden_heart"), (Object)ItemsList.golden_heart);
            });
        }
    }
}

