/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.NbtOreConfiguration;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5821;
import net.minecraft.class_7225;

public class BlockEntityCombOre
extends class_3031<NbtOreConfiguration> {
    private static final Map<class_5321<class_1937>, Map<Long, class_2791>> CACHED_CHUNKS_ALL_WORLDS = new WeakHashMap<class_5321<class_1937>, Map<Long, class_2791>>();

    public BlockEntityCombOre(Codec<NbtOreConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean method_13151(class_5821<NbtOreConfiguration> context) {
        ModCompat compat;
        class_2338.class_2339 blockposMutable = new class_2338.class_2339();
        float angleOfRotation = (float)(Math.PI * (double)context.method_33654().method_43057());
        float sinOfAngle = class_3532.method_15374((float)angleOfRotation);
        float cosOfAngle = class_3532.method_15362((float)angleOfRotation);
        float size = (float)((NbtOreConfiguration)context.method_33656()).size * 0.5f;
        float stretchedFactor = 0.7f;
        if (((NbtOreConfiguration)context.method_33656()).size < 10) {
            stretchedFactor = 1.0f;
        }
        int maxY = (int)(size / 3.0f);
        int minY = -maxY - 1;
        class_2487 stateNbt = ((NbtOreConfiguration)context.method_33656()).targetStates.get((int)0).stateNbt;
        OptionalBoolean data = OptionalBoolean.EMPTY;
        Iterator<ModCompat> iterator = ModChecker.COMB_ORE_COMPATS.iterator();
        while (iterator.hasNext() && !(data = (compat = iterator.next()).validateCombType(stateNbt)).isPresent()) {
        }
        if (data.isEmpty()) {
            return false;
        }
        for (int y = minY; y <= maxY; ++y) {
            float yModified = y;
            if (y < 0) {
                yModified = (float)y + 0.25f;
            } else if (y > 0) {
                y = (int)((float)y + 0.5f);
            }
            float percentageOfRadius = 1.0f - yModified / size * (yModified / size) * 3.0f;
            float majorRadiusSq = size * percentageOfRadius * (size * percentageOfRadius);
            float minorRadiusSq = size * stretchedFactor * percentageOfRadius * (size * stretchedFactor * percentageOfRadius);
            int x = (int)(-size);
            while ((float)x < size) {
                int z = (int)(-size);
                while ((float)z < size) {
                    float majorComp = ((float)x + 0.5f) * cosOfAngle - ((float)z + 0.5f) * sinOfAngle;
                    float minorComp = ((float)x + 0.5f) * sinOfAngle + ((float)z + 0.5f) * cosOfAngle;
                    float result = majorComp * majorComp / (majorRadiusSq * majorRadiusSq) + minorComp * minorComp / (minorRadiusSq * minorRadiusSq);
                    if (result * 100.0f < 1.0f && (x != 0 || z != 0 || !((float)(y * y) >= size * size))) {
                        blockposMutable.method_10103(context.method_33655().method_10263() + x, context.method_33655().method_10264() + y, context.method_33655().method_10260() + z);
                        class_2791 cachedChunk = this.getCachedChunk((class_5425)context.method_33652(), (class_2338)blockposMutable);
                        class_2680 blockToReplace = cachedChunk.method_8320((class_2338)blockposMutable);
                        for (NbtOreConfiguration.TargetBlockState targetBlockState : ((NbtOreConfiguration)context.method_33656()).targetStates) {
                            if (!targetBlockState.target.method_16768(blockToReplace, context.method_33654())) continue;
                            cachedChunk.method_12010((class_2338)blockposMutable, targetBlockState.state, false);
                            class_2586 blockentity = ((class_2343)targetBlockState.state.method_26204()).method_10123((class_2338)blockposMutable, targetBlockState.state);
                            if (blockentity == null) {
                                return false;
                            }
                            blockentity.method_58690(targetBlockState.stateNbt, (class_7225.class_7874)context.method_33652().method_30349());
                            cachedChunk.method_12007(blockentity);
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
        return true;
    }

    public class_2791 getCachedChunk(class_5425 world, class_2338 blockpos) {
        long posLong;
        class_2791 cachedChunk;
        class_5321 worldKey = world.method_8410().method_27983();
        Map worldStorage = CACHED_CHUNKS_ALL_WORLDS.computeIfAbsent((class_5321<class_1937>)worldKey, k -> new WeakHashMap());
        if (worldStorage.size() > 9) {
            worldStorage.clear();
        }
        if ((cachedChunk = (class_2791)worldStorage.get(posLong = (long)(blockpos.method_10263() >> 4) & 0xFFFFFFFFL | ((long)(blockpos.method_10260() >> 4) & 0xFFFFFFFFL) << 32)) == null) {
            cachedChunk = world.method_22350(blockpos);
            worldStorage.put(posLong, cachedChunk);
        }
        return cachedChunk;
    }
}

