/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.datamanagers;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzTagsUpdatedEvent;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CrystallineFlowerDataManager
extends class_4309 {
    public static final CrystallineFlowerDataManager CRYSTALLINE_FLOWER_DATA_MANAGER = new CrystallineFlowerDataManager();
    public final List<FlowerData> cachedFlowerData = new ArrayList<FlowerData>();
    public final Map<class_1792, Pair<Integer, Boolean>> itemToXp = new Object2ObjectArrayMap();
    public Set<class_1792> disallowConsume = new HashSet<class_1792>();
    public boolean allowNormalConsumption = true;

    public CrystallineFlowerDataManager() {
        super(Bumblezone.GSON, "bz_crystalline_flower_data");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        this.itemToXp.clear();
        this.disallowConsume.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                DataResult mapDataResult = FlowerData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement);
                mapDataResult.resultOrPartial(s -> {}).ifPresent(this.cachedFlowerData::add);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse crystalline flower data file: {}", fileIdentifier, (Object)e);
            }
        });
    }

    public void resolveFlowerData(BzTagsUpdatedEvent event) {
        for (FlowerData flowerData : this.cachedFlowerData) {
            flowerData.allowNormalConsumption().ifPresent(b -> {
                this.allowNormalConsumption = b;
            });
            flowerData.disallowTag().flatMap(arg_0 -> ((class_7922)class_7923.field_41178).method_40266(arg_0)).ifPresent(tagItems -> tagItems.forEach(itemHolder -> this.disallowConsume.add((class_1792)itemHolder.comp_349())));
            flowerData.itemConsumeData().forEach(itemConsumeData -> class_7923.field_41178.method_40266(itemConsumeData.tag()).ifPresent(tagItems -> {
                for (class_6880 itemHolder : tagItems) {
                    if (itemConsumeData.maxXp) {
                        this.itemToXp.put((class_1792)itemHolder.comp_349(), (Pair<Integer, Boolean>)Pair.of((Object)itemConsumeData.xp, (Object)true));
                        continue;
                    }
                    Pair<Integer, Boolean> pair = this.itemToXp.get(itemHolder.comp_349());
                    if (pair != null && ((Integer)pair.getFirst() >= itemConsumeData.xp || ((Boolean)pair.getSecond()).booleanValue())) continue;
                    this.itemToXp.put((class_1792)itemHolder.comp_349(), (Pair<Integer, Boolean>)Pair.of((Object)itemConsumeData.xp, (Object)false));
                }
            }));
        }
        this.cachedFlowerData.clear();
    }

    public record FlowerData(List<ItemConsumeData> itemConsumeData, Optional<class_6862<class_1792>> disallowTag, Optional<Boolean> allowNormalConsumption) {
        public static final Codec<FlowerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemConsumeData.ENTRY_CODEC.listOf().fieldOf("item_consume_data").orElse(new ArrayList()).forGetter(e -> e.itemConsumeData), (App)class_6862.method_40090((class_5321)class_7924.field_41197).optionalFieldOf("do_not_consume_items_override").forGetter(e -> e.disallowTag), (App)Codec.BOOL.optionalFieldOf("allow_default_1_xp_item_consuming").forGetter(i -> i.allowNormalConsumption)).apply((Applicative)instance, instance.stable(FlowerData::new)));
    }

    public record ItemConsumeData(class_6862<class_1792> tag, int xp, boolean maxXp) {
        public static final Codec<ItemConsumeData> ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("tag").forGetter(i -> i.tag), (App)class_5699.field_33441.fieldOf("xp_granted").orElse((Object)1).forGetter(i -> i.xp), (App)Codec.BOOL.fieldOf("max_xp_granted").orElse((Object)false).forGetter(i -> i.maxXp)).apply((Applicative)instance, instance.stable(ItemConsumeData::new)));
    }
}

