/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.PotionCandleBlockEntity;
import com.telepathicgrunt.the_bumblezone.blocks.datamanagers.PotionCandleDataManager;
import com.telepathicgrunt.the_bumblezone.mixin.containers.ShapedRecipePatternAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import org.apache.commons.lang3.NotImplementedException;

public class PotionCandleRecipe
extends class_1852
implements class_3955 {
    private final String group;
    private final class_7710 category;
    private final int outputCount;
    private final int maxAllowedPotions;
    private final class_2371<class_1856> shapedRecipeItems;
    private final class_2371<class_1856> shapelessRecipeItems;
    private final class_1799 result;
    private final int width;
    private final int height;
    private final boolean allowNormalPotions;
    private final boolean allowSplashPotions;
    private final boolean allowLingeringPotions;
    private final int maxLevelCap;

    public PotionCandleRecipe(class_7710 category, String group, int outputCount, int maxAllowedPotions, class_2371<class_1856> shapedRecipeItems, class_2371<class_1856> shapelessRecipeItems, int width, int height, boolean allowNormalPotions, boolean allowSplashPotions, boolean allowLingeringPotions, int maxLevelCap) {
        super(category);
        this.group = group;
        this.category = category;
        this.outputCount = outputCount;
        this.maxAllowedPotions = maxAllowedPotions;
        this.shapedRecipeItems = shapedRecipeItems;
        this.shapelessRecipeItems = shapelessRecipeItems;
        this.result = PotionCandleRecipe.getResultStack(outputCount);
        this.width = width;
        this.height = height;
        this.allowNormalPotions = allowNormalPotions;
        this.allowSplashPotions = allowSplashPotions;
        this.allowLingeringPotions = allowLingeringPotions;
        this.maxLevelCap = maxLevelCap;
    }

    public int getMaxAllowedPotions() {
        return this.maxAllowedPotions;
    }

    public boolean getAllowNormalPotions() {
        return this.allowNormalPotions;
    }

    public boolean getAllowSplashPotions() {
        return this.allowSplashPotions;
    }

    public boolean getAllowLingeringPotions() {
        return this.allowLingeringPotions;
    }

    public int getMaxLevelCap() {
        return this.maxLevelCap;
    }

    public class_2371<class_1856> getShapedRecipeItems() {
        return this.shapedRecipeItems;
    }

    public class_2371<class_1856> getShapelessRecipeItems() {
        return this.shapelessRecipeItems;
    }

    private static class_1799 getResultStack(int outputCountIn) {
        class_1799 stack = ((class_1792)BzItems.POTION_CANDLE.get()).method_7854();
        stack.method_7939(outputCountIn);
        return stack;
    }

    public class_1799 assemble(class_9694 craftingInput, class_7225.class_7874 provider) {
        ArrayList effects = new ArrayList();
        AtomicInteger maxDuration = new AtomicInteger();
        AtomicInteger effectLevel = new AtomicInteger();
        AtomicInteger potionEffectsFound = new AtomicInteger();
        int splashCount = 0;
        int lingerCount = 0;
        for (int j = 0; j < craftingInput.method_59983(); ++j) {
            class_1799 itemStack = craftingInput.method_59984(j);
            if (!itemStack.method_31574(class_1802.field_8574) && !itemStack.method_31574(class_1802.field_8436) && !itemStack.method_31574(class_1802.field_8150)) continue;
            ((class_1844)itemStack.method_57824(class_9334.field_49651)).method_57397().forEach(me -> {
                effects.add((class_1291)me.method_5579().comp_349());
                maxDuration.addAndGet(((class_1291)me.method_5579().comp_349()).method_5561() ? 200 : me.method_5584());
                effectLevel.addAndGet(me.method_5578() + 1);
                potionEffectsFound.getAndIncrement();
            });
            if (itemStack.method_31574(class_1802.field_8436)) {
                ++splashCount;
            }
            if (!itemStack.method_31574(class_1802.field_8150)) continue;
            ++lingerCount;
        }
        if (effects.isEmpty()) {
            return PotionCandleRecipe.getResultStack(this.outputCount);
        }
        HashSet setPicker = new HashSet(effects);
        List<class_1291> filteredMobEffects = setPicker.stream().filter(e -> !GeneralUtils.isInTag(class_7923.field_41174, BzTags.DISALLOWED_POTION_CANDLE_EFFECTS, e)).toList();
        class_1291 chosenEffect = filteredMobEffects.get(new Random().nextInt(filteredMobEffects.size()));
        if (chosenEffect == null) {
            return PotionCandleRecipe.getResultStack(this.outputCount);
        }
        PotionCandleRecipe.balanceMainStats(chosenEffect, maxDuration, effectLevel, potionEffectsFound);
        effectLevel.set(Math.min(effectLevel.get(), this.maxLevelCap));
        return PotionCandleRecipe.createTaggedPotionCandle(chosenEffect, maxDuration, effectLevel, splashCount, lingerCount, this.outputCount);
    }

    public static void balanceMainStats(class_1291 chosenEffect, AtomicInteger maxDuration, AtomicInteger effectLevel, AtomicInteger potionEffectsFound) {
        effectLevel.set(effectLevel.get() / potionEffectsFound.get());
        if (PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.containsKey(chosenEffect)) {
            PotionCandleDataManager.OverrideData overrideData = PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.get(chosenEffect);
            effectLevel.set(GeneralUtils.constrainToRange(effectLevel.get(), overrideData.minLevelCap(), overrideData.maxLevelCap()));
        }
        float durationBaseMultiplier = 0.4f / (0.9f * (float)potionEffectsFound.get()) + (float)effectLevel.get() * 0.22f;
        float durationAdjustment = (float)potionEffectsFound.get() * durationBaseMultiplier;
        maxDuration.set((int)((float)maxDuration.get() / durationAdjustment));
        if (chosenEffect.method_5561()) {
            long thresholdTime = PotionCandleBlockEntity.getInstantEffectThresholdTime(effectLevel.intValue());
            int activationAmounts = (int)Math.ceil((double)maxDuration.intValue() / (double)thresholdTime);
            maxDuration.set((int)((long)activationAmounts * thresholdTime));
        }
        if (PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.containsKey(chosenEffect)) {
            PotionCandleDataManager.OverrideData overrideData = PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.get(chosenEffect);
            maxDuration.set(GeneralUtils.constrainToRange(maxDuration.get(), overrideData.minBurnDurationCap() * 20, overrideData.maxBurnDurationCap() * 20));
        }
    }

    public static class_1799 createTaggedPotionCandle(class_1291 chosenEffect, AtomicInteger maxDuration, AtomicInteger effectLevel, int splashCount, int lingerCount, int outputCount) {
        class_1799 resultStack = PotionCandleRecipe.getResultStack(outputCount);
        class_9279 customData = (class_9279)resultStack.method_57825(class_9334.field_49611, (Object)class_9279.field_49302);
        class_2487 blockEntityTag = customData.method_57461();
        blockEntityTag.method_10582("id", BzBlockEntities.POTION_CANDLE.getId().toString());
        blockEntityTag.method_10569("color", chosenEffect.method_5556());
        blockEntityTag.method_10569("amplifier", effectLevel.intValue());
        blockEntityTag.method_10569("max_duration", maxDuration.intValue());
        blockEntityTag.method_10582("status", class_7923.field_41174.method_10221((Object)chosenEffect).toString());
        blockEntityTag.method_10556("infinite", false);
        blockEntityTag.method_10569("range", 3 + splashCount * 2);
        if (chosenEffect.method_5561()) {
            blockEntityTag.method_10569("linger_time", 1);
        } else {
            PotionCandleRecipe.setLingerTime(chosenEffect, lingerCount, blockEntityTag, 60, effectLevel.get());
        }
        if (PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.containsKey(chosenEffect)) {
            PotionCandleDataManager.OverrideData overrideData = PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.get(chosenEffect);
            overrideData.baseLingerTime().ifPresent(baseLingerTime -> PotionCandleRecipe.setLingerTime(chosenEffect, lingerCount, blockEntityTag, baseLingerTime * 20, effectLevel.get()));
        }
        resultStack.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)blockEntityTag));
        return resultStack;
    }

    private static void setLingerTime(class_1291 chosenEffect, int lingerCount, class_2487 blockEntityTag, int baseLingerTime, int effectLevel) {
        int lingerTime = baseLingerTime + lingerCount * baseLingerTime * 2;
        if (PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.containsKey(chosenEffect)) {
            PotionCandleDataManager.OverrideData overrideData = PotionCandleDataManager.POTION_CANDLE_DATA_MANAGER.effectToOverrideStats.get(chosenEffect);
            lingerTime = Math.min(lingerTime, overrideData.maxBurnDurationCap() * 20);
        }
        if (!chosenEffect.method_5561()) {
            int intervalCalced = PotionCandleBlockEntity.createIntervalTimeForEffectApply((class_6880<class_1291>)class_6880.method_40223((Object)chosenEffect), effectLevel, lingerTime);
            lingerTime += intervalCalced;
            blockEntityTag.method_10569("calculated_effect_apply_interval", intervalCalced);
        }
        blockEntityTag.method_10569("linger_time", lingerTime);
    }

    public boolean method_8113(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.result;
    }

    public boolean matches(class_9694 craftingInput, class_1937 level) {
        boolean shapedMatch = false;
        for (int column = 0; column <= craftingInput.method_59991() - this.width; ++column) {
            for (int row = 0; row <= craftingInput.method_59992() - this.height; ++row) {
                if (this.matches(craftingInput, column, row, true)) {
                    shapedMatch = true;
                }
                if (!this.matches(craftingInput, column, row, false)) continue;
                shapedMatch = true;
            }
        }
        return shapedMatch;
    }

    private boolean matches(class_9694 craftingInput, int width, int height, boolean mirrored) {
        int potionCount = 0;
        ArrayList<class_1799> secondaryIngredientsFound = new ArrayList<class_1799>();
        ObjectArrayList mobEffects = new ObjectArrayList();
        for (int column = 0; column < craftingInput.method_59991(); ++column) {
            for (int row = 0; row < craftingInput.method_59992(); ++row) {
                class_1799 itemStack = craftingInput.method_59984(column + row * craftingInput.method_59991());
                int k = column - width;
                int l = row - height;
                class_1856 ingredient = null;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirrored ? (class_1856)this.shapedRecipeItems.get(this.width - k - 1 + l * this.width) : (class_1856)this.shapedRecipeItems.get(k + l * this.width);
                }
                if (ingredient == null) {
                    if (itemStack.method_7960()) continue;
                    if (itemStack.method_31574(class_1802.field_8574) || itemStack.method_31574(class_1802.field_8436) || itemStack.method_31574(class_1802.field_8150)) {
                        if (itemStack.method_31574(class_1802.field_8574) && !this.allowNormalPotions) {
                            return false;
                        }
                        if (itemStack.method_31574(class_1802.field_8436) && !this.allowSplashPotions) {
                            return false;
                        }
                        if (itemStack.method_31574(class_1802.field_8150) && !this.allowLingeringPotions) {
                            return false;
                        }
                        ArrayList currentMobEffects = new ArrayList();
                        ((class_1844)itemStack.method_57824(class_9334.field_49651)).method_57397().forEach(currentMobEffects::add);
                        mobEffects.addAll(currentMobEffects);
                        if (currentMobEffects.isEmpty()) {
                            return false;
                        }
                        if (++potionCount <= this.maxAllowedPotions) continue;
                        return false;
                    }
                    secondaryIngredientsFound.add(itemStack);
                    continue;
                }
                if (ingredient.method_8093(itemStack)) continue;
                return false;
            }
        }
        if (mobEffects.stream().allMatch(e -> e.method_5579().method_40220(BzTags.DISALLOWED_POTION_CANDLE_EFFECTS))) {
            return false;
        }
        return potionCount > 0 && GeneralUtils.listMatches(secondaryIngredientsFound, this.shapelessRecipeItems);
    }

    public class_1865<?> method_8119() {
        return (class_1865)BzRecipes.POTION_CANDLE_RECIPE.get();
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_10211();
        ingredients.addAll(this.shapelessRecipeItems);
        ingredients.addAll(this.shapedRecipeItems);
        return ingredients;
    }

    public boolean method_8118() {
        return true;
    }

    public class_3956<?> method_17716() {
        return class_3956.field_17545;
    }

    public class_7710 method_45441() {
        return this.category;
    }

    public static class Serializer
    implements class_1865<PotionCandleRecipe> {
        private static final MapCodec<PotionCandleRecipe> CODEC = RawPotionRecipe.CODEC.flatXmap(rawShapedRecipe -> {
            String[] strings = ShapedRecipePatternAccessor.bumblezone$callShrink(rawShapedRecipe.shapedPattern);
            int width = strings[0].length();
            int height = strings.length;
            class_2371 shapedRecipeItems = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            HashSet set = Sets.newHashSet(rawShapedRecipe.shapedKey.keySet());
            for (int k = 0; k < strings.length; ++k) {
                String string = strings[k];
                for (int l = 0; l < string.length(); ++l) {
                    class_1856 ingredient;
                    String string2 = string.substring(l, l + 1);
                    class_1856 class_18562 = ingredient = string2.equals(" ") ? class_1856.field_9017 : rawShapedRecipe.shapedKey.get(string2);
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + string2 + "' but it's not defined in the shapedKey");
                    }
                    set.remove(string2);
                    shapedRecipeItems.set(l + width * k, (Object)ingredient);
                }
            }
            if (!set.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in shapedPattern: " + String.valueOf(set));
            }
            PotionCandleRecipe potionCandleRecipe = new PotionCandleRecipe(rawShapedRecipe.category, rawShapedRecipe.group, rawShapedRecipe.resultCount(), rawShapedRecipe.maxAllowedPotions(), (class_2371<class_1856>)shapedRecipeItems, rawShapedRecipe.shapelessIngredients(), width, height, rawShapedRecipe.allowNormalPotions(), rawShapedRecipe.allowSplashPotions(), rawShapedRecipe.allowLingeringPotions(), rawShapedRecipe.maxLevelCap());
            return DataResult.success((Object)((Object)potionCandleRecipe));
        }, potionCandleRecipe -> {
            throw new NotImplementedException("Serializing potionCandleRecipe is not implemented yet.");
        });
        public static final class_9139<class_9129, PotionCandleRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<PotionCandleRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, PotionCandleRecipe> method_56104() {
            return STREAM_CODEC;
        }

        public static PotionCandleRecipe fromNetwork(class_9129 buffer) {
            String group = buffer.method_10800(Short.MAX_VALUE);
            String category = buffer.method_10800(Short.MAX_VALUE);
            int width = buffer.method_10816();
            int height = buffer.method_10816();
            class_2371 shapedRecipe = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            shapedRecipe.replaceAll(ignored -> (class_1856)class_1856.field_48355.decode((Object)buffer));
            int ingredientCount = buffer.method_10816();
            class_2371 shapelessRecipe = class_2371.method_10213((int)ingredientCount, (Object)class_1856.field_9017);
            shapelessRecipe.replaceAll(ignored -> (class_1856)class_1856.field_48355.decode((Object)buffer));
            int maxPotionRead = buffer.method_10816();
            boolean allowNormalPotionsRead = buffer.readBoolean();
            boolean allowSplashPotionsRead = buffer.readBoolean();
            boolean allowLingeringPotionsRead = buffer.readBoolean();
            int maxLevelRead = buffer.method_10816();
            int resultCountRead = buffer.method_10816();
            return new PotionCandleRecipe(class_7710.valueOf((String)category.toUpperCase(Locale.ROOT)), group, resultCountRead, maxPotionRead, (class_2371<class_1856>)shapedRecipe, (class_2371<class_1856>)shapelessRecipe, width, height, allowNormalPotionsRead, allowSplashPotionsRead, allowLingeringPotionsRead, maxLevelRead);
        }

        public static void toNetwork(class_9129 buffer, PotionCandleRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10814(recipe.category.method_15434());
            buffer.method_10804(recipe.width);
            buffer.method_10804(recipe.height);
            for (class_1856 ingredient : recipe.shapedRecipeItems) {
                class_1856.field_48355.encode((Object)buffer, (Object)ingredient);
            }
            buffer.method_10804(recipe.shapelessRecipeItems.size());
            for (class_1856 ingredient : recipe.shapelessRecipeItems) {
                class_1856.field_48355.encode((Object)buffer, (Object)ingredient);
            }
            buffer.method_10804(recipe.maxAllowedPotions);
            buffer.method_52964(recipe.allowNormalPotions);
            buffer.method_52964(recipe.allowSplashPotions);
            buffer.method_52964(recipe.allowLingeringPotions);
            buffer.method_10804(recipe.maxLevelCap);
            buffer.method_10804(recipe.outputCount);
        }

        record RawPotionRecipe(String group, class_7710 category, Map<String, class_1856> shapedKey, List<String> shapedPattern, class_2371<class_1856> shapelessIngredients, int maxAllowedPotions, boolean allowNormalPotions, boolean allowSplashPotions, boolean allowLingeringPotions, int maxLevelCap, int resultCount) {
            static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(list -> {
                String string;
                if (list.size() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
                }
                if (list.isEmpty()) {
                    return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
                }
                int length = ((String)list.get(0)).length();
                Iterator var2 = list.iterator();
                do {
                    if (!var2.hasNext()) {
                        return DataResult.success((Object)list);
                    }
                    string = (String)var2.next();
                    if (string.length() <= 3) continue;
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                } while (length == string.length());
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }, Function.identity());
            static final Codec<String> SINGLE_CHARACTER_STRING_CODEC = Codec.STRING.comapFlatMap(string -> {
                if (string.length() != 1) {
                    return DataResult.error(() -> "Invalid key tag: '" + string + "' is an invalid symbol (must be 1 character only).");
                }
                return " ".equals(string) ? DataResult.error(() -> "Invalid key tag: ' ' is a reserved symbol.") : DataResult.success((Object)String.valueOf(string.charAt(0)));
            }, String::valueOf);
            public static final MapCodec<RawPotionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(potionRecipe -> potionRecipe.group), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(potionRecipe -> potionRecipe.category), (App)class_5699.method_53703(SINGLE_CHARACTER_STRING_CODEC, (Codec)class_1856.field_46096).fieldOf("shapedKey").forGetter(potionRecipe -> potionRecipe.shapedKey), (App)PATTERN_CODEC.fieldOf("shapedPattern").forGetter(potionRecipe -> potionRecipe.shapedPattern), (App)class_1856.field_46096.listOf().fieldOf("shapelessExtraIngredients").flatXmap(list -> {
                Object[] ingredients = (class_1856[])list.toArray(class_1856[]::new);
                if (ingredients.length == 0) {
                    return DataResult.error(() -> "No ingredients for shapeless recipe");
                }
                return DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
            }, DataResult::success).forGetter(shapelessRecipe -> shapelessRecipe.shapelessIngredients), (App)Codec.intRange((int)1, (int)6).fieldOf("maxAllowedPotions").forGetter(potionRecipe -> potionRecipe.maxAllowedPotions), (App)Codec.BOOL.fieldOf("allowNormalPotions").forGetter(potionRecipe -> potionRecipe.allowNormalPotions), (App)Codec.BOOL.fieldOf("allowSplashPotions").forGetter(potionRecipe -> potionRecipe.allowSplashPotions), (App)Codec.BOOL.fieldOf("allowLingeringPotions").forGetter(potionRecipe -> potionRecipe.allowLingeringPotions), (App)Codec.intRange((int)1, (int)1000000).fieldOf("maxLevelCap").forGetter(potionRecipe -> potionRecipe.maxLevelCap), (App)Codec.intRange((int)1, (int)64).fieldOf("resultCount").forGetter(potionRecipe -> potionRecipe.resultCount)).apply((Applicative)instance, RawPotionRecipe::new));
        }
    }
}

