/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.dimension;

import com.telepathicgrunt.the_bumblezone.modinit.BzBiomeHeightRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_6544;

public final class BiomeInfluencedNoiseSampler {
    private static final int RADIUS = 2;
    private static final float[] BIOME_WEIGHT_TABLE = (float[])class_156.method_654((Object)new float[(int)Math.pow(5.0, 2.0)], array -> {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                float weight = 10.0f / class_3532.method_15355((float)((float)(x * x + z * z) + 0.2f));
                array[x + 2 + (z + 2) * 5] = weight / 22.0f;
            }
        }
    });
    private static final Map<Long, Float> CACHED_INFLUENCE_RESULT = new ConcurrentHashMap<Long, Float>();

    public static double calculateBaseNoise(int x, int z, class_6544.class_6552 sampler, class_1966 biomeSource, class_2378<class_1959> biomeRegistry) {
        long longPos = (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
        Float cachedResult = CACHED_INFLUENCE_RESULT.get(longPos);
        if (cachedResult != null) {
            return cachedResult.floatValue();
        }
        class_1959 biome = (class_1959)biomeSource.method_38109(x >> 2, 40, z >> 2, sampler).comp_349();
        class_2960 biomeRL = biomeRegistry.method_10221((Object)biome);
        BzBiomeHeightRegistry.BiomeTerrain centerBiomeInfo = BzBiomeHeightRegistry.BIOME_HEIGHT.get(biomeRL);
        if (centerBiomeInfo == null) {
            centerBiomeInfo = new BzBiomeHeightRegistry.BiomeTerrain(4.0f, 1.0f);
        }
        float totalHeight = 0.0f;
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                class_1959 biome2 = (class_1959)biomeSource.method_38109((x >> 2) + xOffset, 40, (z >> 2) + zOffset, sampler).comp_349();
                class_2960 biomeRL2 = biomeRegistry.method_10221((Object)biome2);
                BzBiomeHeightRegistry.BiomeTerrain biomeTerrain = BzBiomeHeightRegistry.BIOME_HEIGHT.get(biomeRL2);
                if (biomeTerrain == null) {
                    biomeTerrain = new BzBiomeHeightRegistry.BiomeTerrain(4.0f, 1.0f);
                }
                float biomeDepth = biomeTerrain.depth;
                float weight = BIOME_WEIGHT_TABLE[xOffset + 2 + (zOffset + 2) * 5];
                if (biomeDepth != centerBiomeInfo.depth) {
                    biomeDepth = class_3532.method_16439((float)centerBiomeInfo.weightModifier, (float)biomeDepth, (float)centerBiomeInfo.depth);
                }
                totalHeight += biomeDepth * weight;
            }
        }
        float finalInfluence = totalHeight / 60.0f;
        if (CACHED_INFLUENCE_RESULT.size() > 2000) {
            CACHED_INFLUENCE_RESULT.clear();
        }
        CACHED_INFLUENCE_RESULT.put(longPos, Float.valueOf(finalInfluence));
        return finalInfluence;
    }
}

