/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalState;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3730;
import net.minecraft.class_4970;
import net.minecraft.class_5321;

public class EssenceBlockWhite
extends EssenceBlock {
    public static final MapCodec<EssenceBlockWhite> CODEC = class_2248.method_54094(EssenceBlockWhite::new);

    public EssenceBlockWhite() {
        this(class_4970.class_2251.method_9637().method_31710(class_3620.field_16022).method_9629(-1.0f, 3600000.8f).method_9631(blockState -> 15).method_42327().method_51369().method_26235((blockState, blockGetter, blockPos, entityType) -> false).method_26245((blockState, blockGetter, blockPos) -> false).method_50012(class_3619.field_15972));
    }

    public EssenceBlockWhite(class_4970.class_2251 properties) {
        super(properties);
    }

    public MapCodec<? extends EssenceBlockWhite> method_53969() {
        return CODEC;
    }

    @Override
    public class_2960 getArenaNbt() {
        return class_2960.method_60655((String)"the_bumblezone", (String)"essence/white_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return BzGeneralConfigs.whiteArenaTimeFrameInTicks;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.white_essence_event", class_1259.class_1260.field_5786, class_1259.class_1261.field_5796).method_5406(true);
    }

    @Override
    public class_2960 getEssenceItemReward() {
        return class_2960.method_60655((String)"the_bumblezone", (String)"gameplay/rewards/white_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(class_3222 serverPlayer) {
        serverPlayer.method_7281((class_2960)BzStats.CONTINUITY_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        if (essenceBlockEntity.getEventTimer() > this.getEventTimeFrame() - 50) {
            return;
        }
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        int totalCrystals = eventEntitiesInArena.size();
        int totalhealth = 0;
        float totalMaxHealth = 6 * BzGeneralConfigs.cosmicCrystalHealth;
        boolean respawnedACrystal = false;
        if (totalCrystals == 0 && essenceBlockEntity.getEventTimer() > this.getEventTimeFrame() - 100) {
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 0, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 60, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 120, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 180, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 240, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 300, 1.0f, eventEntitiesInArena);
            totalCrystals = 6;
        } else {
            ArrayList<CosmicCrystalEntity> crystals = new ArrayList<CosmicCrystalEntity>();
            boolean crystalsAreIdleLongEnough = true;
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                Object nearbyCrystal2;
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                Object entity = serverLevel.method_14190(entityToCheck);
                if (entity == null) {
                    List nearbyCosmicCrystalEntities = serverLevel.method_18467(CosmicCrystalEntity.class, new class_238((double)((float)blockPos.method_10263() - (float)essenceBlockEntity.getArenaSize().method_10263() * 0.5f), (double)((float)blockPos.method_10264() - (float)essenceBlockEntity.getArenaSize().method_10264() * 0.5f), (double)((float)blockPos.method_10260() - (float)essenceBlockEntity.getArenaSize().method_10260() * 0.5f), (double)((float)blockPos.method_10263() + (float)essenceBlockEntity.getArenaSize().method_10263() * 0.5f), (double)((float)blockPos.method_10264() + (float)essenceBlockEntity.getArenaSize().method_10264() * 0.5f), (double)((float)blockPos.method_10260() + (float)essenceBlockEntity.getArenaSize().method_10260() * 0.5f)));
                    for (Object nearbyCrystal2 : nearbyCosmicCrystalEntities) {
                        if (!nearbyCrystal2.method_5667().equals(entityToCheck) || !nearbyCrystal2.getEssenceController().equals(essenceBlockEntity.getUUID())) continue;
                        entity = nearbyCrystal2;
                        break;
                    }
                }
                if (entity == null) {
                    eventEntitiesInArena.remove(i);
                    this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 60 * i, 1.0f, eventEntitiesInArena);
                    respawnedACrystal = true;
                }
                if (!(entity instanceof CosmicCrystalEntity)) continue;
                CosmicCrystalEntity cosmicCrystalEntity = (CosmicCrystalEntity)((Object)entity);
                nearbyCrystal2 = blockState.method_26204();
                if (nearbyCrystal2 instanceof EssenceBlock) {
                    EssenceBlock essenceBlock = (EssenceBlock)nearbyCrystal2;
                    if (essenceBlockEntity.getEventTimer() > essenceBlock.getEventTimeFrame() - 70) {
                        return;
                    }
                }
                totalhealth = (int)((float)totalhealth + cosmicCrystalEntity.method_6032());
                if (cosmicCrystalEntity.getCosmicCrystalState() != CosmicCrystalState.NORMAL || cosmicCrystalEntity.currentStateTimeTick < 50) {
                    crystalsAreIdleLongEnough = false;
                }
                crystals.add(cosmicCrystalEntity);
            }
            float healthPercent = (float)Math.round((float)totalhealth / totalMaxHealth * 10.0f) / 10.0f;
            int shieldThreshold = (int)Math.ceil((double)healthPercent / 0.166);
            int reductionInTicks = 600 * (6 - shieldThreshold);
            boolean shield = shieldThreshold > 0 && essenceBlockEntity.getEventTimer() + reductionInTicks > this.getEventTimeFrame();
            crystals.forEach(c -> c.setShield(shield));
            if (crystalsAreIdleLongEnough && !crystals.isEmpty()) {
                CosmicCrystalEntity crystalEntity;
                int i;
                CosmicCrystalState chosenAttack;
                while (((CosmicCrystalEntity)((Object)crystals.get((int)0))).pastStates.contains((Object)(chosenAttack = CosmicCrystalState.values()[serverLevel.method_8409().method_43048(CosmicCrystalState.values().length)])) || chosenAttack == CosmicCrystalState.NORMAL) {
                }
                float threshold = healthPercent > 0.75f ? 0.0f : (healthPercent > 0.5f ? 0.333f : (healthPercent > 0.25f ? 0.666f : 1.0f));
                CosmicCrystalState finalChosenAttack = chosenAttack;
                crystals.forEach(c -> c.setCosmicCrystalState(finalChosenAttack));
                boolean missingCrystal = respawnedACrystal;
                for (i = 0; i < crystals.size(); ++i) {
                    float difficultyBuff;
                    float newDifficulty;
                    crystalEntity = (CosmicCrystalEntity)((Object)crystals.get(i));
                    int orbitOffset = crystalEntity.getOrbitOffsetDegrees();
                    if (orbitOffset % (360 / crystals.size()) != 0) {
                        missingCrystal = true;
                    }
                    if ((newDifficulty = (1.0f + 0.025f * (float)(6 - totalCrystals)) * (difficultyBuff = (float)(1.0 + Math.pow(threshold, 2.0) * (double)0.35f))) == crystalEntity.getDifficultyBoost()) continue;
                    crystalEntity.setDifficultyBoost(newDifficulty);
                }
                if (missingCrystal) {
                    for (i = 0; i < crystals.size(); ++i) {
                        crystalEntity = (CosmicCrystalEntity)((Object)crystals.get(i));
                        crystalEntity.setOrbitOffsetDegrees(i * (360 / crystals.size()));
                        crystalEntity.currentTickCount = 0;
                    }
                }
            }
        }
        if (totalCrystals == 0) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
        essenceBlockEntity.getEventBar().method_5408((float)totalhealth / totalMaxHealth);
    }

    private class_1297 SpawnNewCrystal(class_3218 serverLevel, class_2338 blockPos, EssenceBlockEntity essenceBlockEntity, int orbitOffset, float difficultyBoost, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        CosmicCrystalEntity entity = (CosmicCrystalEntity)((class_1299)BzEntities.COSMIC_CRYSTAL_ENTITY.get()).method_47821(serverLevel, blockPos, class_3730.field_16461);
        if (entity != null) {
            entity.method_5780("the_bumblezone.white_essence_arena");
            entity.setEssenceControllerDimension((class_5321<class_1937>)serverLevel.method_27983());
            entity.setEssenceController(essenceBlockEntity.getUUID());
            entity.setEssenceControllerBlockPos(essenceBlockEntity.method_11016());
            entity.setOrbitOffsetDegrees(orbitOffset);
            entity.setDifficultyBoost(difficultyBoost);
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.method_5667()));
        }
        return entity;
    }

    public void crystalKilled(CosmicCrystalEntity cosmicCrystalEntity, EssenceBlockEntity essenceBlockEntity) {
        essenceBlockEntity.getEventEntitiesInArena().removeIf(e -> e.uuid().equals(cosmicCrystalEntity.method_5667()));
    }

    @Override
    public void onPlayerEnter(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, ((class_3414)BzSounds.CONTINUITY_EVENT.get()).method_14833(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, ((class_3414)BzSounds.CONTINUITY_EVENT.get()).method_14833(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

