/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.HoneyCrystalShards;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.CrystallineFlowerData;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.UUID;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9331;

public class CrystallineFlowerBlockEntity
extends class_2586 {
    public static final String TIER_TAG = "tier";
    public static final String XP_TAG = "xp";
    public static final String UUID_TAG = "guid";
    private int xpTier = 1;
    private int currentXp = 0;
    private UUID uuid = UUID.randomUUID();
    public static final String BOOK_SLOT_ITEMS = "bookItems";
    public static final String CONSUME_SLOT_ITEMS = "consumeItems";
    private class_1799 bookSlotItems = class_1799.field_8037;
    private class_1799 consumeSlotItems = class_1799.field_8037;

    protected CrystallineFlowerBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public CrystallineFlowerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this((class_2591)BzBlockEntities.CRYSTALLINE_FLOWER.get(), blockPos, blockState);
    }

    public int getXpTier() {
        return this.xpTier;
    }

    public void setXpTier(int xpTier) {
        this.xpTier = xpTier;
    }

    public int getCurrentXp() {
        return this.currentXp;
    }

    public void setCurrentXp(int currentXp) {
        this.currentXp = currentXp;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setGUID(UUID uuid) {
        this.uuid = uuid;
    }

    public class_1799 getBookSlotItems() {
        return this.bookSlotItems;
    }

    public void setBookSlotItems(class_1799 bookSlotItems) {
        this.bookSlotItems = bookSlotItems;
    }

    public class_1799 getConsumeSlotItems() {
        return this.consumeSlotItems;
    }

    public void setConsumeSlotItems(class_1799 consumeSlotItems) {
        this.consumeSlotItems = consumeSlotItems;
        this.setPillar(0);
    }

    public void syncPillar() {
        this.setPillar(0);
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.xpTier = compoundTag.method_10550(TIER_TAG);
        this.currentXp = Math.min(compoundTag.method_10550(XP_TAG), this.getMaxXpForTier(this.xpTier));
        if (compoundTag.method_10545(UUID_TAG)) {
            this.uuid = compoundTag.method_10540(UUID_TAG) == 8 ? UUID.fromString(compoundTag.method_10558(UUID_TAG)) : compoundTag.method_25926(UUID_TAG);
            if (this.uuid.compareTo(CrystallineFlowerData.DEFAULT_UUID) == 0) {
                this.uuid = UUID.randomUUID();
            }
        } else {
            this.uuid = UUID.randomUUID();
        }
        this.bookSlotItems = compoundTag.method_10545(BOOK_SLOT_ITEMS) ? class_1799.method_57360((class_7225.class_7874)provider, (class_2520)compoundTag.method_10562(BOOK_SLOT_ITEMS)).orElse(class_1799.field_8037) : class_1799.field_8037;
        this.consumeSlotItems = compoundTag.method_10545(CONSUME_SLOT_ITEMS) ? class_1799.method_57360((class_7225.class_7874)provider, (class_2520)compoundTag.method_10562(CONSUME_SLOT_ITEMS)).orElse(class_1799.field_8037) : class_1799.field_8037;
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        this.saveFieldsToTag(compoundTag, provider);
    }

    private void saveFieldsToTag(class_2487 compoundTag, class_7225.class_7874 provider) {
        compoundTag.method_10569(TIER_TAG, this.xpTier);
        compoundTag.method_10569(XP_TAG, this.currentXp);
        compoundTag.method_25927(UUID_TAG, this.uuid);
        if (!this.bookSlotItems.method_7960()) {
            compoundTag.method_10566(BOOK_SLOT_ITEMS, this.bookSlotItems.method_57358(provider));
        }
        if (!this.consumeSlotItems.method_7960()) {
            compoundTag.method_10566(CONSUME_SLOT_ITEMS, this.consumeSlotItems.method_57358(provider));
        }
    }

    public void method_38240(class_1799 stack, class_7225.class_7874 provider) {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag, provider);
        class_1747.method_57338((class_1799)stack, (class_2591)this.method_11017(), (class_2487)compoundTag);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        this.saveFieldsToTag(tag, provider);
        return tag;
    }

    public void addXpAndTier(int xpChange) {
        this.currentXp += xpChange;
        int tierChange = 0;
        while (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp -= this.getMaxXpForTier(this.xpTier);
            ++tierChange;
            ++this.xpTier;
        }
        while (this.currentXp < 0 && !this.isMinTier()) {
            this.currentXp += this.getMaxXpForTier(this.xpTier);
            --tierChange;
            --this.xpTier;
        }
        if (this.isMaxTier()) {
            this.currentXp = 0;
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier)) {
            this.currentXp = this.getMaxXpForTier(this.xpTier);
        } else if (this.currentXp < 0) {
            this.currentXp = 0;
        }
        this.method_5431();
        this.setPillar(tierChange);
    }

    public void increaseTier(int tierIncrease) {
        int tierChange = Math.min(7 - this.xpTier, tierIncrease);
        if (!this.isMaxTier()) {
            this.xpTier += tierIncrease;
        } else {
            this.currentXp = this.getMaxXpForTier(this.xpTier);
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp = this.getMaxXpForTier(this.xpTier) - 1;
        }
        this.method_5431();
        this.setPillar(tierChange);
    }

    public void decreaseTier(int tierDecrease) {
        int tierChange = Math.min(this.xpTier - 1, tierDecrease);
        if (!this.isMinTier()) {
            this.xpTier -= tierDecrease;
        }
        if (this.currentXp >= this.getMaxXpForTier(this.xpTier) && !this.isMaxTier()) {
            this.currentXp = this.getMaxXpForTier(this.xpTier) - 1;
        }
        this.method_5431();
        this.setPillar(-tierChange);
    }

    public void setPillar(int tierChange) {
        if (this.field_11863 != null) {
            int bottomHeight = CrystallineFlower.flowerHeightBelow((class_4538)this.field_11863, this.method_11016());
            class_2338 operatingPos = this.method_11016().method_10087(bottomHeight);
            int topHeight = CrystallineFlower.flowerHeightAbove((class_4538)this.field_11863, operatingPos);
            class_2586 blockEntity = this.field_11863.method_8321(operatingPos);
            if (blockEntity instanceof CrystallineFlowerBlockEntity) {
                CrystallineFlowerBlockEntity crystallineFlowerBlockEntity = (CrystallineFlowerBlockEntity)blockEntity;
                if (tierChange != 0) {
                    class_2586 targetBlockEntity;
                    if (bottomHeight != 0 && (targetBlockEntity = this.field_11863.method_8321(this.method_11016().method_10087(bottomHeight))) instanceof CrystallineFlowerBlockEntity) {
                        targetBlockEntity.method_58690(crystallineFlowerBlockEntity.method_16887((class_7225.class_7874)this.field_11863.method_30349()), (class_7225.class_7874)this.field_11863.method_30349());
                    }
                    boolean upward = tierChange > 0;
                    for (int i = 0; i < (upward ? this.xpTier : topHeight + 1); ++i) {
                        boolean placePlant = upward || i < this.xpTier;
                        this.field_11863.method_8652(operatingPos.method_10086(i), placePlant ? ((class_2248)BzBlocks.CRYSTALLINE_FLOWER.get()).method_9564() : class_2246.field_10124.method_9564(), 2);
                        class_1937 class_19372 = this.field_11863;
                        if (!(class_19372 instanceof class_3218)) continue;
                        class_3218 serverLevel = (class_3218)class_19372;
                        if (placePlant) continue;
                        int itemsToDrop = 0;
                        while ((double)itemsToDrop < 2.0 + (double)i / 1.5) {
                            class_1799 stack = ((HoneyCrystalShards)((Object)BzItems.HONEY_CRYSTAL_SHARDS.get())).method_7854();
                            stack.method_7939(1);
                            GeneralUtils.spawnItemEntity(serverLevel, operatingPos.method_10086(i), stack, 0.05, 0.2);
                            ++itemsToDrop;
                        }
                    }
                    operatingPos = operatingPos.method_10086(upward ? this.xpTier - 1 : topHeight + tierChange);
                    this.field_11863.method_8652(operatingPos, (class_2680)((class_2248)BzBlocks.CRYSTALLINE_FLOWER.get()).method_9564().method_11657((class_2769)CrystallineFlower.FLOWER, (Comparable)Boolean.valueOf(true)), 2);
                    class_2586 blockEntity2 = this.field_11863.method_8321(operatingPos);
                    if (blockEntity2 instanceof CrystallineFlowerBlockEntity) {
                        CrystallineFlowerBlockEntity crystallineFlowerBlockEntity2 = (CrystallineFlowerBlockEntity)blockEntity2;
                        crystallineFlowerBlockEntity2.method_58690(crystallineFlowerBlockEntity.method_16887((class_7225.class_7874)this.field_11863.method_30349()), (class_7225.class_7874)this.field_11863.method_30349());
                        blockEntity2.method_5431();
                    }
                }
                for (int i = 0; i <= topHeight; ++i) {
                    class_2586 blockEntity2;
                    class_2338 updatePos = operatingPos.method_10086(i);
                    class_2680 state = this.field_11863.method_8320(updatePos);
                    this.field_11863.method_8452(updatePos, state.method_26204());
                    if (i == 0 || !((blockEntity2 = this.field_11863.method_8321(updatePos)) instanceof CrystallineFlowerBlockEntity)) continue;
                    CrystallineFlowerBlockEntity crystallineFlowerBlockEntity2 = (CrystallineFlowerBlockEntity)blockEntity2;
                    crystallineFlowerBlockEntity2.method_58690(crystallineFlowerBlockEntity.method_16887((class_7225.class_7874)this.field_11863.method_30349()), (class_7225.class_7874)this.field_11863.method_30349());
                }
            }
        }
    }

    public boolean isMaxXP() {
        return this.currentXp == this.getMaxXpForTier(this.xpTier);
    }

    public boolean isMinXP() {
        return this.currentXp == 0;
    }

    public boolean isMaxTier() {
        return this.xpTier == 7;
    }

    public boolean isMinTier() {
        return this.xpTier == 0;
    }

    public int getMaxXpForTier(int tier) {
        return Math.max(1, 90 + tier * tier * 15 + BzGeneralConfigs.crystallineFlowerExtraXpNeededForTiers);
    }

    public int getXpForNextTiers(int nextTiersToCalculate) {
        int totalXpNeeded = 0;
        for (int i = 0; i < nextTiersToCalculate; ++i) {
            if (i == 0) {
                totalXpNeeded += this.getMaxXpForTier(this.xpTier) - this.currentXp;
                continue;
            }
            if (this.xpTier + i > 7) continue;
            totalXpNeeded += this.getMaxXpForTier(this.xpTier + i);
        }
        return totalXpNeeded;
    }

    protected void method_57568(class_2586.class_9473 dataComponentInput) {
        super.method_57568(dataComponentInput);
        CrystallineFlowerData crystallineFlowerData = (CrystallineFlowerData)dataComponentInput.method_58695((class_9331)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get(), (Object)new CrystallineFlowerData());
        this.xpTier = crystallineFlowerData.tier();
        this.currentXp = crystallineFlowerData.experience();
        if (crystallineFlowerData.uuid().compareTo(CrystallineFlowerData.DEFAULT_UUID) != 0) {
            this.uuid = crystallineFlowerData.uuid();
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        CrystallineFlowerData crystallineFlowerData = new CrystallineFlowerData(this.xpTier, this.currentXp, this.uuid);
        builder.method_57840((class_9331)BzDataComponents.CRYSTALLINE_FLOWER_DATA.get(), (Object)crystallineFlowerData);
    }

    public void method_57569(class_2487 compoundTag) {
        compoundTag.method_10551(TIER_TAG);
        compoundTag.method_10551(XP_TAG);
        compoundTag.method_10551(UUID_TAG);
        super.method_57569(compoundTag);
    }
}

