/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.datamanagers;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_6880;

public class PotionCandleDataManager
extends class_4309 {
    public static final PotionCandleDataManager POTION_CANDLE_DATA_MANAGER = new PotionCandleDataManager();
    public final Map<class_1291, OverrideData> effectToOverrideStats = new Object2ObjectArrayMap();

    public PotionCandleDataManager() {
        super(Bumblezone.GSON, "bz_potion_candle_data");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        this.effectToOverrideStats.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                EffectData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).resultOrPartial(s -> {}).ifPresent(data -> this.effectToOverrideStats.put((class_1291)data.effectHolder().comp_349(), data.overrideData()));
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse potion candle data file: {}", fileIdentifier, (Object)e);
            }
        });
    }

    public record EffectData(class_6880<class_1291> effectHolder, OverrideData overrideData) {
        public static final Codec<EffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1291.field_51933.fieldOf("effect").forGetter(e -> e.effectHolder), (App)OverrideData.CODEC.fieldOf("override").forGetter(i -> i.overrideData)).apply((Applicative)instance, instance.stable(EffectData::new)));
    }

    public record OverrideData(Integer maxLevelCap, Integer minLevelCap, Integer maxBurnDurationCap, Integer minBurnDurationCap, Optional<Integer> baseLingerTime) {
        public static final Codec<OverrideData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_48766((int)0, (int)100000000).fieldOf("max_level_cap").orElse((Object)100000000).forGetter(i -> i.maxLevelCap), (App)class_5699.method_48766((int)0, (int)100000000).fieldOf("min_level_cap").orElse((Object)0).forGetter(i -> i.minLevelCap), (App)class_5699.method_48766((int)1, (int)100000000).fieldOf("max_burn_duration_cap_in_seconds").orElse((Object)100000000).forGetter(i -> i.maxBurnDurationCap), (App)class_5699.method_48766((int)1, (int)100000000).fieldOf("min_burn_duration_cap_in_seconds").orElse((Object)1).forGetter(i -> i.maxBurnDurationCap), (App)class_5699.field_33442.optionalFieldOf("linger_base_duration_in_seconds").forGetter(i -> i.baseLingerTime)).apply((Applicative)instance, instance.stable(OverrideData::new)));
    }
}

