/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.effects;

import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.BeeDedicatedSpawning;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzPOI;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1267;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4081;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4466;
import net.minecraft.class_5354;
import net.minecraft.class_5425;

public class WrathOfTheHiveEffect
extends class_1291 {
    public static final int NEARBY_WRATH_EFFECT_RADIUS = 8;
    private static final class_4051 SEE_THROUGH_WALLS = class_4051.method_36625().method_36627().method_18424();
    private static final class_4051 LINE_OF_SIGHT = class_4051.method_36625();
    public static boolean ACTIVE_WRATH = false;

    public WrathOfTheHiveEffect(class_4081 type, int potionColor) {
        super(type, potionColor);
    }

    public boolean method_5561() {
        return true;
    }

    public boolean method_5552(int duration, int amplifier) {
        return duration >= 1;
    }

    public boolean method_5572(class_1309 entity, int amplifier) {
        class_1308 mob;
        class_1937 world = entity.method_37908();
        if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5987()) {
            return false;
        }
        if (entity.method_29504()) {
            WrathOfTheHiveEffect.calmTheBees(world, entity);
            return false;
        }
        if (entity instanceof class_1657 && world.method_8407() == class_1267.field_5801) {
            return false;
        }
        if ((entity.method_37908().method_8510() + entity.method_5667().getLeastSignificantBits()) % 20L != 0L) {
            return true;
        }
        if (entity.method_6059(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
            return false;
        }
        if (amplifier >= 2) {
            class_3218 serverLevel;
            WrathOfTheHiveEffect.unBEElievablyHighAggression(world, entity);
            if (world instanceof class_3218 && (float)BeeDedicatedSpawning.getNearbyActiveEntitiesInDimension(serverLevel = (class_3218)world, entity.method_24515()) < (float)BzGeneralConfigs.broodBlocksBeeSpawnCapacity * 3.0f && entity.method_59922().method_43057() <= 0.09f) {
                class_2338 spawnBlockPos = GeneralUtils.getRandomBlockposWithinRange(entity, 30, 10);
                if (!world.method_8320(spawnBlockPos).method_26215()) {
                    return false;
                }
                class_4466 bee = (class_4466)class_1299.field_20346.method_5883(world);
                if (bee == null) {
                    return true;
                }
                bee.method_5943((class_5425)serverLevel, serverLevel.method_8404(spawnBlockPos), class_3730.field_16461, null);
                bee.method_5641((double)spawnBlockPos.method_10263() + 0.5, (double)spawnBlockPos.method_10264() + 0.5, (double)spawnBlockPos.method_10260() + 0.5, entity.method_59922().method_43057() * 360.0f, 0.0f);
                PlatformHooks.finalizeSpawn((class_1308)bee, (class_5425)world, null, class_3730.field_16461);
                world.method_8649((class_1297)bee);
            }
        } else {
            WrathOfTheHiveEffect.mediumAggression(world, entity);
        }
        if (!world.method_8608() && entity instanceof class_1657) {
            class_4153 poiManager = ((class_3218)world).method_19494();
            List poiInRange = poiManager.method_22383(pointOfInterestType -> pointOfInterestType.comp_349() == BzPOI.BROOD_BLOCK_POI.get(), entity.method_24515(), 8, class_4153.class_4155.field_18489).collect(Collectors.toList());
            float chanceOfGrowth = 0.15f;
            if (poiInRange.size() != 0) {
                for (int index = poiInRange.size() - 1; index >= 0; --index) {
                    class_2680 state;
                    if (!(entity.method_59922().method_43057() < chanceOfGrowth)) continue;
                    class_4156 poi = (class_4156)poiInRange.remove(index);
                    int yDiff = Math.abs(entity.method_24515().method_10264() - poi.method_19141().method_10264());
                    if (yDiff > 8 || !((state = world.method_8320(poi.method_19141())).method_26204() instanceof HoneycombBrood)) continue;
                    state.method_26192((class_3218)world, poi.method_19141(), entity.method_59922());
                }
            }
        }
        return true;
    }

    public static void mediumAggression(class_1937 world, class_1309 livingEntity) {
        WrathOfTheHiveEffect.setAggression(world, livingEntity, class_4466.class, LINE_OF_SIGHT, Math.max(BzBeeAggressionConfigs.speedBoostLevel - 1, 1), Math.max((BzBeeAggressionConfigs.absorptionBoostLevel - 1) / 2, 1), Math.max((BzBeeAggressionConfigs.strengthBoostLevel - 1) / 3, 1));
    }

    public static void unBEElievablyHighAggression(class_1937 world, class_1309 livingEntity) {
        WrathOfTheHiveEffect.setAggression(world, livingEntity, class_4466.class, SEE_THROUGH_WALLS, BzBeeAggressionConfigs.speedBoostLevel - 1, BzBeeAggressionConfigs.absorptionBoostLevel - 1, BzBeeAggressionConfigs.strengthBoostLevel - 1);
    }

    private static void setAggression(class_1937 world, class_1309 livingEntity, Class<? extends class_1308> entityToFind, class_4051 sightMode, int speed, int absorption, int strength) {
        if (BeeAggression.isBeelikeEntity((class_1297)livingEntity)) {
            return;
        }
        boolean isHiding = false;
        class_1293 hiddenEffect = livingEntity.method_6112(BzEffects.HIDDEN.holder());
        if (hiddenEffect != null && hiddenEffect.method_5578() >= 1) {
            isHiding = true;
        }
        sightMode.method_18418((double)BzBeeAggressionConfigs.aggressionTriggerRadius);
        List beeList = world.method_18466(entityToFind, sightMode, livingEntity, livingEntity.method_5829().method_1014((double)BzBeeAggressionConfigs.aggressionTriggerRadius));
        for (class_1308 bee : beeList) {
            class_1293 effect;
            if (bee.method_5987()) continue;
            if (isHiding) {
                bee.method_5980(null);
                continue;
            }
            if (bee instanceof class_5354) {
                ((class_5354)bee).method_29514(40);
                if (bee.method_5968() == null || bee.method_5968().method_29504()) {
                    ((class_5354)bee).method_29513(livingEntity.method_5667());
                }
            }
            if (bee.method_5968() == null || bee.method_5968().method_29504()) {
                bee.method_5980(livingEntity);
            }
            if ((effect = livingEntity.method_6112(BzEffects.WRATH_OF_THE_HIVE.holder())) == null) continue;
            int leftoverDuration = effect.method_5584();
            class_1293 currentEffect = bee.method_6112(class_1294.field_5904);
            if (currentEffect == null || currentEffect.method_5584() < leftoverDuration) {
                bee.method_6092(new class_1293(class_1294.field_5904, leftoverDuration, speed, false, false));
            }
            if ((currentEffect = bee.method_6112(class_1294.field_5898)) == null || currentEffect.method_5584() < leftoverDuration) {
                bee.method_6092(new class_1293(class_1294.field_5898, leftoverDuration, absorption, false, false));
            }
            if ((currentEffect = bee.method_6112(class_1294.field_5910)) != null && currentEffect.method_5584() >= leftoverDuration) continue;
            bee.method_6092(new class_1293(class_1294.field_5910, leftoverDuration, strength, false, true));
        }
    }

    public static void calmTheBees(class_1937 world, class_1309 livingEntity) {
        SEE_THROUGH_WALLS.method_18418((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 1.2);
        List beeList = world.method_18466(class_4466.class, SEE_THROUGH_WALLS, livingEntity, livingEntity.method_5829().method_1014((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 1.2));
        for (class_4466 bee : beeList) {
            if (bee.method_5987() || bee.method_5968() != livingEntity) continue;
            bee.method_5980(null);
            bee.method_19540(false);
            bee.method_29514(0);
            bee.method_6016(class_1294.field_5910);
            bee.method_6016(class_1294.field_5904);
            bee.method_6016(class_1294.field_5898);
        }
    }

    public static void effectRemoval(class_1309 entity, class_1293 mobEffectInstance) {
        class_1308 mob;
        if (entity.method_37908().field_9236 || mobEffectInstance.method_5579() != BzEffects.WRATH_OF_THE_HIVE.holder()) {
            return;
        }
        if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5987()) {
            return;
        }
        if (BeeAggression.doesBeesHateEntity((class_1297)entity)) {
            entity.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 1, false, true));
        }
    }

    public static void onLivingEntityDeath(BzEntityDeathEvent event) {
        class_1309 livingEntity = event.entity();
        if (livingEntity != null) {
            WrathOfTheHiveEffect.calmTheBees(livingEntity.method_37908(), livingEntity);
        }
    }
}

