/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.enchantments.datacomponents.ParalyzeMarker;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.mixin.entities.AbstractArrowAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.MobAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modules.LivingEntityDataModule;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3222;
import net.minecraft.class_3483;
import net.minecraft.class_8103;
import net.minecraft.class_9331;

public class NeurotoxinsEnchantmentApplication {
    public static Pair<ParalyzeMarker, Integer> getNeurotoxinEnchantLevel(class_1799 stack) {
        Pair pair = class_1890.method_60174((class_1799)stack, (class_9331)((class_9331)BzEnchantments.PARALYZE_MARKER.get()));
        return pair != null ? Pair.of((Object)((ParalyzeMarker)pair.getFirst()), (Object)Math.min((Integer)pair.getSecond(), BzGeneralConfigs.neurotoxinMaxLevel)) : null;
    }

    public static void entityHurtEvent(BzEntityAttackedEvent event) {
        class_1297 projectile;
        if (event.entity() == null || event.entity().method_37908().method_8608() || event.entity().method_5864().method_20210(class_3483.field_46232)) {
            return;
        }
        class_1799 attackingItem = null;
        class_1309 attacker = null;
        class_1297 class_12972 = event.source().method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity;
            attacker = livingEntity = (class_1309)class_12972;
            attackingItem = attacker.method_6047();
        }
        if (event.source().method_48789(class_8103.field_42247) && (projectile = event.source().method_5526()) instanceof class_1665) {
            class_1665 abstractArrow = (class_1665)projectile;
            attackingItem = ((AbstractArrowAccessor)abstractArrow).bumblezone$callGetPickupItem();
        }
        if (attackingItem != null && !attackingItem.method_7960()) {
            NeurotoxinsEnchantmentApplication.applyNeurotoxins((class_1297)attacker, event.entity(), attackingItem);
        }
    }

    public static boolean applyNeurotoxins(class_1297 attacker, class_1309 victim, class_1799 itemStack) {
        Pair<ParalyzeMarker, Integer> enchantmentAndLevel = NeurotoxinsEnchantmentApplication.getNeurotoxinEnchantLevel(itemStack);
        if (enchantmentAndLevel == null || (Integer)enchantmentAndLevel.getSecond() <= 0) {
            return false;
        }
        if ((Integer)enchantmentAndLevel.getSecond() > 0) {
            Optional<LivingEntityDataModule> capOptional;
            if (victim.method_6059(BzEffects.PARALYZED.holder())) {
                return false;
            }
            float applyChance = 1.0f;
            LivingEntityDataModule capability = null;
            if (attacker != null && (capOptional = ModuleHelper.getModule(attacker, ModuleRegistry.LIVING_ENTITY_DATA)).isPresent()) {
                capability = capOptional.orElseThrow(RuntimeException::new);
                float healthModifier = Math.max(100.0f - victim.method_6032(), 10.0f) / 100.0f;
                applyChance = healthModifier * (float)((Integer)enchantmentAndLevel.getSecond()).intValue() * (float)(capability.getMissedParalysis() + 1);
            }
            if (victim.method_59922().method_43057() < applyChance) {
                victim.method_6092(new class_1293(BzEffects.PARALYZED.holder(), Math.min(((ParalyzeMarker)enchantmentAndLevel.getFirst()).durationPerLevel() * (Integer)enchantmentAndLevel.getSecond(), BzGeneralConfigs.paralyzedMaxTickDuration), ((Integer)enchantmentAndLevel.getSecond()).intValue(), false, true, true));
                if (attacker instanceof class_1309) {
                    class_1309 livingAttacker = (class_1309)attacker;
                    if (victim instanceof class_1308) {
                        class_1308 mob = (class_1308)victim;
                        mob.method_6015(livingAttacker);
                        ((MobAccessor)mob).bumblezone$getTargetSelector().method_6275();
                    }
                }
                if (itemStack.method_31574((class_1792)BzItems.STINGER_SPEAR.get()) && attacker instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)attacker;
                    ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_PARALYZING_TRIGGER.get())).trigger(serverPlayer);
                    if (victim.method_6032() > 70.0f) {
                        ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_PARALYZE_BOSS_TRIGGER.get())).trigger(serverPlayer);
                    }
                }
                if (capability != null) {
                    capability.setMissedParalysis(0);
                }
                return true;
            }
            if (capability != null) {
                capability.setMissedParalysis(capability.getMissedParalysis() + 1);
            }
        }
        return false;
    }
}

