/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.enchantments.NeurotoxinsEnchantmentApplication;
import com.telepathicgrunt.the_bumblezone.enchantments.PotentPoisonEnchantmentApplication;
import com.telepathicgrunt.the_bumblezone.enchantments.datacomponents.ParalyzeMarker;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_3966;

public class ThrownStingerSpearEntity
extends class_1665 {
    private static final class_2940<Byte> ID_LOYALTY = class_2945.method_12791(ThrownStingerSpearEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> ID_FOIL = class_2945.method_12791(ThrownStingerSpearEntity.class, (class_2941)class_2943.field_13323);
    private static final class_1799 DEFAULT_SPEAR_STACK = new class_1799((class_1935)BzItems.STINGER_SPEAR.get());
    private boolean dealtDamage;
    public int clientSideReturnSpearTickCount;

    public ThrownStingerSpearEntity(class_1299<? extends ThrownStingerSpearEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public ThrownStingerSpearEntity(class_1937 level, class_1309 livingEntity, class_1799 ammo, class_1799 weaponItem) {
        super((class_1299)BzEntities.THROWN_STINGER_SPEAR_ENTITY.get(), livingEntity, level, ammo, weaponItem);
        this.field_6011.method_12778(ID_LOYALTY, (Object)this.getLoyaltyFromItem(weaponItem));
        this.field_6011.method_12778(ID_FOIL, (Object)weaponItem.method_7958());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ID_LOYALTY, (Object)0);
        builder.method_56912(ID_FOIL, (Object)false);
    }

    private byte getLoyaltyFromItem(class_1799 itemStack) {
        byte by;
        class_1937 var3 = this.method_37908();
        if (var3 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)var3;
            by = (byte)class_3532.method_15340((int)class_1890.method_60169((class_3218)serverLevel, (class_1799)itemStack, (class_1297)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    public void method_5773() {
        if (this.field_7576 > 4) {
            this.dealtDamage = true;
        }
        class_1297 entity = this.method_24921();
        byte loyalty = (Byte)this.field_6011.method_12789(ID_LOYALTY);
        if (loyalty > 0 && (this.dealtDamage || this.method_7441()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.method_37908().field_9236 && this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(this.method_7445(), 0.1f);
                }
                this.method_31472();
            } else {
                this.method_7433(true);
                class_243 vec3 = entity.method_33571().method_1020(this.method_19538());
                this.method_23327(this.method_23317(), this.method_23318() + vec3.field_1351 * 0.015 * (double)loyalty, this.method_23321());
                if (this.method_37908().field_9236) {
                    this.field_5971 = this.method_23318();
                }
                double returnSpeed = 0.05 * (double)loyalty;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3.method_1029().method_1021(returnSpeed)));
                if (this.clientSideReturnSpearTickCount == 0) {
                    this.method_5783((class_3414)BzSounds.STINGER_SPEAR_RETURN.get(), 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
            }
        }
        super.method_5773();
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 class_12972;
        class_1309 livingEntity;
        class_1297 entity = entityHitResult.method_17782();
        class_1297 owner = this.method_24921();
        class_1937 level = this.method_37908();
        float damageAmount = 1.5f;
        class_1282 damageSource = this.method_48923().method_48799((class_1297)this, (class_1297)(owner == null ? this : owner));
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            damageAmount += class_1890.method_60120((class_3218)serverLevel, (class_1799)this.method_59958(), (class_1297)entity, (class_1282)damageSource, (float)damageAmount);
        }
        class_1282 damagesource = this.method_48923().method_48799((class_1297)this, (class_1297)(owner == null ? this : owner));
        this.dealtDamage = true;
        if (entity.method_5643(damagesource, damageAmount)) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 hitEntity = (class_1309)entity;
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    class_1890.method_60619((class_3218)serverLevel, (class_1297)entity, (class_1282)damageSource, (class_1799)this.method_59958());
                }
                if (hitEntity instanceof class_1309) {
                    class_1309 livingEntity2 = hitEntity;
                    this.method_59957(livingEntity2, damageSource);
                    this.method_7450(livingEntity2);
                }
                this.method_7450(hitEntity);
            }
        }
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_29504() && (class_12972 = this.method_24921()) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_12972;
            if (!serverPlayer.method_24515().method_19771((class_2382)this.method_24515(), 50.0)) {
                ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_LONG_RANGE_KILL_TRIGGER.get())).trigger(serverPlayer);
            }
            if (entity.method_5864() == class_1299.field_6119 && PlayerDataHandler.rootAdvancementDone(serverPlayer)) {
                ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_KILLED_WITH_WITHER_TRIGGER.get())).trigger(serverPlayer);
            }
        }
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        this.method_5783((class_3414)BzSounds.STINGER_SPEAR_HIT.get(), 1.0f, 1.0f);
    }

    protected void method_7450(class_1309 victim) {
        if (!victim.method_5864().method_20210(class_3483.field_46232)) {
            PotentPoisonEnchantmentApplication.doPostAttackBoostedPoison(this.method_54759(), victim);
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_12972;
                ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_POISONING_TRIGGER.get())).trigger(serverPlayer);
            }
            if ((class_12972 = this.method_24921()) instanceof class_1309) {
                Pair<ParalyzeMarker, Integer> neurotoxin;
                class_1309 ownerEntity = (class_1309)class_12972;
                if (!victim.method_5864().method_20210(BzTags.PARALYZED_IMMUNE) && (neurotoxin = NeurotoxinsEnchantmentApplication.getNeurotoxinEnchantLevel(this.method_54759())) != null && (Integer)neurotoxin.getSecond() > 0) {
                    this.method_54759().method_7970(((ParalyzeMarker)neurotoxin.getFirst()).durabilityDrainOnValidTargetHit(), ownerEntity, class_1304.field_6173);
                }
            }
        }
    }

    protected float method_7436() {
        return 0.75f;
    }

    private boolean isAcceptibleReturnOwner() {
        class_1297 entity = this.method_24921();
        if (entity != null && entity.method_5805()) {
            return !(entity instanceof class_3222) || !entity.method_7325();
        }
        return false;
    }

    public boolean isFoil() {
        return (Boolean)this.field_6011.method_12789(ID_FOIL);
    }

    protected class_3966 method_7434(class_243 vec3, class_243 vec31) {
        return this.dealtDamage ? null : super.method_7434(vec3, vec31);
    }

    protected boolean method_34713(class_1657 player) {
        return super.method_34713(player) || this.method_7441() && this.method_34714((class_1297)player) && player.method_31548().method_7394(this.method_7445());
    }

    protected class_1799 method_57314() {
        return ((class_1792)BzItems.STINGER_SPEAR.get()).method_7854();
    }

    protected class_3414 method_7440() {
        return (class_3414)BzSounds.STINGER_SPEAR_HIT_GROUND.get();
    }

    public void method_5694(class_1657 player) {
        if (this.method_34714((class_1297)player) || this.method_24921() == null) {
            super.method_5694(player);
        }
    }

    public void method_7446() {
        byte loyalty = (Byte)this.field_6011.method_12789(ID_LOYALTY);
        if (!(this.method_5655() || this.field_7572 == class_1665.class_1666.field_7593 && loyalty > 0)) {
            super.method_7446();
        }
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.dealtDamage = compoundTag.method_10577("DealtDamage");
        this.field_6011.method_12778(ID_LOYALTY, (Object)this.getLoyaltyFromItem(this.method_59958()));
        this.field_6011.method_12778(ID_FOIL, (Object)compoundTag.method_10577("IsFoil"));
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("DealtDamage", this.dealtDamage);
        compoundTag.method_10556("IsFoil", this.isFoil());
    }

    public boolean method_5727(double x, double y, double z) {
        return true;
    }
}

