/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.BzWorldSavedData;
import com.telepathicgrunt.the_bumblezone.events.block.BzBlockBreakEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.BzRegisterVillagerTradesEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.BzRegisterWanderingTradesEvent;
import com.telepathicgrunt.the_bumblezone.events.item.BzRegisterBrewingRecipeEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzAddBuiltinDataPacks;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzAddBuiltinResourcePacks;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzAddCreativeTabEntriesEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzDatapackSyncEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzFinalSetupEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzRegisterCommandsEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzRegisterDataSerializersEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzRegisterEntityAttributesEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzRegisterFlammabilityEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzRegisterReloadListenerEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzRegisterSpawnPlacementsEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzServerGoingToStartEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzServerGoingToStopEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzSetupEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzTagsUpdatedEvent;
import com.telepathicgrunt.the_bumblezone.events.player.BzPlayerItemAttackBlockEvent;
import com.telepathicgrunt.the_bumblezone.events.player.BzPlayerItemUseEvent;
import com.telepathicgrunt.the_bumblezone.events.player.BzPlayerItemUseOnBlockEvent;
import com.telepathicgrunt.the_bumblezone.fabric.FabricReloadListener;
import com.telepathicgrunt.the_bumblezone.mixin.fabric.fabricapi.BiomeModificationContextImplMixin;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import com.telepathicgrunt.the_bumblezone.utils.fabric.PlatformHooksImpl;
import com.telepathicgrunt.the_bumblezone.worldgen.structures.SempiternalSanctumBehavior;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.EmptyItemFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.FullItemFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9168;
import org.apache.logging.log4j.util.TriConsumer;

public class FabricEventManager {
    private static final Map<class_5321<class_1761>, BzAddCreativeTabEntriesEvent.Type> TYPES = (Map)class_156.method_654(new IdentityHashMap(), map -> {
        map.put(class_7706.field_40195, BzAddCreativeTabEntriesEvent.Type.BUILDING);
        map.put(class_7706.field_41059, BzAddCreativeTabEntriesEvent.Type.COLORED);
        map.put(class_7706.field_40743, BzAddCreativeTabEntriesEvent.Type.NATURAL);
        map.put(class_7706.field_40197, BzAddCreativeTabEntriesEvent.Type.FUNCTIONAL);
        map.put(class_7706.field_40198, BzAddCreativeTabEntriesEvent.Type.REDSTONE);
        map.put(class_7706.field_41060, BzAddCreativeTabEntriesEvent.Type.TOOLS);
        map.put(class_7706.field_40202, BzAddCreativeTabEntriesEvent.Type.COMBAT);
        map.put(class_7706.field_41061, BzAddCreativeTabEntriesEvent.Type.FOOD);
        map.put(class_7706.field_41062, BzAddCreativeTabEntriesEvent.Type.INGREDIENTS);
        map.put(class_7706.field_40205, BzAddCreativeTabEntriesEvent.Type.SPAWN_EGGS);
        map.put(class_7706.field_41063, BzAddCreativeTabEntriesEvent.Type.OPERATOR);
    });

    public static void init() {
        BzAddBuiltinResourcePacks.EVENT.invoke(new BzAddBuiltinResourcePacks((id, displayName, mode) -> {
            ModContainer container = FabricEventManager.getModPack(id);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)container.getMetadata().getId(), (String)id.method_12832()), (ModContainer)container, (class_2561)displayName, (ResourcePackActivationType)FabricEventManager.toType(mode));
        }));
        BzAddBuiltinDataPacks.EVENT.invoke(new BzAddBuiltinDataPacks((id, displayName, mode) -> {
            ModContainer container = FabricEventManager.getModPack(id);
            ResourceManagerHelperImpl.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)container.getMetadata().getId(), (String)id.method_12832()), (String)("datapacks/" + id.method_12832()), (ModContainer)container, (class_2561)displayName, (ResourcePackActivationType)FabricEventManager.toType(mode));
        }));
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((tab, entries) -> BzAddCreativeTabEntriesEvent.EVENT.invoke(new BzAddCreativeTabEntriesEvent(TYPES.getOrDefault(class_7923.field_44687.method_29113((Object)tab).orElse(null), BzAddCreativeTabEntriesEvent.Type.CUSTOM), tab, entries.shouldShowOpRestrictedItems(), arg_0 -> ((FabricItemGroupEntries)entries).method_45420(arg_0))));
        BzRegisterEntityAttributesEvent.EVENT.invoke(new BzRegisterEntityAttributesEvent(FabricDefaultAttributeRegistry::register));
        BzSetupEvent.EVENT.invoke(new BzSetupEvent(Runnable::run));
        BzFinalSetupEvent.EVENT.invoke(new BzFinalSetupEvent(Runnable::run));
        BzRegisterDataSerializersEvent.EVENT.invoke(new BzRegisterDataSerializersEvent((id, serializer) -> class_2943.method_12720((class_2941)serializer)));
        ServerTickEvents.END_WORLD_TICK.register(BzWorldSavedData::tick);
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            BzServerGoingToStartEvent.EVENT.invoke(new BzServerGoingToStartEvent(minecraftServer));
            PlatformHooksImpl.currentMinecraftServer = minecraftServer;
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(minecraftServer -> {
            BzServerGoingToStopEvent.EVENT.invoke(BzServerGoingToStopEvent.INSTANCE);
            PlatformHooksImpl.currentMinecraftServer = null;
        });
        ServerWorldEvents.LOAD.register((server, level) -> {
            FabricEventManager.setupWanderingTrades();
            FabricEventManager.setupVillagerTrades();
        });
        BzRegisterFlammabilityEvent.EVENT.invoke(new BzRegisterFlammabilityEvent((arg_0, arg_1, arg_2) -> ((FlammableBlockRegistry)FlammableBlockRegistry.getDefaultInstance()).add(arg_0, arg_1, arg_2)));
        BzRegisterReloadListenerEvent.EVENT.invoke(new BzRegisterReloadListenerEvent((id, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new FabricReloadListener((class_2960)id, (class_3302)listener))));
        BzRegisterSpawnPlacementsEvent.EVENT.invoke(new BzRegisterSpawnPlacementsEvent(FabricEventManager::registerPlacement));
        CommonLifecycleEvents.TAGS_LOADED.register((registry, client) -> BzTagsUpdatedEvent.EVENT.invoke(new BzTagsUpdatedEvent(registry, client)));
        PlayerBlockBreakEvents.BEFORE.register((level, player, pos, state, blockentity) -> !BzBlockBreakEvent.EVENT_LOWEST.invoke(new BzBlockBreakEvent(player, state)));
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> BzRegisterCommandsEvent.EVENT.invoke(new BzRegisterCommandsEvent((CommandDispatcher<class_2168>)dispatcher, environment, context)));
        BzRegisterBrewingRecipeEvent.EVENT.invoke(new BzRegisterBrewingRecipeEvent((TriConsumer<class_6880<class_1842>, class_1792, class_6880<class_1842>>)((TriConsumer)(input, item, output) -> FabricBrewingRecipeRegistryBuilder.BUILD.register(builder -> builder.registerPotionRecipe(input, class_1856.method_8091((class_1935[])new class_1935[]{item}), output)))));
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> BzDatapackSyncEvent.EVENT.invoke(new BzDatapackSyncEvent(player)));
        AttackBlockCallback.EVENT.register(FabricEventManager::onItemAttackBlock);
        UseBlockCallback.EVENT.register(FabricEventManager::onItemUseOnBlock);
        UseItemCallback.EVENT.register(FabricEventManager::onItemUse);
        ServerLivingEntityEvents.ALLOW_DEATH.register(FabricEventManager::allowLivingEntityDeath);
        FluidStorage.combinedItemApiProvider((class_1792)((class_1792)BzItems.HONEY_BUCKET.get())).register(context -> new FullItemFluidStorage(context, bottle -> ItemVariant.of((class_1935)class_1802.field_8550), FluidVariant.of((class_3611)((class_3611)BzFluids.HONEY_FLUID.get())), 81000L));
        FluidStorage.combinedItemApiProvider((class_1792)((class_1792)BzItems.ROYAL_JELLY_BUCKET.get())).register(context -> new FullItemFluidStorage(context, bottle -> ItemVariant.of((class_1935)class_1802.field_8550), FluidVariant.of((class_3611)((class_3611)BzFluids.ROYAL_JELLY_FLUID.get())), 81000L));
        FluidStorage.combinedItemApiProvider((class_1792)((class_1792)BzItems.ROYAL_JELLY_BOTTLE.get())).register(context -> new FullItemFluidStorage(context, bottle -> ItemVariant.of((class_1935)class_1802.field_8469), FluidVariant.of((class_3611)((class_3611)BzFluids.ROYAL_JELLY_FLUID.get())), 20250L));
        FluidStorage.combinedItemApiProvider((class_1792)class_1802.field_8469).register(context -> new EmptyItemFluidStorage(context, bottle -> ItemVariant.of((class_1935)((class_1935)BzItems.ROYAL_JELLY_BOTTLE.get())), (class_3611)BzFluids.ROYAL_JELLY_FLUID.get(), 20250L));
        FluidStorage.combinedItemApiProvider((class_1792)((class_1792)BzItems.SUGAR_WATER_BUCKET.get())).register(context -> new FullItemFluidStorage(context, bottle -> ItemVariant.of((class_1935)class_1802.field_8550), FluidVariant.of((class_3611)((class_3611)BzFluids.SUGAR_WATER_FLUID.get())), 81000L));
        FluidStorage.combinedItemApiProvider((class_1792)((class_1792)BzItems.SUGAR_WATER_BOTTLE.get())).register(context -> new FullItemFluidStorage(context, bottle -> ItemVariant.of((class_1935)class_1802.field_8469), FluidVariant.of((class_3611)((class_3611)BzFluids.SUGAR_WATER_FLUID.get())), 20250L));
        FluidStorage.combinedItemApiProvider((class_1792)class_1802.field_8469).register(context -> new EmptyItemFluidStorage(context, bottle -> ItemVariant.of((class_1935)((class_1935)BzItems.SUGAR_WATER_BOTTLE.get())), (class_3611)BzFluids.SUGAR_WATER_FLUID.get(), 20250L));
    }

    public static void lateInit() {
        if (PlatformHooks.isModLoaded("resourcefulbees") && BzModCompatibilityConfigs.spawnResourcefulBeesHoneycombVeins) {
            BiomeModifications.create((class_2960)class_2960.method_60655((String)"the_bumblezone", (String)"resourceful_bees_compat")).add(ModificationPhase.ADDITIONS, context -> context.hasTag(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"the_bumblezone", (String)"the_bumblezone"))), context -> {
                for (class_6880<class_6796> placedFeatureHolder : FabricEventManager.getPlacedFeaturesByTag(context, BzTags.RESOURCEFUL_BEES_COMBS)) {
                    class_3037 featureConfiguration = ((class_2975)((class_6796)placedFeatureHolder.comp_349()).comp_334().comp_349()).comp_333();
                    if (!(featureConfiguration instanceof class_3124)) continue;
                    class_3124 oreConfiguration = (class_3124)featureConfiguration;
                    if (!oreConfiguration.field_29063.stream().noneMatch(e -> e.field_29069.method_26215())) continue;
                    context.getGenerationSettings().addFeature(class_2893.class_2895.field_13176, (class_5321)placedFeatureHolder.method_40230().get());
                }
            });
        }
    }

    private static ModContainer getModPack(class_2960 pack) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                if (!mod.getMetadata().getId().startsWith("generated_") || !mod.findPath("resourcepacks/" + pack.method_12832()).isPresent()) continue;
                return mod;
            }
        }
        return (ModContainer)FabricLoader.getInstance().getModContainer(pack.method_12836()).orElseThrow();
    }

    private static <T extends class_1308> void registerPlacement(class_1299<T> type, BzRegisterSpawnPlacementsEvent.Placement<T> placement) {
        class_1317.method_20637(type, (class_9168)placement.spawn(), (class_2902.class_2903)placement.height(), placement.predicate());
    }

    private static ResourcePackActivationType toType(BzAddBuiltinResourcePacks.PackMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case BzAddBuiltinResourcePacks.PackMode.USER_CONTROLLED -> ResourcePackActivationType.NORMAL;
            case BzAddBuiltinResourcePacks.PackMode.ENABLED_BY_DEFAULT -> ResourcePackActivationType.DEFAULT_ENABLED;
            case BzAddBuiltinResourcePacks.PackMode.FORCE_ENABLED -> ResourcePackActivationType.ALWAYS_ENABLED;
        };
    }

    private static ResourcePackActivationType toType(BzAddBuiltinDataPacks.PackMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case BzAddBuiltinDataPacks.PackMode.USER_CONTROLLED -> ResourcePackActivationType.NORMAL;
            case BzAddBuiltinDataPacks.PackMode.ENABLED_BY_DEFAULT -> ResourcePackActivationType.DEFAULT_ENABLED;
            case BzAddBuiltinDataPacks.PackMode.FORCE_ENABLED -> ResourcePackActivationType.ALWAYS_ENABLED;
        };
    }

    private static void setupWanderingTrades() {
        Int2ObjectMap trades = class_3853.field_17724;
        List<class_3853.class_1652> basic = Arrays.stream((class_3853.class_1652[])trades.get(1)).collect(Collectors.toList());
        List<class_3853.class_1652> rare = Arrays.stream((class_3853.class_1652[])trades.get(2)).collect(Collectors.toList());
        BzRegisterWanderingTradesEvent.EVENT.invoke(new BzRegisterWanderingTradesEvent(basic::add, rare::add));
        trades.put(1, (Object)basic.toArray(new class_3853.class_1652[0]));
        trades.put(2, (Object)rare.toArray(new class_3853.class_1652[0]));
    }

    private static void setupVillagerTrades() {
        Map trades = class_3853.field_17067;
        for (class_3852 profession : class_7923.field_41195) {
            int i;
            if (profession == null) continue;
            Int2ObjectMap profTrades = trades.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap listings = new Int2ObjectOpenHashMap();
            for (i = 1; i <= 5; ++i) {
                if (profTrades.containsKey(i)) {
                    List list = Arrays.stream((class_3853.class_1652[])profTrades.get(i)).collect(Collectors.toList());
                    listings.put(i, list);
                    continue;
                }
                listings.put(i, new ArrayList());
            }
            BzRegisterVillagerTradesEvent.EVENT.invoke(new BzRegisterVillagerTradesEvent(profession, (arg_0, arg_1) -> FabricEventManager.lambda$setupVillagerTrades$33((Int2ObjectMap)listings, arg_0, arg_1)));
            for (i = 1; i <= 5; ++i) {
                profTrades.put(i, (Object)((List)listings.get(i)).toArray(new class_3853.class_1652[0]));
            }
        }
    }

    private static Iterable<class_6880<class_6796>> getPlacedFeaturesByTag(BiomeModificationContext context, class_6862<class_6796> placedFeatureTagKey) {
        class_5455 registryAccess = ((BiomeModificationContextImplMixin)context).bumblezone$getRegistries();
        class_2378 placedFeatureRegistry = registryAccess.method_30530(class_7924.field_41245);
        return placedFeatureRegistry.method_40286(placedFeatureTagKey);
    }

    public static class_1269 onItemAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        BzPlayerItemAttackBlockEvent event = new BzPlayerItemAttackBlockEvent(player, world, hand, player.method_5998(hand));
        class_1269 result = BzPlayerItemAttackBlockEvent.EVENT_HIGH.invoke(event);
        return result != null ? result : class_1269.field_5811;
    }

    public static class_1269 onItemUseOnBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        BzPlayerItemUseOnBlockEvent event = new BzPlayerItemUseOnBlockEvent(player, world, hand, hitResult, player.method_5998(hand));
        class_1269 result = BzPlayerItemUseOnBlockEvent.EVENT_HIGH.invoke(event);
        return result != null ? result : class_1269.field_5811;
    }

    public static class_1271<class_1799> onItemUse(class_1657 player, class_1937 level, class_1268 hand) {
        BzPlayerItemUseEvent event = new BzPlayerItemUseEvent(player, level, player.method_5998(hand));
        if (BzPlayerItemUseEvent.EVENT_HIGH.invoke(event)) {
            return class_1271.method_22427((Object)event.usingStack());
        }
        return class_1271.method_22430((Object)event.usingStack());
    }

    private static boolean allowLivingEntityDeath(class_1309 livingEntity, class_1282 damageSource, float damage) {
        class_3222 serverPlayer;
        if (BzEntityDeathEvent.EVENT.invoke(new BzEntityDeathEvent(livingEntity, damageSource))) {
            return false;
        }
        if (BzEntityDeathEvent.EVENT_LOWEST.invoke(new BzEntityDeathEvent(livingEntity, damageSource))) {
            return false;
        }
        if (livingEntity instanceof class_3222 && (serverPlayer = (class_3222)livingEntity).method_29504()) {
            SempiternalSanctumBehavior.onArenaAreaDeath((class_3218)serverPlayer.method_37908(), serverPlayer);
        }
        return true;
    }

    private static /* synthetic */ void lambda$setupVillagerTrades$33(Int2ObjectMap listings, Integer i, class_3853.class_1652 listing) {
        ((List)listings.get(i.intValue())).add(listing);
    }
}

