/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceAbilityData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceCooldownData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceLastChargeData;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.gameplay.CooldownInstanceAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.gameplay.ItemCooldownsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public abstract class AbilityEssenceItem
extends class_1792
implements ItemExtension {
    private final Supplier<Integer> cooldownTickLength;
    private final Supplier<Integer> abilityUseAmount;

    public AbilityEssenceItem(class_1792.class_1793 properties, Supplier<Integer> cooldownTickLength, Supplier<Integer> abilityUseAmount) {
        super(properties.method_57349((class_9331)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get(), (Object)new AbilityEssenceAbilityData()).method_57349((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData()).method_57349((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData()).method_57349((class_9331)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get(), (Object)new AbilityEssenceLastChargeData()));
        this.cooldownTickLength = cooldownTickLength;
        this.abilityUseAmount = abilityUseAmount;
    }

    public void method_7860(class_1799 itemStack) {
        if (itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get()) == null) {
            itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get(), (Object)new AbilityEssenceAbilityData());
        }
        if (itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get()) == null) {
            itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData());
        }
        if (itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get()) == null) {
            itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData());
        }
        if (itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get()) == null) {
            itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get(), (Object)new AbilityEssenceLastChargeData());
        }
    }

    public abstract int getColor();

    public int getCooldownTickLength() {
        return this.cooldownTickLength.get();
    }

    public void incrementCooldownTime(class_1799 itemStack) {
        AbilityEssenceCooldownData abilityEssenceCooldownData = (AbilityEssenceCooldownData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get());
        if (abilityEssenceCooldownData.forcedCooldown()) {
            int currentCooldownTime = abilityEssenceCooldownData.cooldownTime();
            if (currentCooldownTime < this.cooldownTickLength.get()) {
                itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData(currentCooldownTime + 1, true));
            } else {
                itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData(0, false));
                this.rechargeAbilityEntirely(itemStack);
            }
        }
    }

    public void setDepleted(class_1799 itemStack, class_3222 serverPlayer, boolean vanillaItemCooldown) {
        itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData(0, true));
        AbilityEssenceActivityData abilityEssenceAbilityData = (AbilityEssenceActivityData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
        itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData(abilityEssenceAbilityData.isInInventory(), false, abilityEssenceAbilityData.isLocked()));
        if (vanillaItemCooldown) {
            serverPlayer.method_7357().method_7906((class_1792)this, this.getCooldownTickLength());
        }
    }

    public void method_7888(class_1799 itemStack, class_1937 level, class_1297 entity, int i, boolean bl) {
        if (itemStack.method_31573(BzTags.ABILITY_ESSENCE_ITEMS) && entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
            boolean isInInventory = abilityEssenceActivityData.isInInventory();
            boolean isLocked = abilityEssenceActivityData.isLocked();
            boolean isActive = abilityEssenceActivityData.isActive();
            AbilityEssenceCooldownData abilityEssenceCooldownData = (AbilityEssenceCooldownData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get());
            int cooldownTime = abilityEssenceCooldownData.cooldownTime();
            boolean forcedCooldown = abilityEssenceCooldownData.forcedCooldown();
            if (!isInInventory) {
                isInInventory = true;
            }
            if (!EssenceOfTheBees.hasEssence(serverPlayer)) {
                itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData(isInInventory, false, true));
                return;
            }
            if (isLocked) {
                isLocked = false;
            }
            if (forcedCooldown) {
                if (!serverPlayer.method_7357().method_7904(itemStack.method_7909())) {
                    serverPlayer.method_7357().method_7906(itemStack.method_7909(), this.getCooldownTickLength() - cooldownTime);
                }
                this.incrementCooldownTime(itemStack);
            } else if (serverPlayer.method_7357().method_7904(itemStack.method_7909())) {
                class_1796.class_1797 cooldownInstance = ((ItemCooldownsAccessor)serverPlayer.method_7357()).bumblezone$getCooldowns().get(itemStack.method_7909());
                int tempCooldownTime = ((ItemCooldownsAccessor)serverPlayer.method_7357()).bumblezone$getTickCount() - ((CooldownInstanceAccessor)cooldownInstance).bumblezone$getStartTime();
                if (tempCooldownTime > 5) {
                    forcedCooldown = true;
                    cooldownTime = tempCooldownTime;
                    isActive = false;
                }
            } else if (serverPlayer.method_6079() == itemStack) {
                if (!isActive) {
                    isActive = true;
                }
                this.applyAbilityEffects(itemStack, level, serverPlayer);
            } else {
                this.rechargeAbilitySlowly(itemStack, serverPlayer);
                if (isActive) {
                    isActive = false;
                }
            }
            if (abilityEssenceActivityData.isDifferent(isInInventory, isActive, isLocked)) {
                itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get(), (Object)new AbilityEssenceActivityData(isInInventory, isActive, isLocked));
            }
            if (abilityEssenceCooldownData.isDifferent(cooldownTime, forcedCooldown)) {
                itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get(), (Object)new AbilityEssenceCooldownData(cooldownTime, forcedCooldown));
            }
        }
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> components, class_1836 tooltipFlag) {
        AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
        if (abilityEssenceActivityData.isLocked()) {
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_locked").method_27692(class_124.field_1079));
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_locked_description_1").method_27692(class_124.field_1080));
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_locked_description_2").method_27692(class_124.field_1080));
        } else if (abilityEssenceActivityData.isActive()) {
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_active").method_27692(class_124.field_1061));
            components.add((class_2561)class_2561.method_43469((String)"item.the_bumblezone.essence_usage", (Object[])new Object[]{this.getAbilityUseRemaining(itemStack), this.getMaxAbilityUseAmount()}).method_27692(class_124.field_1054));
            components.add((class_2561)class_2561.method_43473());
            this.addDescriptionComponents(components);
            return;
        }
        AbilityEssenceCooldownData abilityEssenceCooldownData = (AbilityEssenceCooldownData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_COOLDOWN_DATA.get());
        int cooldownTime = abilityEssenceCooldownData.cooldownTime();
        boolean forcedCooldown = abilityEssenceCooldownData.forcedCooldown();
        if (forcedCooldown) {
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_depleted").method_27692(class_124.field_1079));
            components.add((class_2561)class_2561.method_43469((String)"item.the_bumblezone.essence_cooldown", (Object[])new Object[]{GeneralUtils.formatTickDurationNoMilliseconds(this.getCooldownTickLength() - cooldownTime, tooltipContext.method_59531())}).method_27692(class_124.field_1079));
            components.add((class_2561)class_2561.method_43473());
            this.addDescriptionComponents(components);
        } else {
            components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_ready").method_27692(class_124.field_1060));
            components.add((class_2561)class_2561.method_43469((String)"item.the_bumblezone.essence_usage", (Object[])new Object[]{this.getAbilityUseRemaining(itemStack), this.getMaxAbilityUseAmount()}).method_27692(class_124.field_1054));
            components.add((class_2561)class_2561.method_43473());
            this.addDescriptionComponents(components);
        }
    }

    abstract void addDescriptionComponents(List<class_2561> var1);

    abstract void applyAbilityEffects(class_1799 var1, class_1937 var2, class_3222 var3);

    public int getAbilityUseRemaining(class_1799 itemStack) {
        AbilityEssenceAbilityData abilityEssenceAbilityData = (AbilityEssenceAbilityData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get());
        if (abilityEssenceAbilityData.abilityUseRemaining() < 0) {
            return this.getMaxAbilityUseAmount();
        }
        return abilityEssenceAbilityData.abilityUseRemaining();
    }

    public int getMaxAbilityUseAmount() {
        return this.abilityUseAmount.get();
    }

    public void setAbilityUseRemaining(class_1799 itemStack, int abilityUseRemaining) {
        itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_ABILITY_DATA.get(), (Object)new AbilityEssenceAbilityData(abilityUseRemaining));
    }

    public boolean decrementAbilityUseRemaining(class_1799 stack, class_3222 serverPlayer, int decreaseAmount) {
        if (serverPlayer.method_7337() || serverPlayer.method_7325()) {
            return false;
        }
        int getRemainingUse = Math.max(this.getAbilityUseRemaining(stack) - decreaseAmount, 0);
        this.setAbilityUseRemaining(stack, getRemainingUse);
        if (getRemainingUse == 0) {
            this.setDepleted(stack, serverPlayer, false);
            return true;
        }
        return false;
    }

    public void rechargeAbilityEntirely(class_1799 stack) {
        this.setAbilityUseRemaining(stack, this.getMaxAbilityUseAmount());
    }

    public void rechargeAbilitySlowly(class_1799 itemStack, class_3222 serverPlayer) {
        int abilityUseRemaining = this.getAbilityUseRemaining(itemStack);
        if (abilityUseRemaining < this.getMaxAbilityUseAmount()) {
            AbilityEssenceLastChargeData abilityEssenceLastChargeData = (AbilityEssenceLastChargeData)itemStack.method_57824((class_9331)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get());
            long lastChargeTime = abilityEssenceLastChargeData.lastChargeTime();
            if (lastChargeTime == 0L || (long)serverPlayer.field_6012 < lastChargeTime) {
                itemStack.method_57379((class_9331)BzDataComponents.ABILITY_ESSENCE_LAST_CHARGE_DATA.get(), (Object)new AbilityEssenceLastChargeData(serverPlayer.field_6012));
            } else {
                long timeFromLastCharge = (long)serverPlayer.field_6012 - lastChargeTime;
                int chargeTimeIncrement = Math.max(this.getCooldownTickLength() / this.getMaxAbilityUseAmount(), 1);
                if (timeFromLastCharge % (long)chargeTimeIncrement == 0L) {
                    this.setAbilityUseRemaining(itemStack, abilityUseRemaining + 1);
                }
            }
        }
    }

    @Override
    public class_1304 bz$getEquipmentSlot(class_1799 stack) {
        return class_1304.field_6171;
    }

    @Nullable
    public class_1304 getEquipmentSlot(class_1799 stack) {
        return this.bz$getEquipmentSlot(stack);
    }

    public boolean method_31567(class_1799 itemStack) {
        int remainingUse = this.getAbilityUseRemaining(itemStack);
        return remainingUse != 0 && this.getMaxAbilityUseAmount() != remainingUse;
    }

    public int method_31569(class_1799 itemStack) {
        float remainingUse = this.getAbilityUseRemaining(itemStack);
        float maxAmount = this.getMaxAbilityUseAmount();
        return Math.round(remainingUse / maxAmount * 13.0f);
    }

    public int method_31571(class_1799 itemStack) {
        float remainingUse = this.getAbilityUseRemaining(itemStack);
        float maxAmount = this.getMaxAbilityUseAmount();
        float redValue = Math.max(0.0f, remainingUse / maxAmount);
        return class_3532.method_15369((float)(redValue / 3.0f), (float)1.0f, (float)1.0f);
    }
}

