/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;

public class EnchantmentUtils {
    public static long getPlayerXP(class_1657 player) {
        return (long)((float)EnchantmentUtils.getExperienceForLevel(player.field_7520) + player.field_7510 * (float)player.method_7349());
    }

    private static long sum(int n, int a0, int d) {
        return (long)n * (2L * (long)a0 + ((long)n - 1L) * (long)d) / 2L;
    }

    public static long getExperienceForLevel(int level) {
        if (level == 0) {
            return 0L;
        }
        if (level <= 15) {
            return EnchantmentUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315L + EnchantmentUtils.sum(level - 15, 37, 5);
        }
        return 1395L + EnchantmentUtils.sum(level - 30, 112, 9);
    }

    public static Map<class_2960, class_1889> allAllowedEnchantsWithoutMaxLimit(class_1937 level, int enchantmentLevel, class_1799 itemStack, int xpTier) {
        HashMap<class_2960, class_1889> map = new HashMap<class_2960, class_1889>();
        boolean bookFlag = itemStack.method_31574(class_1802.field_8529) || itemStack.method_31574(class_1802.field_8598);
        boolean allowTreasure = xpTier == 7;
        Map<class_1887, Integer> existingEnchantments = EnchantmentUtils.getEnchantmentsOnBook(itemStack);
        class_2378 enchantmentRegistry = (class_2378)level.method_30349().method_33310(class_7924.field_41265).get();
        enchantmentRegistry.method_40270().forEach(enchantment -> {
            boolean forceAllowed = enchantment.method_40220(BzTags.FORCED_ALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS);
            boolean disallowed = enchantment.method_40220(BzTags.DISALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS);
            if (!forceAllowed && disallowed) {
                return;
            }
            int minLevelAllowed = ((class_1887)enchantment.comp_349()).method_8187();
            if (existingEnchantments.containsKey(enchantment.comp_349())) {
                minLevelAllowed = Math.max(minLevelAllowed, (Integer)existingEnchantments.get(enchantment.comp_349()) + 1);
            }
            if ((enchantment.method_40220(class_9636.field_51547) || enchantment.method_40220(class_9636.field_51550) || enchantment.method_40220(class_9636.field_51558)) && (!enchantment.method_40220(class_9636.field_51557) || allowTreasure) && (bookFlag || ((class_1887)enchantment.comp_349()).method_8192(itemStack) && ((class_1887)enchantment.comp_349()).method_58444(itemStack)) || forceAllowed) {
                for (int i = ((class_1887)enchantment.comp_349()).method_8183(); i > minLevelAllowed - 1; --i) {
                    class_1889 enchantmentInstance;
                    if (!forceAllowed && enchantmentLevel < ((class_1887)enchantment.comp_349()).method_8182(i) || xpTier <= EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance = new class_1889((class_6880)enchantment, xpTier <= 2 ? 1 : i))) continue;
                    map.put(enchantmentRegistry.method_10221((Object)((class_1887)enchantmentInstance.field_9093.comp_349())), enchantmentInstance);
                    break;
                }
            }
        });
        return map;
    }

    public static Map<class_1887, Integer> getEnchantmentsOnBook(class_1799 itemStack) {
        Set enchantments = ((class_9304)itemStack.method_57825(class_9334.field_49643, (Object)class_9304.field_49385)).method_57539();
        Object2IntOpenHashMap existingEnchants = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry : enchantments) {
            existingEnchants.put((class_1887)((class_6880)entry.getKey()).comp_349(), entry.getIntValue());
        }
        return existingEnchants;
    }

    public static int getEnchantmentTierCost(class_1889 enchantmentInstance) {
        return EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance.field_9094, ((class_1887)enchantmentInstance.field_9093.comp_349()).method_8182(((class_5321)enchantmentInstance.field_9093.method_40230().get()).method_29177().method_12836().equals("minecraft") ? Math.max(enchantmentInstance.field_9094, 2) : enchantmentInstance.field_9094), enchantmentInstance.field_9093.method_40220(class_9636.field_51557), enchantmentInstance.field_9093.method_40220(class_9636.field_51551));
    }

    public static int getEnchantmentTierCost(int level, int minCost, boolean isTreasureOnly, boolean isCurse) {
        int cost = 0;
        cost += minCost / 10;
        cost += (int)((float)level / 1.5f);
        if (isTreasureOnly) {
            cost += 2;
        }
        if (isCurse) {
            cost -= 3;
        }
        return Math.max(1, Math.min(6, cost += BzGeneralConfigs.crystallineFlowerExtraTierCost));
    }

    public static class_6880<class_1887> getEnchantmentHolder(class_2960 enchantmentRL, class_1937 level) {
        return ((class_2378)level.method_30349().method_33310(class_7924.field_41265).get()).method_55841(enchantmentRL).orElse(null);
    }

    public static class_6880<class_1887> getEnchantmentHolder(class_5321<class_1887> enchantmentRL, class_1937 level) {
        return ((class_2378)level.method_30349().method_33310(class_7924.field_41265).get()).method_40264(enchantmentRL).orElse(null);
    }
}

