/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyCrystal;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5544;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class BeeDungeonProcessor
extends class_3491 {
    public static final MapCodec<BeeDungeonProcessor> CODEC = MapCodec.unit(BeeDungeonProcessor::new);

    private BeeDungeonProcessor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 pos, class_2338 blockPos, class_3499.class_3501 structureBlockInfoLocal, class_3499.class_3501 structureBlockInfoWorld, class_3492 settings) {
        if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.comp_1341())) {
            return structureBlockInfoWorld;
        }
        class_2680 blockState = structureBlockInfoWorld.comp_1342();
        class_2338 worldPos = structureBlockInfoWorld.comp_1341();
        class_2487 nbt = structureBlockInfoWorld.comp_1343();
        if (blockState.method_27852(class_2246.field_10465)) {
            class_2487 compoundTag = structureBlockInfoWorld.comp_1343();
            if (compoundTag == null) {
                return structureBlockInfoWorld;
            }
            String metadata = compoundTag.method_10558("metadata");
            class_2680 belowBlock = levelReader.method_22350(worldPos).method_8320(worldPos);
            if (!metadata.isEmpty()) {
                nbt = null;
            }
            if (belowBlock.method_26215()) {
                blockState = class_2246.field_10543.method_9564();
                return new class_3499.class_3501(worldPos, blockState, nbt);
            } else {
                class_5819 random = settings.method_15115(worldPos);
                switch (metadata) {
                    case "center": {
                        if (random.method_43057() < 0.1f) {
                            blockState = ((class_2248)BzBlocks.HONEY_COCOON.get()).method_9564();
                            nbt = new class_2487();
                            nbt.method_10582("LootTable", "the_bumblezone:structures/bee_dungeon");
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.6f) {
                            blockState = ((class_2248)BzBlocks.HONEY_CRYSTAL.get()).method_9564();
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.6f) {
                            Optional optionalBlocks = class_7923.field_41175.method_40266(BzTags.BEE_DUNGEON_POSSIBLE_CANDLES);
                            if (!optionalBlocks.isPresent()) return new class_3499.class_3501(worldPos, blockState, nbt);
                            blockState = ((class_2248)((class_6885.class_6888)optionalBlocks.get()).method_40240(random.method_43048(((class_6885.class_6888)optionalBlocks.get()).method_40247())).comp_349()).method_9564();
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(random.method_43048(4) + 1));
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true));
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        blockState = class_2246.field_10543.method_9564();
                        return new class_3499.class_3501(worldPos, blockState, nbt);
                    }
                    case "inner_ring": {
                        if (random.method_43057() < 0.35f) {
                            blockState = ((class_2248)BzBlocks.HONEY_CRYSTAL.get()).method_9564();
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.35f) {
                            Optional optionalBlocks = class_7923.field_41175.method_40266(BzTags.BEE_DUNGEON_POSSIBLE_CANDLES);
                            if (!optionalBlocks.isPresent()) return new class_3499.class_3501(worldPos, blockState, nbt);
                            blockState = ((class_2248)((class_6885.class_6888)optionalBlocks.get()).method_40240(random.method_43048(((class_6885.class_6888)optionalBlocks.get()).method_40247())).comp_349()).method_9564();
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(random.method_43048(random.method_43048(4) + 1) + 1));
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true));
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        blockState = class_2246.field_10543.method_9564();
                        return new class_3499.class_3501(worldPos, blockState, nbt);
                    }
                    case "outer_ring": {
                        if (random.method_43057() < 0.45f) {
                            blockState = ((class_2248)BzBlocks.HONEY_CRYSTAL.get()).method_9564();
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.2f) {
                            Optional optionalBlocks = class_7923.field_41175.method_40266(BzTags.BEE_DUNGEON_POSSIBLE_CANDLES);
                            if (!optionalBlocks.isPresent()) return new class_3499.class_3501(worldPos, blockState, nbt);
                            blockState = ((class_2248)((class_6885.class_6888)optionalBlocks.get()).method_40240(random.method_43048(((class_6885.class_6888)optionalBlocks.get()).method_40247())).comp_349()).method_9564();
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(random.method_43048(random.method_43048(4) + 1) + 1));
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true));
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        blockState = class_2246.field_10543.method_9564();
                        return new class_3499.class_3501(worldPos, blockState, nbt);
                    }
                }
            }
            return new class_3499.class_3501(worldPos, blockState, nbt);
        } else if (blockState.method_27852(class_2246.field_21212) || blockState.method_27852((class_2248)BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            class_5819 random = settings.method_15115(worldPos);
            boolean compatSuccess = false;
            for (ModCompat compat : ModChecker.DUNGEON_COMB_COMPATS) {
                if (!compat.checkCombSpawn(worldPos, random, levelReader, false)) continue;
                class_3499.class_3501 info = compat.getHoneycomb(worldPos, random, levelReader, false);
                if (info != null) {
                    return info;
                }
                compatSuccess = true;
                break;
            }
            if (compatSuccess) return new class_3499.class_3501(worldPos, blockState, nbt);
            blockState = random.method_43057() < 0.4f ? class_2246.field_21212.method_9564() : ((class_2248)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).method_9564();
            return new class_3499.class_3501(worldPos, blockState, nbt);
        } else if (blockState.method_27852((class_2248)BzBlocks.HONEYCOMB_BROOD.get())) {
            class_5819 random = settings.method_15115(worldPos);
            blockState = random.method_43057() < 0.6f ? (class_2680)((class_2680)((class_2248)BzBlocks.HONEYCOMB_BROOD.get()).method_9564().method_11657((class_2769)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random.method_43048(3)))).method_11657((class_2769)HoneycombBrood.field_10927, (Comparable)((class_2350)blockState.method_11654((class_2769)HoneycombBrood.field_10927))) : (random.method_43057() < 0.2f ? class_2246.field_21211.method_9564() : ((class_2248)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).method_9564());
            return new class_3499.class_3501(worldPos, blockState, nbt);
        } else {
            class_5819 random;
            if (!blockState.method_27852((class_2248)BzFluids.SUGAR_WATER_BLOCK.get()) || !((random = settings.method_15115(worldPos)).method_43057() < 0.1f)) return new class_3499.class_3501(worldPos, blockState, nbt);
            blockState = (class_2680)((class_2248)BzBlocks.HONEY_CRYSTAL.get()).method_9564().method_11657((class_2769)HoneyCrystal.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return new class_3499.class_3501(worldPos, blockState, nbt);
    }

    protected class_3828<?> method_16772() {
        return (class_3828)BzProcessors.BEE_DUNGEON_PROCESSOR.get();
    }
}

