/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzWorldgenConfigs;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5544;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class SpiderInfestedBeeDungeonProcessor
extends class_3491 {
    public static final MapCodec<SpiderInfestedBeeDungeonProcessor> CODEC = MapCodec.unit(SpiderInfestedBeeDungeonProcessor::new);

    private SpiderInfestedBeeDungeonProcessor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 pos, class_2338 blockPos, class_3499.class_3501 structureBlockInfoLocal, class_3499.class_3501 structureBlockInfoWorld, class_3492 settings) {
        if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.comp_1341())) {
            return structureBlockInfoWorld;
        }
        class_2680 blockState = structureBlockInfoWorld.comp_1342();
        class_2338 worldPos = structureBlockInfoWorld.comp_1341();
        class_2487 nbt = structureBlockInfoWorld.comp_1343();
        if (blockState.method_27852(class_2246.field_10465)) {
            class_2487 compoundTag = structureBlockInfoWorld.comp_1343();
            if (compoundTag == null) {
                return structureBlockInfoWorld;
            }
            String metadata = compoundTag.method_10558("metadata");
            class_2680 belowBlock = levelReader.method_22350(worldPos).method_8320(worldPos);
            if (!metadata.isEmpty()) {
                nbt = null;
            }
            if (belowBlock.method_26215()) {
                blockState = class_2246.field_10543.method_9564();
                return new class_3499.class_3501(worldPos, blockState, nbt);
            } else {
                class_5819 random = settings.method_15115(worldPos);
                switch (metadata) {
                    case "center": {
                        if (random.method_43057() < 0.1f) {
                            blockState = ((class_2248)BzBlocks.HONEY_COCOON.get()).method_9564();
                            nbt = new class_2487();
                            nbt.method_10582("LootTable", "the_bumblezone:structures/spider_infested_bee_dungeon");
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.6f) {
                            blockState = ((class_2248)BzBlocks.HONEY_CRYSTAL.get()).method_9564();
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.25f) {
                            Optional optionalBlocks = class_7923.field_41175.method_40266(BzTags.SPIDER_INFESTED_BEE_DUNGEON_POSSIBLE_CANDLES);
                            if (!optionalBlocks.isPresent()) return new class_3499.class_3501(worldPos, blockState, nbt);
                            blockState = ((class_2248)((class_6885.class_6888)optionalBlocks.get()).method_40240(random.method_43048(((class_6885.class_6888)optionalBlocks.get()).method_40247())).comp_349()).method_9564();
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(random.method_43048(4) + 1));
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false));
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.05f) {
                            blockState = class_2246.field_10343.method_9564();
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        blockState = class_2246.field_10543.method_9564();
                        return new class_3499.class_3501(worldPos, blockState, nbt);
                    }
                    case "inner_ring": {
                        if (random.method_43057() < 0.3f) {
                            blockState = ((class_2248)BzBlocks.HONEY_CRYSTAL.get()).method_9564();
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.07f) {
                            blockState = class_2246.field_10343.method_9564();
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        blockState = class_2246.field_10543.method_9564();
                        return new class_3499.class_3501(worldPos, blockState, nbt);
                    }
                    case "outer_ring": {
                        if (random.method_43057() < 0.4f) {
                            blockState = ((class_2248)BzBlocks.HONEY_CRYSTAL.get()).method_9564();
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.2f) {
                            Optional optionalBlocks = class_7923.field_41175.method_40266(BzTags.SPIDER_INFESTED_BEE_DUNGEON_POSSIBLE_CANDLES);
                            if (!optionalBlocks.isPresent()) return new class_3499.class_3501(worldPos, blockState, nbt);
                            blockState = ((class_2248)((class_6885.class_6888)optionalBlocks.get()).method_40240(random.method_43048(((class_6885.class_6888)optionalBlocks.get()).method_40247())).comp_349()).method_9564();
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(random.method_43048(random.method_43048(4) + 1) + 1));
                            blockState = (class_2680)blockState.method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false));
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        if (random.method_43057() < 0.07f) {
                            blockState = class_2246.field_10343.method_9564();
                            return new class_3499.class_3501(worldPos, blockState, nbt);
                        }
                        blockState = class_2246.field_10543.method_9564();
                        return new class_3499.class_3501(worldPos, blockState, nbt);
                    }
                }
            }
            return new class_3499.class_3501(worldPos, blockState, nbt);
        } else if (blockState.method_27852(class_2246.field_21212) || blockState.method_27852((class_2248)BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            boolean compatSuccess = false;
            class_5819 random = settings.method_15115(worldPos);
            for (ModCompat compat : ModChecker.DUNGEON_COMB_COMPATS) {
                class_3499.class_3501 info;
                if (!compat.checkCombSpawn(worldPos, random, levelReader, true) || (info = compat.getHoneycomb(worldPos, random, levelReader, true)) == null) continue;
                return info;
            }
            if (compatSuccess) return new class_3499.class_3501(worldPos, blockState, nbt);
            blockState = random.method_43057() < 0.15f ? class_2246.field_21212.method_9564() : ((class_2248)BzBlocks.POROUS_HONEYCOMB.get()).method_9564();
            return new class_3499.class_3501(worldPos, blockState, nbt);
        } else if (blockState.method_27852((class_2248)BzBlocks.HONEYCOMB_BROOD.get())) {
            class_5819 random = settings.method_15115(worldPos);
            blockState = random.method_43057() < 0.6f ? (class_2680)((class_2248)BzBlocks.EMPTY_HONEYCOMB_BROOD.get()).method_9564().method_11657((class_2769)HoneycombBrood.field_10927, (Comparable)((class_2350)blockState.method_11654((class_2769)HoneycombBrood.field_10927))) : (random.method_43058() < BzWorldgenConfigs.spawnerRateSpiderBeeDungeon ? class_2246.field_10260.method_9564() : ((class_2248)BzBlocks.POROUS_HONEYCOMB.get()).method_9564());
            return new class_3499.class_3501(worldPos, blockState, nbt);
        } else {
            if (!blockState.method_27852((class_2248)BzFluids.SUGAR_WATER_BLOCK.get())) return new class_3499.class_3501(worldPos, blockState, nbt);
            blockState = class_2246.field_10543.method_9564();
        }
        return new class_3499.class_3501(worldPos, blockState, nbt);
    }

    protected class_3828<?> method_16772() {
        return (class_3828)BzProcessors.SPIDER_INFESTED_BEE_DUNGEON_PROCESSOR.get();
    }
}

