/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.advancements.ItemSpecificTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_5425;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;

public class EssenceBlockEntity
extends class_2586 {
    private static final String UUID_TAG = "uuid";
    private static final String EVENT_TIMER_TAG = "eventTimer";
    private static final String PROGRESS_TAG = "eventBarProgress";
    private static final String PLAYERS_IN_ARENA_TAG = "playersInArena";
    private static final String EVENT_ENTITIES_IN_ARENA_TAG = "eventEntitiesInArena";
    private static final String EXTRA_EVENT_TRACKING_PROGRESS_TAG = "extraEventTrackingProgress";
    private static final String ARENA_SIZE_TAG = "arenaSize";
    private static final String BEATEN_TAG = "beaten";
    private UUID uuid = null;
    private int eventTimer = 0;
    private List<UUID> playerInArena = new ArrayList<UUID>();
    private ServerEssenceEvent eventBar = null;
    private List<EventEntities> eventEntitiesInArena = Collections.synchronizedList(new ArrayList());
    private int extraEventTrackingProgress = 0;
    private class_2338 arenaSize = class_2338.field_10980;
    private boolean beaten = false;

    protected EssenceBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof EssenceBlock) {
            EssenceBlock essenceBlock = (EssenceBlock)class_22482;
            this.eventBar = essenceBlock.getServerEssenceEvent();
        }
    }

    public EssenceBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this((class_2591)BzBlockEntities.ESSENCE_BLOCK.get(), blockPos, blockState);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof EssenceBlock) {
            EssenceBlock essenceBlock = (EssenceBlock)class_22482;
            this.eventBar = essenceBlock.getServerEssenceEvent();
        }
    }

    public int getEventTimer() {
        return this.eventTimer;
    }

    public void setEventTimer(int eventTimer) {
        this.eventTimer = eventTimer;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public List<UUID> getPlayerInArena() {
        return this.playerInArena;
    }

    public void setPlayerInArena(List<UUID> playerInArena) {
        this.playerInArena = playerInArena;
    }

    public ServerEssenceEvent getEventBar() {
        return this.eventBar;
    }

    public void setEventBar(ServerEssenceEvent eventBar) {
        this.eventBar = eventBar;
    }

    public List<EventEntities> getEventEntitiesInArena() {
        return this.eventEntitiesInArena;
    }

    public void setEventEntitiesInArena(List<EventEntities> eventEntitiesInArena) {
        this.eventEntitiesInArena = eventEntitiesInArena;
    }

    public int getExtraEventTrackingProgress() {
        return this.extraEventTrackingProgress;
    }

    public void setExtraEventTrackingProgress(int extraEventTrackingProgress) {
        this.extraEventTrackingProgress = extraEventTrackingProgress;
    }

    public class_2338 getArenaSize() {
        return this.arenaSize;
    }

    public void setArenaSize(class_2338 arenaSize) {
        this.arenaSize = arenaSize;
    }

    public boolean isBeaten() {
        return this.beaten;
    }

    public void setBeaten(boolean beaten) {
        this.beaten = beaten;
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        if (compoundTag != null) {
            this.beaten = compoundTag.method_10577(BEATEN_TAG);
            this.eventBar.method_5408(compoundTag.method_10583(PROGRESS_TAG));
            this.extraEventTrackingProgress = compoundTag.method_10550(EXTRA_EVENT_TRACKING_PROGRESS_TAG);
            this.eventTimer = compoundTag.method_10550(EVENT_TIMER_TAG);
            this.eventBar.setEndEventTimer(this.eventTimer, this.method_10997() == null ? 1.0f : this.method_10997().method_54719().method_54748());
            this.uuid = compoundTag.method_10545(UUID_TAG) ? compoundTag.method_25926(UUID_TAG) : UUID.randomUUID();
            if (compoundTag.method_10545(PLAYERS_IN_ARENA_TAG)) {
                this.playerInArena.clear();
                for (class_2520 tag : compoundTag.method_10554(PLAYERS_IN_ARENA_TAG, 11)) {
                    this.playerInArena.add(class_2512.method_25930((class_2520)tag));
                }
            }
            if (compoundTag.method_10545(EVENT_ENTITIES_IN_ARENA_TAG)) {
                this.eventEntitiesInArena.clear();
                for (class_2520 tag : compoundTag.method_10554(EVENT_ENTITIES_IN_ARENA_TAG, 11)) {
                    this.eventEntitiesInArena.add(new EventEntities(class_2512.method_25930((class_2520)tag)));
                }
            }
            this.arenaSize = class_2512.method_10691((class_2487)compoundTag.method_10562(ARENA_SIZE_TAG), (String)ARENA_SIZE_TAG).orElse(class_2338.field_10980);
        }
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 8);
        }
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        this.saveFieldsToTag(compoundTag);
        if (this.method_10997() != null) {
            for (int i = this.getPlayerInArena().size() - 1; i >= 0; --i) {
                UUID playerUUID = this.getPlayerInArena().get(i);
                class_3222 serverPlayer = this.method_10997().method_8503().method_3760().method_14602(playerUUID);
                if (serverPlayer == null || !serverPlayer.method_29504() && Math.abs(serverPlayer.method_24515().method_10263() - this.method_11016().method_10263()) <= (this.getArenaSize().method_10263() + 1) / 2 && Math.abs(serverPlayer.method_24515().method_10264() - this.method_11016().method_10264()) <= (this.getArenaSize().method_10264() + 1) / 2 && Math.abs(serverPlayer.method_24515().method_10260() - this.method_11016().method_10260()) <= (this.getArenaSize().method_10260() + 1) / 2) continue;
                class_2248 class_22482 = this.method_11010().method_26204();
                if (class_22482 instanceof EssenceBlock) {
                    EssenceBlock essenceBlock = (EssenceBlock)class_22482;
                    essenceBlock.onPlayerLeave(serverPlayer.method_51469(), serverPlayer, this);
                }
                this.getPlayerInArena().remove(playerUUID);
                this.getEventBar().method_14089(serverPlayer);
                this.method_5431();
            }
        }
    }

    private void saveFieldsToTag(class_2487 compoundTag) {
        compoundTag.method_10556(BEATEN_TAG, this.beaten);
        compoundTag.method_10566(UUID_TAG, (class_2520)class_2512.method_25929((UUID)this.getUUID()));
        compoundTag.method_10569(EVENT_TIMER_TAG, this.eventTimer);
        compoundTag.method_10569(EXTRA_EVENT_TRACKING_PROGRESS_TAG, this.extraEventTrackingProgress);
        compoundTag.method_10548(PROGRESS_TAG, this.eventBar.method_5412());
        class_2499 players = new class_2499();
        for (UUID target : this.playerInArena) {
            players.add((Object)class_2512.method_25929((UUID)target));
        }
        compoundTag.method_10566(PLAYERS_IN_ARENA_TAG, (class_2520)players);
        class_2499 eventEntities = new class_2499();
        for (EventEntities target : this.eventEntitiesInArena) {
            eventEntities.add((Object)class_2512.method_25929((UUID)target.uuid()));
        }
        compoundTag.method_10566(EVENT_ENTITIES_IN_ARENA_TAG, (class_2520)eventEntities);
        compoundTag.method_10566(ARENA_SIZE_TAG, class_2512.method_10692((class_2338)this.arenaSize));
    }

    public class_2960 getSavedNbtLocation() {
        return class_2960.method_60655((String)"the_bumblezone", (String)("essence/saved_area/" + this.method_11016().method_10263() + "_" + this.method_11016().method_10264() + "_" + this.method_11016().method_10260() + "_" + this.getUUID().toString().toLowerCase(Locale.ROOT)));
    }

    public String getSavedNbtLocationAsString() {
        return "the_bumblezone:essence/saved_area/" + this.method_11016().method_10263() + "_" + this.method_11016().method_10264() + "_" + this.method_11016().method_10260() + "_" + this.getUUID().toString().toLowerCase(Locale.ROOT);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        this.saveFieldsToTag(tag);
        return tag;
    }

    public boolean shouldDrawSide(class_2350 direction) {
        return class_2248.method_9607((class_2680)this.method_11010(), (class_1922)this.method_10997(), (class_2338)this.method_11016(), (class_2350)direction, (class_2338)this.method_11016().method_10093(direction));
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (!essenceBlockEntity.getPlayerInArena().isEmpty()) {
                EssenceBlockEntity.performArenaTick(serverLevel, blockPos, blockState, essenceBlockEntity);
            } else if (essenceBlockEntity.getEventTimer() > 0) {
                EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, false);
            }
        }
    }

    private static void performArenaTick(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity) {
        boolean endEvent = false;
        if (serverLevel.method_8510() % 20L == 1L) {
            for (int i = essenceBlockEntity.getPlayerInArena().size() - 1; i >= 0; --i) {
                UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(i);
                class_3222 serverPlayer = (class_3222)serverLevel.method_18470(playerUUID);
                if (serverPlayer != null && !PlatformHooks.isFakePlayer(serverPlayer)) {
                    EssenceBlock essenceBlock;
                    class_2248 class_22482;
                    if (serverPlayer.method_29504() || Math.abs(serverPlayer.method_24515().method_10263() - blockPos.method_10263()) > essenceBlockEntity.getArenaSize().method_10263() / 2 || Math.abs(serverPlayer.method_24515().method_10264() - blockPos.method_10264()) > essenceBlockEntity.getArenaSize().method_10264() / 2 || Math.abs(serverPlayer.method_24515().method_10260() - blockPos.method_10260()) > essenceBlockEntity.getArenaSize().method_10260() / 2) {
                        class_22482 = essenceBlockEntity.method_11010().method_26204();
                        if (class_22482 instanceof EssenceBlock) {
                            essenceBlock = (EssenceBlock)class_22482;
                            essenceBlock.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
                        }
                        essenceBlockEntity.getPlayerInArena().remove(playerUUID);
                        essenceBlockEntity.getEventBar().method_14089(serverPlayer);
                        essenceBlockEntity.method_5431();
                        continue;
                    }
                    class_22482 = essenceBlockEntity.method_11010().method_26204();
                    if (!(class_22482 instanceof EssenceBlock)) continue;
                    essenceBlock = (EssenceBlock)class_22482;
                    if (!essenceBlockEntity.getEventBar().method_14092().contains(serverPlayer)) {
                        essenceBlockEntity.getEventBar().method_14088(serverPlayer);
                        essenceBlock.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
                    }
                    if (!essenceBlock.hasMiningFatigue()) continue;
                    if (serverPlayer.method_6059(class_1294.field_5901) && serverPlayer.method_6112(class_1294.field_5901).method_5578() >= 0) {
                        serverPlayer.method_6016(class_1294.field_5901);
                    }
                    serverPlayer.method_6092(new class_1293(class_1294.field_5901, essenceBlockEntity.getEventTimer(), -1, false, false));
                    continue;
                }
                essenceBlockEntity.getPlayerInArena().remove(playerUUID);
                essenceBlockEntity.getEventBar().method_14089(serverPlayer);
                essenceBlockEntity.method_5431();
            }
            if (essenceBlockEntity.getPlayerInArena().isEmpty()) {
                endEvent = true;
            }
        }
        if (essenceBlockEntity.getEventTimer() <= 0) {
            endEvent = true;
        }
        if (endEvent) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, false);
        } else {
            essenceBlockEntity.setEventTimer(essenceBlockEntity.getEventTimer() - 1);
            essenceBlockEntity.getEventBar().setEndEventTimer(essenceBlockEntity.getEventTimer(), serverLevel.method_54719().method_54748());
            class_2248 class_22483 = blockState.method_26204();
            if (class_22483 instanceof EssenceBlock) {
                EssenceBlock essenceBlock = (EssenceBlock)class_22483;
                essenceBlock.performUniqueArenaTick(serverLevel, blockPos, blockState, essenceBlockEntity);
            }
            essenceBlockEntity.method_5431();
        }
    }

    public static void EndEvent(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity, boolean won) {
        Optional optionalStructureTemplate = serverLevel.method_14183().method_15094(essenceBlockEntity.getSavedNbtLocation());
        optionalStructureTemplate.ifPresentOrElse(structureTemplate -> {
            class_2382 size = structureTemplate.method_15160();
            class_2338 negativeHalfLengths = new class_2338(-size.method_10263() / 2, -size.method_10264() / 2, -size.method_10260() / 2);
            structureTemplate.method_15172((class_5425)serverLevel, blockPos.method_10081((class_2382)negativeHalfLengths), blockPos.method_10081((class_2382)negativeHalfLengths), EssenceBlock.PLACEMENT_SETTINGS.getOrFillFromInternal(), serverLevel.method_8409(), 18);
            for (UUID playerUUID : essenceBlockEntity.getPlayerInArena()) {
                class_2248 patt1$temp;
                class_3222 serverPlayer = (class_3222)serverLevel.method_18470(playerUUID);
                if (serverPlayer == null) continue;
                class_2248 patt0$temp = essenceBlockEntity.method_11010().method_26204();
                if (patt0$temp instanceof EssenceBlock) {
                    EssenceBlock essenceBlock = (EssenceBlock)patt0$temp;
                    essenceBlock.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
                }
                if (blockPos.method_10263() + size.method_10263() <= serverPlayer.method_24515().method_10263() || blockPos.method_10264() + size.method_10264() <= serverPlayer.method_24515().method_10264() || blockPos.method_10260() + size.method_10260() <= serverPlayer.method_24515().method_10260() || blockPos.method_10263() - size.method_10263() >= serverPlayer.method_24515().method_10263() || blockPos.method_10264() - size.method_10264() >= serverPlayer.method_24515().method_10264() || blockPos.method_10260() - size.method_10260() >= serverPlayer.method_24515().method_10260()) continue;
                class_2350 direction = class_2350.class_2353.field_11062.method_10183(serverLevel.method_8409());
                serverPlayer.method_18800(0.0, 0.0, 0.0);
                serverPlayer.method_5859((double)((float)blockPos.method_10263() + (float)direction.method_10148() * ((float)(negativeHalfLengths.method_10263() + 1) / -2.0f) + 0.5f), (double)(blockPos.method_10264() + negativeHalfLengths.method_10264() + 2), (double)((float)blockPos.method_10260() + (float)direction.method_10165() * ((float)(negativeHalfLengths.method_10260() + 1) / -2.0f) + 0.5f));
                serverPlayer.method_5702(class_2183.class_2184.field_9851, class_243.method_24953((class_2382)blockPos));
                EssenceBlock.spawnParticles(serverLevel, serverPlayer.method_19538(), serverPlayer.method_59922());
                if (!won || !((patt1$temp = blockState.method_26204()) instanceof EssenceBlock)) continue;
                EssenceBlock essenceBlock = (EssenceBlock)patt1$temp;
                class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)essenceBlock.getEssenceItemReward()));
                if (lootTable != null) {
                    class_8567.class_8568 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockPos)).method_51874(class_181.field_1226, (Object)serverPlayer);
                    ObjectArrayList newItems = new ObjectArrayList();
                    lootTable.method_51882(lootParams.method_51875(class_173.field_1174), arg_0 -> ((ObjectArrayList)newItems).add(arg_0));
                    for (class_1799 reward : newItems) {
                        ((ItemSpecificTrigger)((Object)((Object)BzCriterias.ESSENCE_EVENT_REWARD_TRIGGER.get()))).trigger(serverPlayer, reward);
                        if (serverPlayer.method_7270(reward)) continue;
                        serverPlayer.method_7328(reward, false);
                    }
                }
                int xpReward = essenceBlock.getEssenceXpReward();
                if (essenceBlockEntity.isBeaten()) {
                    xpReward = (int)((double)xpReward * 0.1);
                }
                serverPlayer.method_7255(xpReward);
                essenceBlock.awardPlayerWinStat(serverPlayer);
            }
            List entities = serverLevel.method_8335(null, new class_238((double)(blockPos.method_10263() + size.method_10263()), (double)(blockPos.method_10264() + size.method_10264()), (double)(blockPos.method_10260() + size.method_10260()), (double)(blockPos.method_10263() - size.method_10263()), (double)(blockPos.method_10264() - size.method_10264()), (double)(blockPos.method_10260() - size.method_10260())));
            for (class_1297 entity : entities) {
                class_1308 mob;
                class_5354 neutralMob;
                if ((!(entity instanceof class_5354) || !((neutralMob = (class_5354)entity).method_5968() instanceof class_1657)) && (!(entity instanceof class_1308) || !((mob = (class_1308)entity).method_5968() instanceof class_1657))) continue;
                entity.method_5650(class_1297.class_5529.field_26999);
            }
            for (EventEntities eventEntities : essenceBlockEntity.getEventEntitiesInArena()) {
                class_1297 entity = serverLevel.method_14190(eventEntities.uuid());
                if (entity == null) continue;
                entity.method_5650(class_1297.class_5529.field_26999);
            }
            if (!essenceBlockEntity.getPlayerInArena().isEmpty() && won && !BzGeneralConfigs.repeatableEssenceEvents) {
                serverLevel.method_8652(blockPos, ((class_2248)BzBlocks.HEAVY_AIR.get()).method_9564(), 3);
            }
        }, () -> Bumblezone.LOGGER.error("Bumblezone Essence Block failed to restore area from saved NBT - {} - {} - Location: {}", new Object[]{essenceBlockEntity, blockState, essenceBlockEntity.getSavedNbtLocationAsString()}));
        essenceBlockEntity.getEventBar().method_14094();
        essenceBlockEntity.getPlayerInArena().clear();
        essenceBlockEntity.getEventEntitiesInArena().clear();
        essenceBlockEntity.setExtraEventTrackingProgress(0);
        essenceBlockEntity.setEventTimer(0);
        essenceBlockEntity.setArenaSize(class_2338.field_10980);
        essenceBlockEntity.method_5431();
    }

    public void method_11012() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (UUID playerUUID : this.getPlayerInArena()) {
                class_2248 class_22482;
                class_3222 serverPlayer = (class_3222)serverLevel.method_18470(playerUUID);
                if (serverPlayer == null || !((class_22482 = this.method_11010().method_26204()) instanceof EssenceBlock)) continue;
                EssenceBlock essenceBlock = (EssenceBlock)class_22482;
                essenceBlock.onPlayerLeave(serverLevel, serverPlayer, this);
            }
        }
        this.getEventBar().method_14094();
        super.method_11012();
    }

    public static EssenceBlockEntity getEssenceBlockAtLocation(class_1937 level, class_5321<class_1937> targetLevel, class_2338 targetBlockPos, UUID targetEssenceUUID) {
        EssenceBlockEntity essenceBlockEntity;
        class_2586 blockEntity;
        if (targetEssenceUUID != null && level != null && targetBlockPos != null && level.method_27983().equals(targetLevel) && (blockEntity = level.method_8321(targetBlockPos)) instanceof EssenceBlockEntity && (essenceBlockEntity = (EssenceBlockEntity)blockEntity).getEventTimer() > 0 && essenceBlockEntity.getUUID().equals(targetEssenceUUID)) {
            return essenceBlockEntity;
        }
        return null;
    }

    public record EventEntities(UUID uuid) {
    }
}

