/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.items.recipes.PotionCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakePotionCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.emi.EMIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.emi.EMIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.emi.QueenRandomizerTradesEMICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.emi.QueenTradesEMICategory;
import com.telepathicgrunt.the_bumblezone.modinit.BzCreativeTabs;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3955;
import net.minecraft.class_5455;
import net.minecraft.class_6012;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

@EmiEntrypoint
public class EMICompat
implements EmiPlugin {
    public static final EmiStack WORKSTATION = EmiStack.of((class_1935)((class_1935)BzItems.BEE_QUEEN_SPAWN_EGG.get()));
    public static final EmiRecipeCategory QUEEN_TRADES = new QueenTradesEMICategory();
    public static final EmiRecipeCategory QUEEN_RANDOMIZE_TRADES = new QueenRandomizerTradesEMICategory();

    public void register(EmiRegistry registry) {
        BzCreativeTabs.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> EMICompat.addInfo(registry, (class_1792)item.get()));
        EMICompat.addInfo(registry, (class_3611)BzFluids.SUGAR_WATER_FLUID.get());
        EMICompat.addInfo(registry, (class_3611)BzFluids.ROYAL_JELLY_FLUID.get());
        if (BzModCompatibilityConfigs.alternativeFluidToReplaceHoneyFluid.isEmpty()) {
            EMICompat.addInfo(registry, (class_3611)BzFluids.HONEY_FLUID.get());
        }
        registry.getRecipeManager().method_8130(class_2960.method_60655((String)"the_bumblezone", (String)"potion_candle/from_super_candles")).ifPresent(recipe -> EMICompat.registerExtraRecipes(recipe, registry, true));
        registry.getRecipeManager().method_8130(class_2960.method_60655((String)"the_bumblezone", (String)"potion_candle/from_string_and_carvable_wax")).ifPresent(recipe -> EMICompat.registerExtraRecipes(recipe, registry, false));
        registry.addCategory(QUEEN_TRADES);
        registry.addCategory(QUEEN_RANDOMIZE_TRADES);
        registry.addWorkstation(QUEEN_TRADES, (EmiIngredient)WORKSTATION);
        registry.addWorkstation(QUEEN_RANDOMIZE_TRADES, (EmiIngredient)WORKSTATION);
        long recipeId = 1L;
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades.isEmpty()) {
            for (Pair<MainTradeRowInput, class_6012<WeightedTradeResult>> trade : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades) {
                for (WeightedTradeResult weightedTradeResult : ((class_6012)trade.getSecond()).method_34994()) {
                    List<EmiStack> rewardCollection = weightedTradeResult.getItems().stream().map(EmiStack::of).toList();
                    registry.addRecipe((EmiRecipe)new EMIQueenTradesInfo(EmiIngredient.of((class_1856)(((MainTradeRowInput)trade.getFirst()).tagKey().isPresent() ? class_1856.method_8106(((MainTradeRowInput)trade.getFirst()).tagKey().get()) : class_1856.method_8091((class_1935[])new class_1935[]{((MainTradeRowInput)trade.getFirst()).item()}))), (class_6862<class_1792>)((class_6862)((MainTradeRowInput)trade.getFirst()).tagKey().orElse(null)), rewardCollection, (class_6862<class_1792>)((class_6862)weightedTradeResult.tagKey.orElse(null)), weightedTradeResult.xpReward, weightedTradeResult.weight, weightedTradeResult.getTotalWeight(), class_2960.method_60655((String)"the_bumblezone", (String)("" + recipeId))));
                    ++recipeId;
                }
            }
        }
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades.isEmpty()) {
            Object2ObjectOpenHashMap cacheEmiData = new Object2ObjectOpenHashMap();
            for (RandomizeTradeRowInput tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades) {
                class_6862<class_1792> itemTagKey = tradeEntry.tagKey().get();
                TagData tagData = cacheEmiData.getOrDefault(itemTagKey, null);
                if (tagData == null) {
                    List<class_1799> randomizeStack = tradeEntry.getWantItems().method_40239().map(e -> ((class_1792)e.comp_349()).method_7854()).toList();
                    List<EmiStack> emiStackList = randomizeStack.stream().map(EmiStack::of).collect(Collectors.toList());
                    EmiIngredient emiIngredient = EmiIngredient.of(itemTagKey);
                    tagData = new TagData(randomizeStack.size(), emiStackList, emiIngredient);
                    cacheEmiData.put(itemTagKey, tagData);
                }
                registry.addRecipe((EmiRecipe)new EMIQueenRandomizerTradesInfo(EmiIngredient.of((class_1856)class_1856.method_8106(itemTagKey)), true, tagData.emiStack(), itemTagKey, tagData.emiIngredient(), 1, tagData.listSize(), class_2960.method_60655((String)"the_bumblezone", (String)("" + recipeId))));
                ++recipeId;
            }
        }
        List<class_1799> hangingGardensFlowers = GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_FLOWERS_BLOCKS);
        hangingGardensFlowers.addAll(GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_TALL_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_TALL_FLOWERS_BLOCKS));
        EMICompat.addComplexBlockTagInfo(registry, Pair.of((Object)".hanging_gardens_flowers.description", hangingGardensFlowers), Pair.of((Object)".crystalline_flower_can_be_placed_on.description", GeneralUtils.convertBlockTagsToItemStacks(BzTags.CRYSTALLINE_FLOWER_CAN_SURVIVE_ON, null)));
    }

    @SafeVarargs
    private static void addComplexBlockTagInfo(@NotNull EmiRegistry registry, Pair<String, List<class_1799>> ... structureInfo) {
        for (Pair<String, List<class_1799>> predicatePair : structureInfo) {
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiIngredient.of((class_1856)class_1856.method_26964(((List)predicatePair.getSecond()).stream()))), List.of(class_2561.method_43471((String)("the_bumblezone" + (String)predicatePair.getFirst()))), class_2960.method_60655((String)"the_bumblezone", (String)((String)predicatePair.getFirst()))));
        }
    }

    private static void registerExtraRecipes(class_8786<?> baseRecipe, EmiRegistry registry, boolean oneRecipeOnly) {
        class_1860 class_18602 = baseRecipe.comp_1933();
        if (class_18602 instanceof PotionCandleRecipe) {
            PotionCandleRecipe potionCandleRecipe = (PotionCandleRecipe)class_18602;
            List<class_3955> extraRecipes = FakePotionCandleRecipeCreator.constructFakeRecipes(potionCandleRecipe, oneRecipeOnly);
            for (int i = 0; i < extraRecipes.size(); ++i) {
                class_3955 craftingRecipe = extraRecipes.get(i);
                registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(craftingRecipe.method_8117().stream().map(EmiIngredient::of).toList(), EmiStack.of((class_1799)craftingRecipe.method_8110((class_7225.class_7874)class_5455.field_40585)), class_2960.method_60655((String)baseRecipe.comp_1932().method_12836(), (String)(baseRecipe.comp_1932().method_12832() + "_" + i)), false));
            }
        }
    }

    private static void addInfo(EmiRegistry registry, class_1792 item) {
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiIngredient.of((class_1856)class_1856.method_8101((class_1799[])new class_1799[]{new class_1799((class_1935)item)}))), List.of(class_2561.method_43471((String)("the_bumblezone." + class_7923.field_41178.method_10221((Object)item).method_12832() + ".description"))), class_2960.method_60655((String)"the_bumblezone", (String)(class_7923.field_41178.method_10221((Object)item).method_12832() + "_info"))));
    }

    private static void addInfo(EmiRegistry registry, class_3611 fluid) {
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((class_3611)fluid)), List.of(class_2561.method_43471((String)("the_bumblezone." + class_7923.field_41173.method_10221((Object)fluid).method_12832() + ".description"))), class_2960.method_60655((String)"the_bumblezone", (String)(class_7923.field_41173.method_10221((Object)fluid).method_12832() + "_info"))));
    }

    record TagData(int listSize, List<EmiStack> emiStack, EmiIngredient emiIngredient) {
    }
}

