/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.fabric;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public record GlisteringHoneyCrystalBakedModel(class_1087 wrapped, class_1087 insideModel, class_1087 outsideModel) implements class_1087,
FabricBakedModel
{
    private static final MaterialFinder materialFinder = Optional.ofNullable(RendererAccess.INSTANCE.getRenderer()).map(Renderer::materialFinder).orElse(null);

    public boolean isVanillaAdapter() {
        return materialFinder == null;
    }

    private void emitBlockModelQuads(RenderContext context, class_2680 state, Supplier<class_5819> randomSupplier, class_1087 model, RenderMaterial renderMaterial) {
        QuadEmitter emitter = context.getEmitter();
        for (int i = 0; i <= 6; ++i) {
            @Nullable class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
            if (!context.hasTransform() && context.isFaceCulled(cullFace)) continue;
            for (class_777 q : model.method_4707(state, cullFace, randomSupplier.get())) {
                emitter.fromVanilla(q, renderMaterial, cullFace);
                emitter.emit();
            }
        }
    }

    private void emitItemModelQuads(RenderContext context, @Nullable class_2680 state, Supplier<class_5819> randomSupplier, class_1087 model, RenderMaterial renderMaterial) {
        QuadEmitter emitter = context.getEmitter();
        for (int i = 0; i <= 6; ++i) {
            @Nullable class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
            for (class_777 q : model.method_4707(state, cullFace, randomSupplier.get())) {
                emitter.fromVanilla(q, renderMaterial, cullFace);
                emitter.emit();
            }
        }
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.emitBlockModelQuads(context, state, randomSupplier, this.insideModel, materialFinder.blendMode(BlendMode.CUTOUT).find());
        this.emitBlockModelQuads(context, state, randomSupplier, this.outsideModel, materialFinder.blendMode(BlendMode.TRANSLUCENT).find());
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.emitItemModelQuads(context, null, randomSupplier, this.insideModel, materialFinder.blendMode(BlendMode.CUTOUT).find());
        this.emitItemModelQuads(context, null, randomSupplier, this.outsideModel, materialFinder.blendMode(BlendMode.TRANSLUCENT).find());
    }

    public List<class_777> method_4707(@Nullable class_2680 blockState, @Nullable class_2350 direction, class_5819 randomSource) {
        return this.outsideModel.method_4707(blockState, direction, randomSource);
    }

    public boolean method_4708() {
        return this.wrapped().method_4708();
    }

    public boolean method_4712() {
        return this.wrapped().method_4712();
    }

    public boolean method_24304() {
        return this.wrapped().method_24304();
    }

    public boolean method_4713() {
        return this.wrapped().method_4713();
    }

    public class_1058 method_4711() {
        return this.wrapped().method_4711();
    }

    public class_809 method_4709() {
        return this.wrapped().method_4709();
    }

    public class_806 method_4710() {
        return this.wrapped().method_4710();
    }

    static {
        if (materialFinder == null) {
            Bumblezone.LOGGER.error("No FRAPI Renderer found! GlisteringHoneyCrystalBakedModel will not work correctly!");
            if (FabricLoader.getInstance().isModLoaded("sodium") && !FabricLoader.getInstance().isModLoaded("indium")) {
                Bumblezone.LOGGER.error("Found Sodium but not Indium! please try installing Indium before reporting this as a bug!");
            }
        }
    }
}

