/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal;

import com.telepathicgrunt.the_bumblezone.client.BumblezoneClient;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalShieldRenderer;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashSet;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_922;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CosmicCrystalRenderer
extends class_922<CosmicCrystalEntity, CosmicCrystalModel> {
    private static final class_2960 SKIN = new class_2960("the_bumblezone", "textures/entity/cosmic_crystal.png");
    private static final class_2960 LASER_LOCATION = new class_2960("the_bumblezone", "textures/entity/cosmic_crystal_laser.png");

    public CosmicCrystalRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new CosmicCrystalModel(context.method_32167(CosmicCrystalModel.LAYER_LOCATION)), 0.7f);
        this.method_4046(new CosmicCrystalShieldRenderer((class_3883<CosmicCrystalEntity, CosmicCrystalModel>)this, context.method_32170()));
    }

    public void render(CosmicCrystalEntity cosmicCrystalEntity, float entityYaw, float partialTicks, class_4587 stack, class_4597 buffer, int packedLight) {
        this.renderLiving(cosmicCrystalEntity, entityYaw, partialTicks, stack, buffer, 0xF000F0);
        this.renderLaser(cosmicCrystalEntity, entityYaw, partialTicks, stack, buffer, 0xF000F0);
    }

    public void renderLiving(CosmicCrystalEntity cosmicCrystalEntity, float f, float partialTick, class_4587 poseStack, class_4597 multiBufferSource, int packedLight) {
        poseStack.method_22903();
        ((CosmicCrystalModel)this.field_4737).field_3447 = this.method_4044(cosmicCrystalEntity, partialTick);
        ((CosmicCrystalModel)this.field_4737).field_3449 = cosmicCrystalEntity.method_5765();
        ((CosmicCrystalModel)this.field_4737).field_3448 = cosmicCrystalEntity.method_6109();
        float lerpedXRot = class_3532.method_17821((float)partialTick, (float)cosmicCrystalEntity.field_6004, (float)cosmicCrystalEntity.method_36455());
        float lerpedYRot = class_3532.method_17821((float)partialTick, (float)cosmicCrystalEntity.field_5982, (float)cosmicCrystalEntity.method_36454());
        float rotAxisDiff = lerpedYRot - lerpedXRot;
        float xRot = class_3532.method_16439((float)partialTick, (float)cosmicCrystalEntity.field_6004, (float)cosmicCrystalEntity.method_36455());
        this.setupRotations(cosmicCrystalEntity, poseStack, lerpedXRot, lerpedYRot, partialTick);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        this.method_4042(cosmicCrystalEntity, poseStack, partialTick);
        poseStack.method_46416(0.0f, -1.501f, 0.0f);
        float n = 0.0f;
        float o = 0.0f;
        if (!cosmicCrystalEntity.method_5765() && cosmicCrystalEntity.method_5805()) {
            n = cosmicCrystalEntity.field_42108.method_48570(partialTick);
            o = cosmicCrystalEntity.field_42108.method_48572(partialTick);
            if (n > 1.0f) {
                n = 1.0f;
            }
        }
        float tickTimeWithPartial = this.method_4045(cosmicCrystalEntity, partialTick);
        ((CosmicCrystalModel)this.field_4737).method_2816((class_1297)cosmicCrystalEntity, o, n, partialTick);
        ((CosmicCrystalModel)this.field_4737).setupAnim(cosmicCrystalEntity, o, n, tickTimeWithPartial, rotAxisDiff, xRot);
        class_310 minecraft = class_310.method_1551();
        boolean bl = this.method_4056(cosmicCrystalEntity);
        boolean bl2 = !bl && !cosmicCrystalEntity.method_5756((class_1657)minecraft.field_1724);
        boolean bl3 = minecraft.method_27022((class_1297)cosmicCrystalEntity);
        class_1921 renderType = this.method_24302(cosmicCrystalEntity, bl, bl2, bl3);
        if (renderType != null) {
            float currentHealthState;
            class_4588 vertexConsumer = multiBufferSource.getBuffer(renderType);
            int overlayCoords = class_922.method_23622((class_1309)cosmicCrystalEntity, (float)this.method_23185(cosmicCrystalEntity, partialTick));
            float red = currentHealthState = Math.min(1.0f, Math.min(1.0f, cosmicCrystalEntity.method_6032() / cosmicCrystalEntity.method_6063()) * 0.45f + 0.6f);
            float green = currentHealthState;
            float blue = currentHealthState;
            if (cosmicCrystalEntity.method_32312() > 0) {
                red *= 0.75f;
                green *= 0.75f;
            }
            if (cosmicCrystalEntity.method_5809()) {
                green *= 0.75f;
                blue *= 0.75f;
            }
            for (class_1291 mobEffect : new HashSet(cosmicCrystalEntity.method_6088().keySet())) {
                String namespace;
                if (mobEffect == class_1294.field_5899) {
                    red *= 0.75f;
                    blue *= 0.75f;
                    continue;
                }
                if (mobEffect == class_1294.field_5920) {
                    red *= 0.5f;
                    green *= 0.5f;
                    blue *= 0.5f;
                    continue;
                }
                if (mobEffect.method_5561() || mobEffect.method_5573() || (namespace = class_7923.field_41174.method_10221((Object)mobEffect).method_12836()).equals("minecraft") || namespace.equals("the_bumblezone")) continue;
                red = (red + (float)GeneralUtils.getRed(mobEffect.method_5556()) / 255.0f) / 2.0f;
                green = (green + (float)GeneralUtils.getGreen(mobEffect.method_5556()) / 255.0f) / 2.0f;
                blue = (blue + (float)GeneralUtils.getBlue(mobEffect.method_5556()) / 255.0f) / 2.0f;
            }
            this.field_4737.method_2828(poseStack, vertexConsumer, packedLight, overlayCoords, red, green, blue, bl2 ? 0.15f : 1.0f);
        }
        if (!cosmicCrystalEntity.method_7325()) {
            for (class_3887 renderLayer : this.field_4738) {
                renderLayer.method_4199(poseStack, multiBufferSource, packedLight, (class_1297)cosmicCrystalEntity, o, n, partialTick, tickTimeWithPartial, rotAxisDiff, xRot);
            }
        }
        poseStack.method_22909();
    }

    protected void renderHealth(class_1297 entity, class_2561 component, class_4587 poseStack, class_4597 multiBufferSource, int packedLight) {
        if (this.field_4676.method_23168(entity) > 100.0) {
            return;
        }
        float f = entity.method_51152() + 0.5f;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, f, 0.0f);
        poseStack.method_22907(this.field_4676.method_24197());
        poseStack.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        float g = class_310.method_1551().field_1690.method_19343(0.25f);
        int k = (int)(g * 255.0f) << 24;
        class_327 font = this.method_3932();
        float h = (float)(-font.method_27525((class_5348)component)) / 2.0f;
        font.method_30882(component, h, 0.0f, 0x20FFFFFF, false, matrix4f, multiBufferSource, class_327.class_6415.field_33993, k, packedLight);
        font.method_30882(component, h, 0.0f, -1, false, matrix4f, multiBufferSource, class_327.class_6415.field_33993, 0, packedLight);
        poseStack.method_22909();
    }

    protected void setupRotations(CosmicCrystalEntity cosmicCrystalEntity, class_4587 poseStack, float lerpedXRot, float lerpedYRot, float partialTick) {
        if (this.method_25450(cosmicCrystalEntity)) {
            lerpedXRot += (float)(Math.cos((double)cosmicCrystalEntity.field_6012 * 3.25) * Math.PI * (double)0.4f);
        }
        poseStack.method_46416(0.0f, 1.0f, 0.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - lerpedYRot));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f - lerpedXRot));
        poseStack.method_46416(0.0f, -1.0f, 0.0f);
    }

    public void renderLaser(CosmicCrystalEntity cosmicCrystalEntity, float f, float partialTick, class_4587 poseStack, class_4597 multiBufferSource, int packedLight) {
        if (cosmicCrystalEntity.isLaserFiring()) {
            float totalTickTime = (float)cosmicCrystalEntity.field_6012 + partialTick;
            float colorSpeed = -5.0f;
            long uniqueValue = cosmicCrystalEntity.method_5667().getLeastSignificantBits() % 1000000L;
            float radianColor = (totalTickTime * colorSpeed + (float)uniqueValue) % 360.0f * ((float)Math.PI / 180);
            int baseBrightness = 200;
            int colorStrength = 55;
            float redSin = class_3532.method_15374((float)radianColor);
            float greenSin = class_3532.method_15374((float)(radianColor + 30.0f));
            float blueSin = class_3532.method_15374((float)(radianColor + 60.0f));
            int red = baseBrightness + (int)(redSin * (float)colorStrength);
            int green = baseBrightness + (int)(greenSin * (float)colorStrength);
            int blue = baseBrightness + (int)(blueSin * (float)colorStrength);
            float redSin2 = class_3532.method_15362((float)radianColor);
            float greenSin2 = class_3532.method_15362((float)(radianColor + 30.0f));
            float blueSin2 = class_3532.method_15362((float)(radianColor + 60.0f));
            int red2 = baseBrightness + (int)(redSin2 * (float)colorStrength);
            int green2 = baseBrightness + (int)(greenSin2 * (float)colorStrength);
            int blue2 = baseBrightness + (int)(blueSin2 * (float)colorStrength);
            float eyeY = cosmicCrystalEntity.method_5751();
            poseStack.method_22903();
            class_243 startPos = cosmicCrystalEntity.method_33571();
            class_243 prevLookAngle = cosmicCrystalEntity.prevLookAngle;
            class_243 lookAngle = cosmicCrystalEntity.method_5720();
            class_243 lerpedLook = new class_243(class_3532.method_16436((double)partialTick, (double)prevLookAngle.method_10216(), (double)lookAngle.method_10216()), class_3532.method_16436((double)partialTick, (double)prevLookAngle.method_10214(), (double)lookAngle.method_10214()), class_3532.method_16436((double)partialTick, (double)prevLookAngle.method_10215(), (double)lookAngle.method_10215()));
            class_243 endPos = lerpedLook.method_1021(50.0).method_1019(startPos);
            class_3965 hitResult = cosmicCrystalEntity.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)cosmicCrystalEntity));
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                endPos = hitResult.method_17784().method_1020(lookAngle);
            }
            class_243 vectToTarget = endPos.method_1020(startPos);
            float laserLength = (float)vectToTarget.method_1033() - 0.01f;
            vectToTarget = vectToTarget.method_1029();
            float n = (float)Math.acos(vectToTarget.field_1351);
            float o = (float)Math.atan2(vectToTarget.field_1350, vectToTarget.field_1352);
            poseStack.method_22904(lookAngle.method_10216(), (double)eyeY + lookAngle.method_10214(), lookAngle.method_10215());
            poseStack.method_22907(class_7833.field_40716.rotationDegrees((1.5707964f - o) * 57.295776f));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(n * 57.295776f));
            float q = totalTickTime * 0.05f * -1.5f;
            float v = 0.2f;
            float w2 = 0.5f;
            float z5 = class_3532.method_15374((float)(q + 2.3561945f)) * w2;
            float x7 = class_3532.method_15362((float)(q + 2.3561945f)) * w2;
            float z9 = class_3532.method_15362((float)(q + 0.7853982f)) * w2;
            float z6 = class_3532.method_15374((float)(q + 0.7853982f)) * w2;
            float x6 = class_3532.method_15362((float)(q + 3.926991f)) * w2;
            float z8 = class_3532.method_15374((float)(q + 3.926991f)) * w2;
            float x5 = class_3532.method_15362((float)(q + 5.4977875f)) * w2;
            float z7 = class_3532.method_15374((float)(q + 5.4977875f)) * w2;
            float x1 = class_3532.method_15362((float)(q + (float)Math.PI)) * v;
            float z1 = class_3532.method_15374((float)(q + (float)Math.PI)) * v;
            float x2 = class_3532.method_15362((float)(q + 0.0f)) * v;
            float z2 = class_3532.method_15374((float)(q + 0.0f)) * v;
            float x3 = class_3532.method_15362((float)(q + 1.5707964f)) * v;
            float z3 = class_3532.method_15374((float)(q + 1.5707964f)) * v;
            float x4 = class_3532.method_15362((float)(q + 4.712389f)) * v;
            float z4 = class_3532.method_15374((float)(q + 4.712389f)) * v;
            float y1 = laserLength;
            float y2 = 0.0f;
            float ux1 = 0.4999f;
            float ux2 = 0.0f;
            float uv2 = -1.0f + totalTickTime * -0.2f % 1.0f;
            float uv1 = laserLength * 2.5f + uv2;
            class_4588 vertexConsumer = multiBufferSource.getBuffer(BumblezoneClient.ENTITY_CUTOUT_EMISSIVE_RENDER_TYPE.apply(LASER_LOCATION));
            class_4587.class_4665 pose = poseStack.method_23760();
            Matrix4f matrix4f = pose.method_23761();
            Matrix3f matrix3f = pose.method_23762();
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x1, y1, z1, red2, green2, blue2, ux1, uv1);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x1, y2, z1, red, green, blue, ux1, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x2, y2, z2, red, green, blue, ux2, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x2, y1, z2, red2, green2, blue2, ux2, uv1);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x3, y1, z3, red2, green2, blue2, ux1, uv1);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x3, y2, z3, red, green, blue, ux1, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x4, y2, z4, red, green, blue, ux2, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x4, y1, z4, red2, green2, blue2, ux2, uv1);
            float as = 0.0f;
            if (cosmicCrystalEntity.field_6012 % 4 < 2) {
                as = 0.5f;
            }
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x7, y1, z5, red2, green2, blue2, 0.5f, as + 0.5f);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, z9, y1, z6, red2, green2, blue2, 1.0f, as + 0.5f);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x5, y1, z7, red2, green2, blue2, 1.0f, as);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x6, y1, z8, red2, green2, blue2, 0.5f, as);
            poseStack.method_22909();
            CosmicCrystalRenderer.laserScreenShake(cosmicCrystalEntity, endPos);
        }
    }

    private static void laserScreenShake(CosmicCrystalEntity cosmicCrystalEntity, class_243 endPos) {
        double threshold;
        double distance2;
        double distance1;
        double minDistance;
        class_1297 camera = class_310.method_1551().method_1560();
        if (camera != null && (minDistance = Math.min(distance1 = cosmicCrystalEntity.method_19538().method_1022(camera.method_19538()), distance2 = endPos.method_1022(camera.method_19538()))) <= (threshold = 10.0)) {
            double percentageToCenter = 1.0 - minDistance / threshold;
            double spinSlowdown = 0.15 + 0.3 * (1.0 - percentageToCenter * percentageToCenter);
            float intensity = (float)(0.175 * percentageToCenter * percentageToCenter * percentageToCenter);
            double currentMillisecond = (double)System.currentTimeMillis() % (360.0 * spinSlowdown);
            double degrees = currentMillisecond / spinSlowdown;
            float angle = (float)(degrees * 0.01745329238474369);
            camera.method_36456(camera.method_36454() + class_3532.method_15374((float)angle) * intensity);
        }
    }

    private static void vertex(class_4588 vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float x, float y, float z, int red, int green, int blue, float ux, float uz) {
        vertexConsumer.method_22918(matrix4f, x, y, z).method_1336(red, green, blue, 255).method_22913(ux, uz).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrix3f, 0.0f, 1.0f, 0.0f).method_1344();
    }

    public class_2960 getTextureLocation(CosmicCrystalEntity cosmicCrystalEntity) {
        return SKIN;
    }

    protected boolean shouldShowName(CosmicCrystalEntity entity) {
        return false;
    }
}

