/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ThrownStingerSpearEntity;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.mixin.entities.MobAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ThrownTridentAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.LivingEntityDataModule;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.platform.BzEnchantment;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_3222;
import net.minecraft.class_8103;

public class NeurotoxinsEnchantment
extends BzEnchantment {
    public NeurotoxinsEnchantment() {
        super(class_1887.class_1888.field_9088, class_1886.field_9073, new class_1304[]{class_1304.field_6173});
    }

    public int method_8182(int level) {
        if (level > BzGeneralConfigs.neurotoxinMaxLevel) {
            return 201;
        }
        return 14 * level;
    }

    public int method_20742(int level) {
        if (level > BzGeneralConfigs.neurotoxinMaxLevel) {
            return 200;
        }
        return super.method_8182(level) + 50;
    }

    public int method_8183() {
        return BzGeneralConfigs.neurotoxinMaxLevel;
    }

    public static void entityHurtEvent(EntityAttackedEvent event) {
        if (event.entity().method_37908().method_8608()) {
            return;
        }
        class_1799 attackingItem = null;
        class_1309 attacker = null;
        class_1297 class_12972 = event.source().method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity;
            attacker = livingEntity = (class_1309)class_12972;
            attackingItem = attacker.method_6047();
        }
        if (event.source().method_48789(class_8103.field_42247)) {
            class_1297 projectile = event.source().method_5526();
            if (projectile instanceof class_1685) {
                class_1685 thrownTrident = (class_1685)projectile;
                attackingItem = ((ThrownTridentAccessor)thrownTrident).bumblezone$getTridentItem();
            } else if (projectile instanceof ThrownStingerSpearEntity) {
                ThrownStingerSpearEntity thrownStingerSpearEntity = (ThrownStingerSpearEntity)projectile;
                attackingItem = thrownStingerSpearEntity.getSpearItemStack();
            }
        }
        if (attackingItem != null && !attackingItem.method_7960()) {
            NeurotoxinsEnchantment.applyNeurotoxins((class_1297)attacker, (class_1297)event.entity(), attackingItem);
        }
    }

    public static void applyNeurotoxins(class_1297 attacker, class_1297 victim, class_1799 itemStack) {
        class_1309 livingEntity;
        int level = class_1890.method_8225((class_1887)BzEnchantments.NEUROTOXINS.get(), (class_1799)itemStack);
        if ((level = Math.min(level, BzGeneralConfigs.neurotoxinMaxLevel)) > 0 && victim instanceof class_1309 && (livingEntity = (class_1309)victim).method_6046() != class_1310.field_6289) {
            Optional<LivingEntityDataModule> capOptional;
            if (livingEntity.method_6059(BzEffects.PARALYZED.get())) {
                return;
            }
            float applyChance = 1.0f;
            LivingEntityDataModule capability = null;
            if (attacker != null && (capOptional = ModuleHelper.getModule(attacker, ModuleRegistry.LIVING_ENTITY_DATA)).isPresent()) {
                capability = capOptional.orElseThrow(RuntimeException::new);
                float healthModifier = Math.max(100.0f - livingEntity.method_6032(), 10.0f) / 100.0f;
                applyChance = healthModifier * (float)level * (float)(capability.getMissedParalysis() + 1);
            }
            if (livingEntity.method_6051().method_43057() < applyChance) {
                livingEntity.method_6092(new class_1293(BzEffects.PARALYZED.get(), Math.min(100 * level, BzGeneralConfigs.paralyzedMaxTickDuration), level, false, true, true));
                if (attacker instanceof class_1309) {
                    class_1309 livingAttacker = (class_1309)attacker;
                    if (livingEntity instanceof class_1308) {
                        class_1308 mob = (class_1308)livingEntity;
                        mob.method_6015(livingAttacker);
                        ((MobAccessor)mob).bumblezone$getTargetSelector().method_6275();
                    }
                }
                if (itemStack.method_31574(BzItems.STINGER_SPEAR.get()) && attacker instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)attacker;
                    BzCriterias.STINGER_SPEAR_PARALYZING_TRIGGER.trigger(serverPlayer);
                    if (livingEntity.method_6032() > 70.0f) {
                        BzCriterias.STINGER_SPEAR_PARALYZE_BOSS_TRIGGER.trigger(serverPlayer);
                    }
                }
                if (capability != null) {
                    capability.setMissedParalysis(0);
                }
            } else if (capability != null) {
                capability.setMissedParalysis(capability.getMissedParalysis() + 1);
            }
        }
    }

    public boolean method_8192(class_1799 stack) {
        return stack.method_31573(BzTags.ENCHANTABLE_NEUROTOXINS) || stack.method_31574(class_1802.field_8529);
    }

    @Override
    public OptionalBoolean bz$canApplyAtEnchantingTable(class_1799 stack) {
        return OptionalBoolean.of(this.method_8192(stack));
    }
}

