/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.queentrades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.TagsUpdatedEvent;
import com.telepathicgrunt.the_bumblezone.mixin.util.WeightedRandomListAccessor;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6008;
import net.minecraft.class_6012;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class QueensTradeManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    public static final QueensTradeManager QUEENS_TRADE_MANAGER = new QueensTradeManager();
    private final List<TradeCollection> rawTrades = new ArrayList<TradeCollection>();
    public Object2ObjectOpenHashMap<class_1792, class_6012<WeightedTradeResult>> queenTrades = new Object2ObjectOpenHashMap();
    public Object2ObjectOpenHashMap<class_1792, Object2ObjectOpenHashMap<SpecialDaysEntry, class_6012<WeightedTradeResult>>> specialDayQueenTrades = new Object2ObjectOpenHashMap();
    public List<RandomizeTradeRowInput> recipeViewerRandomizerTrades = new ArrayList<RandomizeTradeRowInput>();
    public List<Pair<MainTradeRowInput, class_6012<WeightedTradeResult>>> recipeViewerMainTrades = new ArrayList<Pair<MainTradeRowInput, class_6012<WeightedTradeResult>>>();

    public QueensTradeManager() {
        super(GSON, "bz_bee_queen_trades");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        this.rawTrades.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                DataResult mapDataResult = TradeCollection.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement);
                mapDataResult.resultOrPartial(s -> {}).ifPresent(result -> {
                    this.validateResult((TradeCollection)result);
                    this.rawTrades.add((TradeCollection)result);
                });
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse bee queen trades file {}", fileIdentifier, (Object)e);
            }
        });
    }

    private void validateResult(TradeCollection result) throws IllegalArgumentException {
        if (result.resultItems().isEmpty() && !result.randomizerTrade()) {
            throw new IllegalArgumentException("Cannot have empty resultItems list if randomizerTrade is false. If resultItems field is present in file, check for typos or mistakes in file.");
        }
    }

    public void resolveQueenTrades(TagsUpdatedEvent event) {
        if (this.rawTrades.isEmpty()) {
            return;
        }
        ArrayList<RandomizeTradeRowInput> tempRecipeViewerRandomizerTrades = new ArrayList<RandomizeTradeRowInput>();
        ArrayList<Pair<MainTradeRowInput, class_6012<WeightedTradeResult>>> tempRecipeViewerMainTrades = new ArrayList<Pair<MainTradeRowInput, class_6012<WeightedTradeResult>>>();
        Object2ObjectOpenHashMap tempQueenTradesFirstPass = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap tempQueenTrades = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap tempSpecialDaysQueenTrades = new Object2ObjectOpenHashMap();
        for (TradeCollection entry : this.rawTrades) {
            List<TradeResultEntry> tradeResultEntry;
            TradeWantEntry tradeWantEntry;
            if (entry.specialDaysEntry().isPresent()) {
                if (entry.wantItems().isEmpty() || entry.resultItems().isEmpty()) continue;
                for (RawTradeInputEntry rawTradeWantEntry : entry.wantItems()) {
                    tradeWantEntry = QueensTradeManager.getInputTradeEntry(rawTradeWantEntry);
                    if (tradeWantEntry == null || tradeWantEntry.wantItems().method_40247() == 0 || (tradeResultEntry = this.getOutputTradeEntry(entry.resultItems().get())).size() == 0) continue;
                    QueensTradeManager.populateSpecialDaysQueenTrades((Object2ObjectOpenHashMap<class_1792, Object2ObjectOpenHashMap<SpecialDaysEntry, class_6012<WeightedTradeResult>>>)tempSpecialDaysQueenTrades, entry.specialDaysEntry().get(), tradeResultEntry, tradeWantEntry);
                }
                continue;
            }
            if (entry.randomizerTrade()) {
                if (entry.randomizerItems().isEmpty()) continue;
                for (RawTradeInputEntry rawTradeRandomizeEntry : entry.randomizerItems().get()) {
                    TradeWantEntry tradeRandomizeEntry = QueensTradeManager.getInputTradeEntry(rawTradeRandomizeEntry);
                    if (tradeRandomizeEntry == null || tradeRandomizeEntry.wantItems().method_40247() == 0) continue;
                    tempRecipeViewerRandomizerTrades.add(new RandomizeTradeRowInput(tradeRandomizeEntry.tagKey()));
                    QueensTradeManager.populateRandomizedQueenTrades((Object2ObjectOpenHashMap<class_1792, Pair<class_6012<WeightedTradeResult>, class_6862<class_1792>>>)tempQueenTradesFirstPass, tradeRandomizeEntry);
                }
                continue;
            }
            if (entry.wantItems().isEmpty() || entry.resultItems().isEmpty()) continue;
            for (RawTradeInputEntry rawTradeWantEntry : entry.wantItems()) {
                tradeWantEntry = QueensTradeManager.getInputTradeEntry(rawTradeWantEntry);
                if (tradeWantEntry == null || tradeWantEntry.wantItems().method_40247() == 0 || (tradeResultEntry = this.getOutputTradeEntry(entry.resultItems().get())).size() == 0) continue;
                QueensTradeManager.populateMainQueenTrades((Object2ObjectOpenHashMap<class_1792, Pair<class_6012<WeightedTradeResult>, class_6862<class_1792>>>)tempQueenTradesFirstPass, tradeResultEntry, tradeWantEntry);
            }
        }
        tempRecipeViewerRandomizerTrades.removeIf(randomizerTrade -> {
            Set wantSet = randomizerTrade.getWantItems().method_40239().map(class_6880::comp_349).collect(Collectors.toUnmodifiableSet());
            for (class_1792 item : wantSet) {
                if (!tempQueenTradesFirstPass.containsKey((Object)item)) {
                    return true;
                }
                List tradeResults = ((class_6012)((Pair)tempQueenTradesFirstPass.get((Object)item)).getFirst()).method_34994();
                if (!tradeResults.stream().anyMatch(r -> r.getItems().stream().anyMatch(t -> !wantSet.contains(t)))) continue;
                for (class_1792 item2 : wantSet) {
                    tempQueenTradesFirstPass.put((Object)item2, (Object)Pair.of((Object)((class_6012)((Pair)tempQueenTradesFirstPass.get((Object)item2)).getFirst()), null));
                }
                return true;
            }
            for (class_1792 item : wantSet) {
                Pair pair = (Pair)tempQueenTradesFirstPass.remove((Object)item);
                tempQueenTrades.put((Object)item, (Object)((class_6012)pair.getFirst()));
            }
            return false;
        });
        HashSet<class_6862> collectedTag = new HashSet<class_6862>();
        for (Object2ObjectMap.Entry pairEntry : tempQueenTradesFirstPass.object2ObjectEntrySet()) {
            ((class_6012)((Pair)pairEntry.getValue()).getFirst()).method_34994().forEach(e -> e.setTotalWeight(((WeightedRandomListAccessor)((Pair)pairEntry.getValue()).getFirst()).bumblezone$getTotalWeight()));
            if (((Pair)pairEntry.getValue()).getSecond() == null || !collectedTag.contains(((Pair)pairEntry.getValue()).getSecond())) {
                tempRecipeViewerMainTrades.add((Pair<MainTradeRowInput, class_6012<WeightedTradeResult>>)Pair.of((Object)new MainTradeRowInput(Optional.ofNullable((class_6862)((Pair)pairEntry.getValue()).getSecond()), (class_1792)pairEntry.getKey()), (Object)((class_6012)((Pair)pairEntry.getValue()).getFirst())));
                if (((Pair)pairEntry.getValue()).getSecond() != null) {
                    collectedTag.add((class_6862)((Pair)pairEntry.getValue()).getSecond());
                }
            }
            tempQueenTrades.put((Object)((class_1792)pairEntry.getKey()), (Object)((class_6012)((Pair)pairEntry.getValue()).getFirst()));
        }
        this.queenTrades = tempQueenTrades;
        this.specialDayQueenTrades = tempSpecialDaysQueenTrades;
        this.recipeViewerRandomizerTrades = tempRecipeViewerRandomizerTrades;
        this.recipeViewerMainTrades = tempRecipeViewerMainTrades;
        this.rawTrades.clear();
        this.recipeViewerMainTrades.sort(Comparator.comparing(item -> class_7923.field_41178.method_10221((Object)((MainTradeRowInput)item.getFirst()).item())));
    }

    private static TradeWantEntry getInputTradeEntry(RawTradeInputEntry rawTradeInputEntry) {
        if (rawTradeInputEntry.entry.startsWith("#")) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(rawTradeInputEntry.entry.replace("#", "")));
            Optional tag = class_7923.field_41178.method_40266(tagKey);
            if (tag.isEmpty() && rawTradeInputEntry.required) {
                Bumblezone.LOGGER.error("Trade input entry is set to required but " + rawTradeInputEntry.entry + " tag does not exist.");
            } else if (tag.isPresent()) {
                return new TradeWantEntry(Optional.of(tagKey), (class_6885<class_1792>)((class_6885)tag.get()));
            }
        } else {
            Optional item = class_7923.field_41178.method_40264(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)new class_2960(rawTradeInputEntry.entry)));
            if (item.isEmpty() && rawTradeInputEntry.required) {
                Bumblezone.LOGGER.error("Trade input entry is set to required but " + rawTradeInputEntry.entry + " item does not exist.");
            } else if (item.isPresent()) {
                return new TradeWantEntry(Optional.empty(), (class_6885<class_1792>)class_6885.method_40246((class_6880[])new class_6880[]{(class_6880)item.get()}));
            }
        }
        return null;
    }

    private List<TradeResultEntry> getOutputTradeEntry(List<RawTradeOutputEntry> rawTradeOutputEntries) {
        ArrayList<TradeResultEntry> tradeResultEntries = new ArrayList<TradeResultEntry>();
        for (RawTradeOutputEntry rawTradeOutputEntry : rawTradeOutputEntries) {
            if (rawTradeOutputEntry.entry.startsWith("#")) {
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(rawTradeOutputEntry.entry.replace("#", "")));
                Optional tag = class_7923.field_41178.method_40266(tagKey);
                if (tag.isEmpty() && rawTradeOutputEntry.required) {
                    Bumblezone.LOGGER.error("Trade result entry is set to required but " + rawTradeOutputEntry.entry + " tag does not exist.");
                    continue;
                }
                tag.ifPresent(holders -> tradeResultEntries.add(new TradeResultEntry(Optional.of(tagKey), (class_6885<class_1792>)holders, rawTradeOutputEntry.count(), rawTradeOutputEntry.xpReward(), rawTradeOutputEntry.weight)));
                continue;
            }
            Optional item = class_7923.field_41178.method_40264(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)new class_2960(rawTradeOutputEntry.entry)));
            if (item.isEmpty() && rawTradeOutputEntry.required) {
                Bumblezone.LOGGER.error("Trade result entry is set to required but " + rawTradeOutputEntry.entry + " item does not exist.");
                continue;
            }
            item.ifPresent(itemHolder -> tradeResultEntries.add(new TradeResultEntry(Optional.empty(), (class_6885<class_1792>)class_6885.method_40246((class_6880[])new class_6880[]{itemHolder}), rawTradeOutputEntry.count(), rawTradeOutputEntry.xpReward(), rawTradeOutputEntry.weight)));
        }
        return tradeResultEntries;
    }

    private static void populateSpecialDaysQueenTrades(Object2ObjectOpenHashMap<class_1792, Object2ObjectOpenHashMap<SpecialDaysEntry, class_6012<WeightedTradeResult>>> tempSpecialDaysQueenTrades, SpecialDaysEntry specialDaysEntry, List<TradeResultEntry> tradeResultEntries, TradeWantEntry tradeWantEntry) {
        ArrayList<class_1792> wantItems = new ArrayList<class_1792>(tradeWantEntry.wantItems().method_40239().map(class_6880::comp_349).toList());
        for (class_1792 item : wantItems) {
            ArrayList<WeightedTradeResult> resultItems = new ArrayList<WeightedTradeResult>();
            for (TradeResultEntry tradeResultEntry : tradeResultEntries) {
                resultItems.add(new WeightedTradeResult(tradeResultEntry.tagKey(), Optional.of(tradeResultEntry.resultItems().method_40239().map(class_6880::comp_349).toList()), tradeResultEntry.count(), tradeResultEntry.xpReward(), tradeResultEntry.weight()));
            }
            Object2ObjectOpenHashMap temp = new Object2ObjectOpenHashMap();
            if (tempSpecialDaysQueenTrades.containsKey((Object)item) && ((Object2ObjectOpenHashMap)tempSpecialDaysQueenTrades.get((Object)item)).containsKey((Object)specialDaysEntry)) {
                class_6012 existingTrades = (class_6012)((Object2ObjectOpenHashMap)tempSpecialDaysQueenTrades.get((Object)item)).get((Object)specialDaysEntry);
                resultItems.addAll(existingTrades.method_34994());
            }
            temp.put((Object)specialDaysEntry, (Object)class_6012.method_34988(resultItems));
            tempSpecialDaysQueenTrades.put((Object)item, (Object)temp);
        }
    }

    private static void populateMainQueenTrades(Object2ObjectOpenHashMap<class_1792, Pair<class_6012<WeightedTradeResult>, class_6862<class_1792>>> tempQueenTrades, List<TradeResultEntry> tradeResultEntries, TradeWantEntry tradeWantEntry) {
        List<class_1792> wantItems = tradeWantEntry.wantItems().method_40239().map(class_6880::comp_349).toList();
        for (class_1792 item : wantItems) {
            ArrayList<WeightedTradeResult> existingTrades = new ArrayList<WeightedTradeResult>();
            class_6862 key = tradeWantEntry.tagKey.orElse(null);
            boolean needsSorting = false;
            if (tempQueenTrades.containsKey((Object)item)) {
                existingTrades.addAll(((class_6012)((Pair)tempQueenTrades.get((Object)item)).getFirst()).method_34994());
                key = null;
                needsSorting = true;
            }
            for (TradeResultEntry tradeResultEntry : tradeResultEntries) {
                List<class_1792> resultItems = tradeResultEntry.resultItems().method_40239().map(class_6880::comp_349).toList();
                existingTrades.add(new WeightedTradeResult(tradeResultEntry.tagKey, Optional.of(resultItems), tradeResultEntry.count(), tradeResultEntry.xpReward(), tradeResultEntry.weight()));
            }
            if (needsSorting) {
                existingTrades.sort((a, b) -> b.weight - a.weight);
            }
            tempQueenTrades.put((Object)item, (Object)Pair.of((Object)class_6012.method_34988(existingTrades), (Object)key));
        }
    }

    private static void populateRandomizedQueenTrades(Object2ObjectOpenHashMap<class_1792, Pair<class_6012<WeightedTradeResult>, class_6862<class_1792>>> tempQueenTrades, TradeWantEntry tradeRandomizeEntry) {
        List<class_1792> items = tradeRandomizeEntry.wantItems().method_40239().map(class_6880::comp_349).toList();
        for (class_1792 item : items) {
            if (tempQueenTrades.containsKey((Object)item)) {
                ArrayList<WeightedTradeResult> existingTrades = new ArrayList<WeightedTradeResult>(((class_6012)((Pair)tempQueenTrades.get((Object)item)).getFirst()).method_34994());
                existingTrades.add(new WeightedTradeResult(tradeRandomizeEntry.tagKey(), Optional.of(items), 1, 0, 1));
                tempQueenTrades.put((Object)item, (Object)Pair.of((Object)class_6012.method_34988(existingTrades), null));
                continue;
            }
            tempQueenTrades.put((Object)item, (Object)Pair.of((Object)class_6012.method_34989((class_6008[])new WeightedTradeResult[]{new WeightedTradeResult(tradeRandomizeEntry.tagKey(), Optional.of(items), 1, 0, 1)}), (Object)tradeRandomizeEntry.tagKey.orElse(null)));
        }
    }

    public Optional<Pair<SpecialDaysEntry, class_6012<WeightedTradeResult>>> getSpecialDayItems(class_1792 item) {
        Object2ObjectOpenHashMap specialDayData = (Object2ObjectOpenHashMap)this.specialDayQueenTrades.get((Object)item);
        if (specialDayData != null) {
            for (Map.Entry specialDaysEntry : specialDayData.entrySet()) {
                LocalDate dateNow = LocalDate.now();
                LocalDate specialDayThisYear = QueensTradeManager.getDateForYear(dateNow.getYear(), (SpecialDaysEntry)specialDaysEntry.getKey()).minusDays(1L);
                if (specialDayThisYear.isBefore(dateNow) && specialDayThisYear.plusDays(((SpecialDaysEntry)specialDaysEntry.getKey()).daysLong() + 1).isAfter(dateNow)) {
                    return Optional.of(Pair.of((Object)((SpecialDaysEntry)specialDaysEntry.getKey()), (Object)((class_6012)specialDaysEntry.getValue())));
                }
                LocalDate specialDayLastYear = QueensTradeManager.getDateForYear(dateNow.getYear() - 1, (SpecialDaysEntry)specialDaysEntry.getKey()).minusDays(1L);
                if (!specialDayLastYear.isBefore(dateNow) || !specialDayLastYear.plusDays(((SpecialDaysEntry)specialDaysEntry.getKey()).daysLong() + 1).isAfter(dateNow)) continue;
                return Optional.of(Pair.of((Object)((SpecialDaysEntry)specialDaysEntry.getKey()), (Object)((class_6012)specialDaysEntry.getValue())));
            }
        }
        return Optional.empty();
    }

    public Optional<List<class_1792>> getSpecialDayItem() {
        ArrayList<class_1792> specialDayItems = new ArrayList<class_1792>();
        block0: for (Map.Entry entry : this.specialDayQueenTrades.entrySet()) {
            for (Map.Entry specialDaysEntry : ((Object2ObjectOpenHashMap)entry.getValue()).entrySet()) {
                LocalDate dateNow = LocalDate.now();
                LocalDate specialDayThisYear = QueensTradeManager.getDateForYear(dateNow.getYear(), (SpecialDaysEntry)specialDaysEntry.getKey()).minusDays(1L);
                if (specialDayThisYear.isBefore(dateNow) && specialDayThisYear.plusDays(((SpecialDaysEntry)specialDaysEntry.getKey()).daysLong() + 1).isAfter(dateNow)) {
                    specialDayItems.add((class_1792)entry.getKey());
                    continue block0;
                }
                LocalDate specialDayLastYear = QueensTradeManager.getDateForYear(dateNow.getYear() - 1, (SpecialDaysEntry)specialDaysEntry.getKey()).minusDays(1L);
                if (!specialDayLastYear.isBefore(dateNow) || !specialDayLastYear.plusDays(((SpecialDaysEntry)specialDaysEntry.getKey()).daysLong() + 1).isAfter(dateNow)) continue;
                specialDayItems.add((class_1792)entry.getKey());
                continue block0;
            }
        }
        if (specialDayItems.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(specialDayItems);
    }

    private static LocalDate getDateForYear(int year, SpecialDaysEntry specialDaysEntry) {
        if (specialDaysEntry.month().isPresent() && specialDaysEntry.day().isPresent()) {
            return LocalDate.of(year, specialDaysEntry.month().get(), (int)specialDaysEntry.day().get());
        }
        if (specialDaysEntry.dateAlgorithm().isPresent()) {
            switch (specialDaysEntry.dateAlgorithm().get()) {
                case "thanksgiving": {
                    return QueensTradeManager.thanksgivingEveAlgo(year);
                }
                case "easter": {
                    return QueensTradeManager.gaussEaster(year).minusDays(1L);
                }
            }
        }
        return LocalDate.EPOCH.plusYears(1L);
    }

    private static LocalDate thanksgivingEveAlgo(int year) {
        return Year.of(year).atMonth(Month.NOVEMBER).atDay(1).with(TemporalAdjusters.dayOfWeekInMonth(4, DayOfWeek.THURSDAY));
    }

    private static LocalDate gaussEaster(int year) {
        float A = year % 19;
        float B = year % 4;
        float C = year % 7;
        float P = (float)Math.floor((float)year / 100.0f);
        float Q = (float)Math.floor((13.0f + 8.0f * P) / 25.0f);
        float M = (int)((double)(15.0f - Q + P) - Math.floor(P / 4.0f)) % 30;
        float N = (int)((double)(4.0f + P) - Math.floor(P / 4.0f)) % 7;
        float D = (19.0f * A + M) % 30.0f;
        float E = (2.0f * B + 4.0f * C + 6.0f * D + N) % 7.0f;
        int days = (int)(22.0f + D + E);
        try {
            if (D == 29.0f && E == 6.0f) {
                return LocalDate.of(year, 4, 19);
            }
            if (D == 28.0f && E == 6.0f) {
                return LocalDate.of(year, 4, 18);
            }
            if (days > 31) {
                return LocalDate.of(year, 4, days - 31);
            }
            return LocalDate.of(year, 3, days);
        }
        catch (Exception exception) {
            return LocalDate.EPOCH.plusYears(1L);
        }
    }

    public record TradeCollection(Optional<SpecialDaysEntry> specialDaysEntry, Optional<List<RawTradeInputEntry>> randomizerItems, List<RawTradeInputEntry> wantItems, Optional<List<RawTradeOutputEntry>> resultItems, boolean randomizerTrade) {
        public static final Codec<TradeCollection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpecialDaysEntry.CODEC.optionalFieldOf("special_days").forGetter(e -> e.specialDaysEntry), (App)RawTradeInputEntry.CODEC.listOf().optionalFieldOf("randomizes").forGetter(e -> e.randomizerItems), (App)RawTradeInputEntry.CODEC.listOf().fieldOf("wants").forGetter(e -> e.wantItems), (App)RawTradeOutputEntry.CODEC.listOf().optionalFieldOf("possible_rewards").forGetter(e -> e.resultItems), (App)Codec.BOOL.fieldOf("is_color_randomizer_trade").orElse((Object)false).forGetter(e -> e.randomizerTrade)).apply((Applicative)instance, instance.stable(TradeCollection::new)));
    }

    public record RawTradeInputEntry(String entry, boolean required) {
        public static final Codec<RawTradeInputEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(e -> e.entry), (App)Codec.BOOL.fieldOf("required").forGetter(e -> e.required)).apply((Applicative)instance, instance.stable(RawTradeInputEntry::new)));
    }

    public record TradeWantEntry(Optional<class_6862<class_1792>> tagKey, class_6885<class_1792> wantItems) {
        public static final Codec<TradeWantEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).optionalFieldOf("tagkey").forGetter(e -> e.tagKey), (App)class_6895.method_40341((class_5321)class_7924.field_41197, (Codec)class_7923.field_41178.method_39673()).fieldOf("wantItems").forGetter(e -> e.wantItems)).apply((Applicative)instance, instance.stable(TradeWantEntry::new)));
    }

    public record SpecialDaysEntry(Optional<String> dateAlgorithm, Optional<Integer> month, Optional<Integer> day, int daysLong, String specialMessage, class_124 textColor) {
        public static final Codec<SpecialDaysEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("date_algorithm").forGetter(e -> e.dateAlgorithm), (App)Codec.intRange((int)1, (int)12).optionalFieldOf("start_month").forGetter(e -> e.month), (App)Codec.intRange((int)1, (int)31).optionalFieldOf("start_day").forGetter(e -> e.day), (App)Codec.intRange((int)1, (int)364).fieldOf("lasts_days_long").forGetter(e -> e.daysLong), (App)Codec.STRING.fieldOf("special_message").forGetter(e -> e.specialMessage), (App)class_124.field_39218.fieldOf("text_color").forGetter(e -> e.textColor)).apply((Applicative)instance, instance.stable(SpecialDaysEntry::new)));
    }

    public record RawTradeOutputEntry(String entry, boolean required, int count, int xpReward, int weight) {
        public static final Codec<RawTradeOutputEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(e -> e.entry), (App)Codec.BOOL.fieldOf("required").forGetter(e -> e.required), (App)Codec.intRange((int)1, (int)64).fieldOf("count").forGetter(e -> e.count), (App)class_5699.field_33441.fieldOf("xp_reward").forGetter(e -> e.xpReward), (App)class_5699.field_33442.fieldOf("weight").forGetter(e -> e.weight)).apply((Applicative)instance, instance.stable(RawTradeOutputEntry::new)));
    }

    public record TradeResultEntry(Optional<class_6862<class_1792>> tagKey, class_6885<class_1792> resultItems, int count, int xpReward, int weight) {
        public static final Codec<TradeResultEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).optionalFieldOf("tagkey").forGetter(e -> e.tagKey), (App)class_6895.method_40341((class_5321)class_7924.field_41197, (Codec)class_7923.field_41178.method_39673()).fieldOf("wantItems").forGetter(e -> e.resultItems), (App)Codec.intRange((int)1, (int)64).fieldOf("count").forGetter(e -> e.count), (App)class_5699.field_33441.fieldOf("xp_reward").forGetter(e -> e.xpReward), (App)class_5699.field_33442.fieldOf("weight").forGetter(e -> e.weight)).apply((Applicative)instance, instance.stable(TradeResultEntry::new)));
    }
}

