/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.teleportation;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_26;
import net.minecraft.class_2632;
import net.minecraft.class_2680;
import net.minecraft.class_2696;
import net.minecraft.class_2724;
import net.minecraft.class_2748;
import net.minecraft.class_2783;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_4543;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class BzWorldSavedData
extends class_18 {
    private static final String TELEPORTATION_DATA = "the_bumblezoneteleportation";
    private static final BzWorldSavedData CLIENT_DUMMY = new BzWorldSavedData(null);
    private static final List<QueuedEntityData> QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE = new ArrayList<QueuedEntityData>();
    private static final List<QueuedEntityData> QUEUED_ENTITIES_TO_GENERIC_TELEPORT = new ArrayList<QueuedEntityData>();
    private static final List<NextTickRunnable> RUNNABLES_FOR_NEXT_TICK = new ArrayList<NextTickRunnable>();

    public BzWorldSavedData(class_2487 tag) {
    }

    public static BzWorldSavedData get(class_1937 world) {
        if (!(world instanceof class_3218)) {
            return CLIENT_DUMMY;
        }
        class_26 storage = ((class_3218)world).method_17983();
        return (BzWorldSavedData)storage.method_20786(BzWorldSavedData::new, TELEPORTATION_DATA);
    }

    public class_2487 method_75(class_2487 data) {
        return null;
    }

    public static void queueEntityToTeleport(class_1297 entity, class_5321<class_1937> destination) {
        if (entity != null && !entity.method_37908().method_8608() && !BzWorldSavedData.isEntityQueuedToTeleportAlready(entity)) {
            QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.add(new QueuedEntityData(entity, destination));
        }
    }

    public static void queueEntityToGenericTeleport(class_1297 entity, class_5321<class_1937> destination, class_2338 destinationPos, Runnable runnable) {
        if (entity != null && !entity.method_37908().method_8608() && !BzWorldSavedData.isEntityQueuedToGenericTeleportAlready(entity)) {
            QUEUED_ENTITIES_TO_GENERIC_TELEPORT.add(new QueuedEntityData(entity, destination, destinationPos, runnable));
        }
    }

    public static boolean isEntityQueuedToTeleportAlready(class_1297 entity) {
        return QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.stream().anyMatch(entry -> entry.getEntity().equals((Object)entity));
    }

    public static boolean isEntityQueuedToGenericTeleportAlready(class_1297 entity) {
        return QUEUED_ENTITIES_TO_GENERIC_TELEPORT.stream().anyMatch(entry -> entry.getEntity().equals((Object)entity));
    }

    public static void tick(class_3218 world) {
        class_1297 entity;
        class_5321<class_1937> destinationKey;
        HashSet<class_1297> teleportedEntities;
        RUNNABLES_FOR_NEXT_TICK.removeIf(r -> r.executeTick(world));
        if (QUEUED_ENTITIES_TO_GENERIC_TELEPORT.size() > 0) {
            teleportedEntities = new HashSet<class_1297>();
            for (QueuedEntityData entry2 : QUEUED_ENTITIES_TO_GENERIC_TELEPORT) {
                destinationKey = entry2.getDestination();
                class_2338 destinationPos = entry2.getDestinationPos();
                entity = entry2.getEntity();
                class_3218 destination = world.method_8410().method_8503().method_3847(destinationKey);
                BzWorldSavedData.baseTeleporting(entity, destinationPos.method_46558(), destination, teleportedEntities, entity);
                entry2.runnable.run();
            }
            QUEUED_ENTITIES_TO_GENERIC_TELEPORT.removeIf(entry -> teleportedEntities.contains(entry.getEntity()));
        }
        if (QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.size() > 0) {
            teleportedEntities = new HashSet();
            for (QueuedEntityData entry2 : QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE) {
                class_1297 entity2;
                if (!entry2.getIsCurrentTeleporting()) {
                    class_3222 serverPlayer;
                    entry2.setIsCurrentTeleporting(true);
                    destinationKey = entry2.getDestination();
                    if (destinationKey.equals(BzDimension.BZ_WORLD_KEY)) {
                        entity = entry2.getEntity();
                        if (entity instanceof class_3222) {
                            serverPlayer = (class_3222)entity;
                            serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"system.the_bumblezone.teleporting_into_bz"), true);
                        }
                        ThreadExecutor.dimensionDestinationSearch(world.method_8503(), () -> {
                            try {
                                class_3218 bumblezoneWorld = world.method_8503().method_3847(BzDimension.BZ_WORLD_KEY);
                                return Optional.of(EntityTeleportationBackend.getBzCoordinate(entry2.getEntity(), world, bumblezoneWorld));
                            }
                            catch (Throwable e) {
                                Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Error:", e);
                                return Optional.empty();
                            }
                        }).thenOnServerThread(entry2::setDestinationPosFound);
                        continue;
                    }
                    entity = entry2.getEntity();
                    if (entity instanceof class_3222) {
                        serverPlayer = (class_3222)entity;
                        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"system.the_bumblezone.teleporting_out_of_bz"), true);
                    }
                    ThreadExecutor.dimensionDestinationSearch(world.method_8503(), () -> {
                        try {
                            class_3218 destination = world.method_8410().method_8503().method_3847(destinationKey);
                            return Optional.of(EntityTeleportationBackend.destPostFromOutOfBoundsTeleport(entry2.getEntity(), destination));
                        }
                        catch (Throwable e) {
                            Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Error:", e);
                            return Optional.empty();
                        }
                    }).thenOnServerThread(entry2::setDestinationPosFound);
                    continue;
                }
                if (entry2.getDestinationPosFound() == null || teleportedEntities.contains(entity2 = entry2.getEntity())) continue;
                class_5321<class_1937> destinationKey2 = entry2.getDestination();
                class_3218 destination = world.method_8410().method_8503().method_3847(destinationKey2);
                if (entry2.getDestinationPosFound().isPresent()) {
                    class_243 destinationPos = entry2.getDestinationPosFound().get();
                    if (destinationKey2.equals(BzDimension.BZ_WORLD_KEY)) {
                        BzWorldSavedData.enteringBumblezone(entity2, destinationPos, teleportedEntities);
                        continue;
                    }
                    if (entity2.method_5642() != null) {
                        BzWorldSavedData.exitingBumblezone((class_1297)entity2.method_5642(), destinationPos, destination, teleportedEntities);
                        continue;
                    }
                    BzWorldSavedData.exitingBumblezone(entity2, destinationPos, destination, teleportedEntities);
                    continue;
                }
                teleportedEntities.add(entity2);
                if (!(entity2 instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)entity2;
                serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"system.the_bumblezone.failed_teleporting"), false);
                Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Aborting teleportation. Please retry. Entity: {}-{} Pos: {} Destination: {}", new Object[]{entity2.getClass().getSimpleName(), entity2.method_5477(), entity2.method_19538(), destinationKey2});
            }
            QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.removeIf(entry -> teleportedEntities.contains(entry.getEntity()));
        }
    }

    public static void enteringBumblezone(class_1297 entity, class_243 destinationPosFound, Set<class_1297> teleportedEntities) {
        if (!entity.method_37908().method_8608()) {
            MinecraftServer minecraftServer = entity.method_5682();
            class_3218 bumblezoneWorld = minecraftServer.method_3847(BzDimension.BZ_WORLD_KEY);
            class_2338 blockPos = class_2338.method_49638((class_2374)destinationPosFound);
            if (bumblezoneWorld != null) {
                if (bumblezoneWorld.method_8320(blockPos.method_10084()).method_26228((class_1922)bumblezoneWorld, blockPos.method_10084())) {
                    RUNNABLES_FOR_NEXT_TICK.add(new NextTickRunnable(bumblezoneWorld.method_8510() + 5L, () -> {
                        class_3222 fakePlayer = BzWorldSavedData.createSilkTouchFakePlayer(bumblezoneWorld);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos, class_2246.field_10124);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10084(), class_2246.field_10124);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10074(), class_2246.field_21212);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10084().method_10084(), class_2246.field_21212);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10095(), class_2246.field_21212);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10067(), class_2246.field_21212);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10078(), class_2246.field_21212);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10072(), class_2246.field_21212);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10095().method_10084(), class_2246.field_21212);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10067().method_10084(), class_2246.field_21212);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10078().method_10084(), class_2246.field_21212);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.method_10072().method_10084(), class_2246.field_21212);
                    }));
                }
                if (BzDimensionConfigs.enableInitialWelcomeMessage && entity instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)entity;
                    RUNNABLES_FOR_NEXT_TICK.add(new NextTickRunnable(bumblezoneWorld.method_8510() + 20L, () -> ModuleHelper.getModule((class_1297)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(playerData -> {
                        if (!playerData.gottenWelcomedInDimension) {
                            playerData.gottenWelcomedInDimension = true;
                            serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"system.the_bumblezone.advancement_hint"), false);
                        }
                    })));
                }
            }
            ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM).ifPresent(capability -> {
                capability.setNonBZPos(entity.method_19538());
                capability.setNonBZDim(entity.method_37908().method_27983().method_29177());
                if (bumblezoneWorld == null) {
                    if (entity instanceof class_3222) {
                        class_3222 playerEntity = (class_3222)entity;
                        Bumblezone.LOGGER.info("Bumblezone: Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: https://bugs.mojang.com/browse/MC-195468. A restart will fix this.");
                        class_5250 message = class_2561.method_43469((String)"system.the_bumblezone.missing_dimension", (Object[])new Object[]{class_2561.method_43471((String)"system.the_bumblezone.missing_dimension_link").method_27692(class_124.field_1061)});
                        playerEntity.method_7353((class_2561)message, false);
                    }
                    teleportedEntities.add(entity);
                    return;
                }
                class_1297 baseVehicle = entity.method_5668();
                BzWorldSavedData.baseTeleporting(entity, destinationPosFound, bumblezoneWorld, teleportedEntities, baseVehicle);
            });
        }
    }

    public static void exitingBumblezone(class_1297 entity, class_243 destinationPosition, class_3218 destination, Set<class_1297> teleportedEntities) {
        class_2338 destBlockPos = class_2338.method_49638((class_2374)destinationPosition);
        if (destination.method_8320(destBlockPos.method_10084()).method_26228((class_1922)destination, destBlockPos.method_10084())) {
            RUNNABLES_FOR_NEXT_TICK.add(new NextTickRunnable(destination.method_8510() + 5L, () -> {
                class_3222 fakePlayer = BzWorldSavedData.createSilkTouchFakePlayer(destination);
                BzWorldSavedData.destroyAndPlaceBlock(destination, fakePlayer, destBlockPos, class_2246.field_10124);
                BzWorldSavedData.destroyAndPlaceBlock(destination, fakePlayer, destBlockPos.method_10084(), class_2246.field_10124);
            }));
        }
        class_1297 baseVehicle = entity.method_5668();
        BzWorldSavedData.baseTeleporting(entity, destinationPosition, destination, teleportedEntities, baseVehicle);
    }

    private static void destroyAndPlaceBlock(class_3218 level, class_3222 fakePlayer, class_2338 blockPos, class_2248 block) {
        class_2680 state = level.method_8320(blockPos);
        class_2586 blockEntity = state.method_31709() ? level.method_8321(blockPos) : null;
        class_2248.method_9511((class_2680)state, (class_1937)level, (class_2338)blockPos, (class_2586)blockEntity, (class_1297)fakePlayer, (class_1799)fakePlayer.method_6047());
        level.method_8501(blockPos, block.method_9564());
    }

    private static class_3222 createSilkTouchFakePlayer(class_3218 level) {
        class_3222 serverPlayer = PlatformHooks.getFakePlayer(level, null);
        class_1799 fakeHandItem = class_1802.field_8387.method_7854();
        HashMap<class_1887, Integer> enchantmentHashMap = new HashMap<class_1887, Integer>();
        enchantmentHashMap.put(class_1893.field_9099, 1);
        class_1890.method_8214(enchantmentHashMap, (class_1799)fakeHandItem);
        serverPlayer.method_6122(class_1268.field_5808, fakeHandItem);
        return serverPlayer;
    }

    private static void baseTeleporting(class_1297 entity, class_243 destinationPosition, class_3218 destination, Set<class_1297> teleportedEntities, class_1297 baseVehicle) {
        BzWorldSavedData.teleportEntityAndAssignToVehicle(baseVehicle, null, destination, destinationPosition, teleportedEntities);
        ((class_3218)entity.method_37908()).method_14197();
        destination.method_14197();
    }

    private static void teleportEntityAndAssignToVehicle(class_1297 entity, class_1297 vehicle, class_3218 destination, class_243 destinationPosition, Set<class_1297> teleportedEntities) {
        class_1297 teleportedEntity;
        List passengers = entity.method_5685();
        entity.method_5772();
        entity.method_30229();
        if (destination.method_27983().equals(BzDimension.BZ_WORLD_KEY)) {
            ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM).ifPresent(capability -> {
                capability.setNonBZPos(entity.method_19538());
                capability.setNonBZDim(entity.method_37908().method_27983().method_29177());
            });
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            if (serverPlayer.method_6113()) {
                serverPlayer.method_7358(true, true);
            }
            if (PlatformHooks.isDimensionAllowed(serverPlayer, (class_5321<class_1937>)destination.method_27983())) {
                serverPlayer.field_13987.method_14364((class_2596)new class_2724(destination.method_44013(), destination.method_27983(), class_4543.method_27984((long)destination.method_8412()), serverPlayer.field_13974.method_14257(), serverPlayer.field_13974.method_30119(), destination.method_27982(), destination.method_28125(), 3, serverPlayer.method_43122(), serverPlayer.method_51848()));
                serverPlayer.method_14251(destination, destinationPosition.field_1352, destinationPosition.field_1351 + (double)0.1f, destinationPosition.field_1350, serverPlayer.method_36454(), serverPlayer.method_36455());
                serverPlayer.field_13987.method_14364((class_2596)new class_2632(destination.method_8407(), destination.method_8401().method_197()));
                serverPlayer.field_13987.method_14364((class_2596)new class_2748(serverPlayer.field_7510, serverPlayer.field_7495, serverPlayer.field_7520));
                serverPlayer.field_13987.method_14364((class_2596)new class_2696(serverPlayer.method_31549()));
                serverPlayer.field_13995.method_3760().method_14606(serverPlayer, destination);
                serverPlayer.field_13995.method_3760().method_14576(serverPlayer);
                serverPlayer.method_51850(100);
                serverPlayer.method_6092(new class_1293(class_1294.field_5906, 20, 1, false, false, false));
                serverPlayer.field_13995.method_3760().method_14594(serverPlayer);
                teleportedEntity = destination.method_18470(serverPlayer.method_5667());
            } else {
                teleportedEntity = null;
            }
        } else {
            class_1297 newEntity = entity;
            if ((newEntity = newEntity.method_5864().method_5883((class_1937)destination)) == null) {
                return;
            }
            newEntity.method_5878(entity);
            newEntity.method_5808(destinationPosition.field_1352, destinationPosition.field_1351, destinationPosition.field_1350, entity.method_36454(), entity.method_36455());
            newEntity.method_51850(100);
            destination.method_18769(newEntity);
            teleportedEntity = newEntity;
            entity.method_5650(class_1297.class_5529.field_27002);
        }
        teleportedEntities.add(entity);
        if (teleportedEntity != null) {
            class_1923 chunkpos = new class_1923(class_2338.method_49637((double)destinationPosition.field_1352, (double)destinationPosition.field_1351, (double)destinationPosition.field_1350));
            destination.method_14178().method_17297(class_3230.field_19347, chunkpos, 1, (Object)entity.method_5628());
            if (vehicle != null) {
                teleportedEntity.method_5804(vehicle);
            }
            if (teleportedEntity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)teleportedEntity;
                if (livingEntity instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)livingEntity;
                    for (class_1293 effectInstance : new ArrayList(livingEntity.method_6026())) {
                        serverPlayer.field_13987.method_14364((class_2596)new class_2783(serverPlayer.method_5628(), effectInstance));
                    }
                } else {
                    BzWorldSavedData.reAddStatusEffect(livingEntity);
                }
            }
            passengers.forEach(passenger -> BzWorldSavedData.teleportEntityAndAssignToVehicle(passenger, teleportedEntity, destination, destinationPosition, teleportedEntities));
        }
    }

    private static void reAddStatusEffect(class_1309 livingEntity) {
        ArrayList effectInstanceList = new ArrayList(livingEntity.method_6026());
        for (int i = effectInstanceList.size() - 1; i >= 0; --i) {
            class_1293 effectInstance = (class_1293)effectInstanceList.get(i);
            if (effectInstance == null) continue;
            livingEntity.method_6016(effectInstance.method_5579());
            livingEntity.method_6092(new class_1293(effectInstance.method_5579(), effectInstance.method_5584(), effectInstance.method_5578(), effectInstance.method_5591(), effectInstance.method_5581(), effectInstance.method_5592()));
        }
    }

    private static final class QueuedEntityData {
        private final class_1297 entity;
        private final class_5321<class_1937> destination;
        private final class_2338 destinationPos;
        private final Runnable runnable;
        private boolean isCurrentTeleporting = false;
        private Optional<class_243> destinationPosFound = null;

        public QueuedEntityData(class_1297 entity, class_5321<class_1937> destination) {
            this.entity = entity;
            this.destination = destination;
            this.destinationPos = null;
            this.runnable = null;
        }

        public QueuedEntityData(class_1297 entity, class_5321<class_1937> destination, class_2338 destinationPos, Runnable runnable) {
            this.entity = entity;
            this.destination = destination;
            this.destinationPos = destinationPos;
            this.runnable = runnable;
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        public class_5321<class_1937> getDestination() {
            return this.destination;
        }

        public class_2338 getDestinationPos() {
            return this.destinationPos;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public Optional<class_243> getDestinationPosFound() {
            return this.destinationPosFound;
        }

        public void setDestinationPosFound(Optional<class_243> destinationPosFound) {
            this.destinationPosFound = destinationPosFound;
        }

        public boolean getIsCurrentTeleporting() {
            return this.isCurrentTeleporting;
        }

        public void setIsCurrentTeleporting(boolean isCurrentTeleporting) {
            this.isCurrentTeleporting = isCurrentTeleporting;
        }
    }

    private record NextTickRunnable(long targetTick, Runnable runnable) {
        public boolean executeTick(class_3218 serverLevel) {
            if (serverLevel.method_8510() >= this.targetTick()) {
                this.runnable.run();
                return true;
            }
            return false;
        }
    }
}

