/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.structures;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.mixin.world.SinglePoolElementAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.world.StructurePoolAccessor;
import com.telepathicgrunt.the_bumblezone.utils.BoxOctree;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableObject;

public class OptimizedJigsawManager {
    public static Optional<class_3195.class_7150> assembleJigsawStructure(class_3195.class_7149 context, class_6880<class_3785> startPoolHolder, int size, class_2960 structureID, class_2338 startPos, boolean doBoundaryAdjustments, Optional<class_2902.class_2903> heightmapType, int maxDistanceFromCenter, BiConsumer<class_6626, List<class_3790>> structureBoundsAdjuster, boolean ignoreBounds) {
        return OptimizedJigsawManager.assembleJigsawStructure(context, startPoolHolder, size, structureID, startPos, doBoundaryAdjustments, heightmapType, maxDistanceFromCenter, Optional.empty(), structureBoundsAdjuster, ignoreBounds, Optional.empty());
    }

    public static Optional<class_3195.class_7150> assembleJigsawStructure(class_3195.class_7149 context, class_6880<class_3785> startPoolHolder, int size, class_2960 structureID, class_2338 startPos, boolean doBoundaryAdjustments, Optional<class_2902.class_2903> heightmapType, int maxDistanceFromCenter, Optional<Integer> minYLimit, BiConsumer<class_6626, List<class_3790>> structureBoundsAdjuster, boolean ignoreBounds, Optional<class_2960> startJigsaw) {
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_567(), context.comp_568().field_9181, context.comp_568().field_9180);
        class_3785 startPool = (class_3785)startPoolHolder.comp_349();
        if (startPool.method_16632() == 0) {
            Bumblezone.LOGGER.warn("Bumblezone: Empty or nonexistent start pool in structure: {}  Crash is imminent", (Object)structureID);
            throw new RuntimeException("Bumblezone: Empty or nonexistent start pool in structure: " + String.valueOf(structureID) + " Crash is imminent");
        }
        class_3784 startPieceBlueprint = startPool.method_16631((class_5819)random);
        if (startPieceBlueprint == class_3777.field_16663) {
            return Optional.empty();
        }
        class_2470 rotation = class_2470.method_16548((class_5819)random);
        class_2338 trueStartPos = startPos;
        if (startJigsaw.isPresent()) {
            class_2960 resourceLocation = startJigsaw.get();
            Optional<class_2338> optionalStartOffset = OptimizedJigsawManager.getRandomNamedJigsaw(startPieceBlueprint, resourceLocation, class_2338.field_10980, rotation, context.comp_565(), random);
            if (optionalStartOffset.isEmpty()) {
                Bumblezone.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourceLocation, (Object)startPoolHolder.method_40230().map(resourceKey -> resourceKey.method_29177().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            trueStartPos = trueStartPos.method_10059((class_2382)optionalStartOffset.get());
        }
        class_3790 startPiece = new class_3790(context.comp_565(), startPieceBlueprint, trueStartPos, startPieceBlueprint.method_19308(), rotation, startPieceBlueprint.method_16628(context.comp_565(), trueStartPos, rotation));
        class_3341 pieceBoundingBox = startPiece.method_14935();
        int pieceCenterX = (pieceBoundingBox.method_35418() + pieceBoundingBox.method_35415()) / 2;
        int pieceCenterZ = (pieceBoundingBox.method_35420() + pieceBoundingBox.method_35417()) / 2;
        int pieceCenterY = trueStartPos.method_10264();
        if (!context.comp_570().test(context.comp_562().method_12098().method_38109(class_5742.method_33100((int)pieceCenterX), class_5742.method_33100((int)pieceCenterY), class_5742.method_33100((int)pieceCenterZ), context.comp_564().method_42371()))) {
            return Optional.empty();
        }
        if (heightmapType.isPresent()) {
            if ((pieceCenterY += GeneralUtils.getLowestLand(context.comp_562(), context.comp_564(), trueStartPos, context.comp_569(), true, heightmapType.get() == class_2902.class_2903.field_13195).method_10264()) >= GeneralUtils.getMaxTerrainLimit(context.comp_562()) - pieceBoundingBox.method_35419()) {
                return Optional.empty();
            }
            if (pieceCenterY <= context.comp_562().method_33730()) {
                return Optional.empty();
            }
        }
        int yAdjustment = pieceBoundingBox.method_35416() + startPiece.method_16646();
        startPiece.method_14922(0, pieceCenterY - yAdjustment, 0);
        int finalPieceCenterY = pieceCenterY;
        class_2378 jigsawPoolRegistry = context.comp_561().method_30530(class_7924.field_41249);
        return Optional.of(new class_3195.class_7150(new class_2338(pieceCenterX, pieceCenterY, pieceCenterZ), structurePiecesBuilder -> {
            ArrayList<class_3790> components = new ArrayList<class_3790>();
            components.add(startPiece);
            components.clear();
            components.add(startPiece);
            if (size > 0) {
                class_238 axisAlignedBB = new class_238((double)(pieceCenterX - maxDistanceFromCenter), (double)(finalPieceCenterY - (maxDistanceFromCenter + 40)), (double)(pieceCenterZ - maxDistanceFromCenter), (double)(pieceCenterX + maxDistanceFromCenter + 1), (double)(finalPieceCenterY + (maxDistanceFromCenter + 120)), (double)(pieceCenterZ + maxDistanceFromCenter + 1));
                BoxOctree boxOctree = new BoxOctree(axisAlignedBB);
                boxOctree.addBox(class_238.method_19316((class_3341)pieceBoundingBox));
                Entry startPieceEntry = new Entry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)boxOctree), finalPieceCenterY + 80, 0);
                Assembler assembler = new Assembler((class_2378<class_3785>)jigsawPoolRegistry, size, context, components, (class_5819)random, minYLimit, ignoreBounds);
                assembler.availablePieces.addLast(startPieceEntry);
                while (!assembler.availablePieces.isEmpty()) {
                    Entry entry = assembler.availablePieces.removeFirst();
                    assembler.generatePiece(entry.piece, entry.boxOctreeMutableObject, entry.topYLimit, entry.depth, doBoundaryAdjustments, context.comp_569());
                }
            }
            components.forEach(arg_0 -> ((class_6626)structurePiecesBuilder).method_35462(arg_0));
            structureBoundsAdjuster.accept((class_6626)structurePiecesBuilder, (List<class_3790>)components);
            if (structurePiecesBuilder.method_38721().method_35419() > context.comp_569().method_31600()) {
                structurePiecesBuilder.method_38719();
                return;
            }
            if (startJigsaw.isEmpty()) {
                GeneralUtils.centerAllPieces(startPos, components);
            }
        }));
    }

    private static Optional<class_2338> getRandomNamedJigsaw(class_3784 structurePoolElement, class_2960 resourceLocation, class_2338 blockPos, class_2470 rotation, class_3485 structureTemplateManager, class_2919 worldgenRandom) {
        List list = structurePoolElement.method_16627(structureTemplateManager, blockPos, rotation, (class_5819)worldgenRandom);
        Optional<class_2338> optional = Optional.empty();
        for (class_3499.class_3501 structureBlockInfo : list) {
            class_2960 resourceLocation2 = class_2960.method_12829((String)Objects.requireNonNull(structureBlockInfo.comp_1343(), () -> String.valueOf(structureBlockInfo) + " nbt was null").method_10558("name"));
            if (!resourceLocation.equals((Object)resourceLocation2)) continue;
            optional = Optional.of(structureBlockInfo.comp_1341());
            break;
        }
        return optional;
    }

    public record Entry(class_3790 piece, MutableObject<BoxOctree> boxOctreeMutableObject, int topYLimit, int depth) {
    }

    public static final class Assembler {
        private final class_2378<class_3785> poolRegistry;
        private final int maxDepth;
        private final class_2794 chunkGenerator;
        private final class_7138 randomState;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> structurePieces;
        private final class_5819 random;
        private final Optional<Integer> minYLimit;
        private final boolean ignoreBounds;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();

        public Assembler(class_2378<class_3785> poolRegistry, int maxDepth, class_3195.class_7149 context, List<? super class_3790> structurePieces, class_5819 random, Optional<Integer> minYLimit, boolean ignoreBounds) {
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = context.comp_562();
            this.randomState = context.comp_564();
            this.structureTemplateManager = context.comp_565();
            this.structurePieces = structurePieces;
            this.random = random;
            this.minYLimit = minYLimit;
            this.ignoreBounds = ignoreBounds;
        }

        public void generatePiece(class_3790 piece, MutableObject<BoxOctree> boxOctree, int minY, int depth, boolean doBoundaryAdjustments, class_5539 heightLimitView) {
            List<class_3499.class_3501> pieceJigsawBlocks;
            class_3784 pieceBlueprint = piece.method_16644();
            class_2338 piecePos = piece.method_16648();
            class_2470 pieceRotation = piece.method_16888();
            class_3341 pieceBoundingBox = piece.method_14935();
            int pieceMinY = pieceBoundingBox.method_35416();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            if (pieceBlueprint instanceof class_3781) {
                class_3781 singlePoolElement = (class_3781)pieceBlueprint;
                pieceJigsawBlocks = GeneralUtils.getShuffledJigsawBlocksWithoutPriority(singlePoolElement, this.structureTemplateManager, piecePos, pieceRotation, this.random);
            } else {
                pieceJigsawBlocks = pieceBlueprint.method_16627(this.structureTemplateManager, piecePos, pieceRotation, this.random);
            }
            for (class_3499.class_3501 jigsawBlock : pieceJigsawBlocks) {
                class_3784 generatedPiece;
                int targetPieceBoundsTop;
                MutableObject<BoxOctree> octreeToUse;
                class_2350 direction = class_3748.method_26378((class_2680)jigsawBlock.comp_1342());
                class_2338 jigsawBlockPos = jigsawBlock.comp_1341();
                class_2338 jigsawBlockTargetPos = jigsawBlockPos.method_10093(direction);
                class_2960 jigsawBlockPool = new class_2960(jigsawBlock.comp_1343().method_10558("pool"));
                Optional poolOptional = this.poolRegistry.method_17966(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((class_3785)poolOptional.get()).method_16632() == 0 && !Objects.equals(jigsawBlockPool, class_5468.field_26254.method_29177())) {
                    Bumblezone.LOGGER.warn("Bumblezone: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockPool, pieceBlueprint instanceof class_3781 ? ((SinglePoolElementAccessor)pieceBlueprint).bumblezone$getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                class_6880 fallbackOptional = ((class_3785)poolOptional.get()).method_46736();
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.method_14662((class_2382)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    octreeToUse = parentOctree;
                    targetPieceBoundsTop = pieceMinY;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(class_238.method_19316((class_3341)pieceBoundingBox)));
                    }
                } else {
                    octreeToUse = boxOctree;
                    targetPieceBoundsTop = minY;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)poolOptional.get()).bumblezone$getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView)) != null) continue;
                this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)fallbackOptional.comp_349()).bumblezone$getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView);
            }
        }

        private class_3784 processList(List<Pair<class_3784, Integer>> candidatePieces, boolean doBoundaryAdjustments, class_3499.class_3501 jigsawBlock, class_2338 jigsawBlockTargetPos, int pieceMinY, class_2338 jigsawBlockPos, MutableObject<BoxOctree> boxOctreeMutableObject, class_3790 piece, int depth, int targetPieceBoundsTop, class_5539 heightLimitView) {
            class_3785.class_3786 piecePlacementBehavior = piece.method_16644().method_16624();
            boolean isPieceRigid = piecePlacementBehavior == class_3785.class_3786.field_16687;
            int jigsawBlockRelativeY = jigsawBlockPos.method_10264() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                boolean isCandidateRigid;
                class_3784 candidatePiece;
                Pair<class_3784, Integer> chosenPiecePair = candidatePieces.get(0);
                int chosenWeight = this.random.method_43048(totalCount) + 1;
                for (Pair<class_3784, Integer> candidate : candidatePieces) {
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPiecePair = candidate;
                    break;
                }
                if ((candidatePiece = (class_3784)chosenPiecePair.getFirst()) == class_3777.field_16663) {
                    return null;
                }
                class_3785.class_3786 candidatePlacementBehavior = candidatePiece.method_16624();
                boolean bl = isCandidateRigid = candidatePlacementBehavior == class_3785.class_3786.field_16687;
                if (!this.ignoreBounds && isCandidateRigid && (!((BoxOctree)boxOctreeMutableObject.getValue()).boundaryContains(jigsawBlockTargetPos) || ((BoxOctree)boxOctreeMutableObject.getValue()).withinAnyBox(jigsawBlockTargetPos))) {
                    totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (class_2470 rotation : class_2470.method_16547((class_5819)this.random)) {
                    List<class_3499.class_3501> candidateJigsawBlocks;
                    if (candidatePiece instanceof class_3781) {
                        class_3781 singlePoolElement = (class_3781)candidatePiece;
                        candidateJigsawBlocks = GeneralUtils.getShuffledJigsawBlocksWithoutPriority(singlePoolElement, this.structureTemplateManager, class_2338.field_10980, rotation, this.random);
                    } else {
                        candidateJigsawBlocks = candidatePiece.method_16627(this.structureTemplateManager, class_2338.field_10980, rotation, this.random);
                    }
                    class_3341 tempCandidateBoundingBox = candidatePiece.method_16628(this.structureTemplateManager, class_2338.field_10980, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.method_14660() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.method_14662((class_2382)pieceCandidateJigsawBlock.comp_1341().method_10093(class_3748.method_26378((class_2680)pieceCandidateJigsawBlock.comp_1342())))) {
                            return 0;
                        }
                        class_2960 candidateTargetPool = new class_2960(pieceCandidateJigsawBlock.comp_1343().method_10558("pool"));
                        Optional candidateTargetPoolOptional = this.poolRegistry.method_17966(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(structureTemplatePool -> Optional.of((class_3785)structureTemplatePool.method_46736().comp_349()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(p_242842_1_ -> p_242842_1_.method_19309(this.structureTemplateManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(p_242840_1_ -> p_242840_1_.method_19309(this.structureTemplateManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    String parentJoint = GeneralUtils.getStringMicroOptimised(jigsawBlock.comp_1343(), "joint");
                    String parentTarget = GeneralUtils.getStringMicroOptimised(jigsawBlock.comp_1343(), "target");
                    for (class_3499.class_3501 candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!GeneralUtils.canJigsawsAttach(jigsawBlock, candidateJigsawBlock, parentJoint, parentTarget)) continue;
                        class_2338 candidateJigsawBlockPos = candidateJigsawBlock.comp_1341();
                        class_2338 candidateJigsawBlockRelativePos = new class_2338(jigsawBlockTargetPos.method_10263() - candidateJigsawBlockPos.method_10263(), jigsawBlockTargetPos.method_10264() - candidateJigsawBlockPos.method_10264(), jigsawBlockTargetPos.method_10260() - candidateJigsawBlockPos.method_10260());
                        class_3341 candidateBoundingBox = candidatePiece.method_16628(this.structureTemplateManager, candidateJigsawBlockRelativePos, rotation);
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.method_10264();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + class_3748.method_26378((class_2680)jigsawBlock.comp_1342()).method_10164();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, heightLimitView, this.randomState);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.method_35416();
                        class_3341 adjustedCandidateBoundingBox = candidateBoundingBox.method_19311(0, candidatePieceYOffsetNeeded, 0);
                        class_2338 adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.method_10069(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.method_35419() - adjustedCandidateBoundingBox.method_35416());
                            adjustedCandidateBoundingBox.method_34389(new class_2338(adjustedCandidateBoundingBox.method_35415(), adjustedCandidateBoundingBox.method_35416() + k2, adjustedCandidateBoundingBox.method_35417()));
                        }
                        if (adjustedCandidateJigsawBlockRelativePos.method_10264() < this.minYLimit.orElse(Integer.MIN_VALUE)) continue;
                        class_238 axisAlignedBB = class_238.method_19316((class_3341)adjustedCandidateBoundingBox);
                        class_238 axisAlignedBBDeflated = axisAlignedBB.method_1011(0.25);
                        boolean validBounds = false;
                        if (!this.ignoreBounds && ((BoxOctree)boxOctreeMutableObject.getValue()).boundaryContains(axisAlignedBBDeflated) && !((BoxOctree)boxOctreeMutableObject.getValue()).intersectsAnyBox(axisAlignedBBDeflated)) {
                            ((BoxOctree)boxOctreeMutableObject.getValue()).addBox(axisAlignedBB);
                            validBounds = true;
                        }
                        if (!this.ignoreBounds && !validBounds) continue;
                        int newPieceGroundLevelDelta = piece.method_16646();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.method_19308();
                        class_3790 newPiece = new class_3790(this.structureTemplateManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, heightLimitView, this.randomState);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.method_16647(new class_3780(jigsawBlockTargetPos.method_10263(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.method_10260(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.method_16647(new class_3780(jigsawBlockPos.method_10263(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.method_10260(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((class_3790)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, boxOctreeMutableObject, targetPieceBoundsTop, depth + 1));
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

