/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ElectricRingEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1463;
import net.minecraft.class_1634;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_3730;
import net.minecraft.class_4970;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class EssenceBlockYellow
extends EssenceBlock {
    private static final int RINGS_TO_PASS = 100;

    public EssenceBlockYellow() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16010));
    }

    @Override
    public class_2960 getArenaNbt() {
        return new class_2960("the_bumblezone", "essence/yellow_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return BzGeneralConfigs.yellowArenaTimeFrameInTicks;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.yellow_essence_event", class_1259.class_1260.field_5782, class_1259.class_1261.field_5795).method_5406(true);
    }

    @Override
    public class_2960 getEssenceItemReward() {
        return new class_2960("the_bumblezone", "gameplay/rewards/yellow_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(class_3222 serverPlayer) {
        serverPlayer.method_7281(BzStats.RADIANCE_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        int ringsPassed = essenceBlockEntity.getExtraEventTrackingProgress();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        int ringsActive = 0;
        for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
            class_1634 vex;
            UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
            class_1297 entity = serverLevel.method_14190(entityToCheck);
            if (entity == null) {
                List nearbyRings = serverLevel.method_18467(ElectricRingEntity.class, new class_238((double)((float)blockPos.method_10263() - (float)essenceBlockEntity.getArenaSize().method_10263() * 0.5f), (double)((float)blockPos.method_10264() - (float)essenceBlockEntity.getArenaSize().method_10264() * 0.5f), (double)((float)blockPos.method_10260() - (float)essenceBlockEntity.getArenaSize().method_10260() * 0.5f), (double)((float)blockPos.method_10263() + (float)essenceBlockEntity.getArenaSize().method_10263() * 0.5f), (double)((float)blockPos.method_10264() + (float)essenceBlockEntity.getArenaSize().method_10264() * 0.5f), (double)((float)blockPos.method_10260() + (float)essenceBlockEntity.getArenaSize().method_10260() * 0.5f)));
                for (ElectricRingEntity nearbyRing : nearbyRings) {
                    if (!nearbyRing.method_5667().equals(entityToCheck) || !nearbyRing.getEssenceController().equals(essenceBlockEntity.getUUID())) continue;
                    entity = nearbyRing;
                    break;
                }
            }
            if (entity == null) {
                eventEntitiesInArena.remove(i);
                continue;
            }
            if (entity instanceof ElectricRingEntity) {
                ElectricRingEntity electricRingEntity = (ElectricRingEntity)entity;
                electricRingEntity.setEssenceController(essenceBlockEntity.getUUID());
                electricRingEntity.setEssenceControllerBlockPos(essenceBlockEntity.method_11016());
                electricRingEntity.setEssenceControllerDimension((class_5321<class_1937>)serverLevel.method_27983());
                ++ringsActive;
                continue;
            }
            if (!(entity instanceof class_1634) || (vex = (class_1634)entity).method_5968() == null || vex.field_6012 % 20 != 0) continue;
            class_243 targetDirection = vex.method_5968().method_19538().method_1020(vex.method_19538()).method_1029();
            if (vex.method_7176()) {
                vex.method_45319(targetDirection.method_1021(0.3));
            }
            if (vex.method_6051().method_43048(15) != 0) continue;
            vex.method_5962().method_6239(vex.method_23317(), vex.method_23318(), vex.method_23321(), 1.0);
        }
        if (ringsPassed != 100 && ringsActive == 0) {
            EssenceBlockYellow.spawnNewRing(serverLevel, blockPos, essenceBlockEntity, ringsPassed, eventEntitiesInArena);
            if (ringsPassed >= 2) {
                EssenceBlockYellow.spawnNewEnemy(serverLevel, blockPos, essenceBlockEntity, eventEntitiesInArena);
            }
        }
        float newProgress = ringsPassed / 100;
        essenceBlockEntity.getEventBar().method_5408(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(ringsPassed);
        if (ringsPassed == 100) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
    }

    private static void spawnNewRing(class_3218 serverLevel, class_2338 blockPos, EssenceBlockEntity essenceBlockEntity, int currentRingsPassed, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        class_2338 arenaSize = essenceBlockEntity.getArenaSize();
        class_5819 random = serverLevel.method_8409();
        int x = arenaSize.method_10263() / 2 - 5;
        int y = -(arenaSize.method_10264() / 2) + 1;
        int z = arenaSize.method_10260() / 2 - 5;
        if ((double)(currentRingsPassed / 100) >= 0.5) {
            float randomChosen = random.method_43057();
            randomChosen = (double)randomChosen < 0.3 ? 0.0f : (randomChosen * 0.4f + 0.55f) * (float)(currentRingsPassed * 12 / 100);
            y = (int)Math.min((float)y + randomChosen, (float)arenaSize.method_10264() / 2.0f - 3.0f);
        } else {
            y = (int)Math.min((float)y + random.method_43057() * (float)(currentRingsPassed * 12 / 100), (float)arenaSize.method_10264() / 2.0f - 3.0f);
        }
        switch (currentRingsPassed % 4) {
            case 0: {
                x = (int)((float)x * random.method_43057() + 2.0f);
                z = (int)((float)z * random.method_43057() + 2.0f);
                break;
            }
            case 1: {
                x = (int)((float)x * random.method_43057() + 2.0f);
                z = (int)((float)z * random.method_43057() + 2.0f) * -1;
                break;
            }
            case 2: {
                x = (int)((float)x * random.method_43057() + 2.0f) * -1;
                z = (int)((float)z * random.method_43057() + 2.0f) * -1;
                break;
            }
            case 3: {
                x = (int)((float)x * random.method_43057() + 2.0f) * -1;
                z = (int)((float)z * random.method_43057() + 2.0f);
            }
        }
        class_243 centerOfRing = new class_243((double)(blockPos.method_10263() + x), (double)(blockPos.method_10264() + y), (double)(blockPos.method_10260() + z));
        class_243 centerOfEssence = essenceBlockEntity.method_11016().method_46558();
        centerOfEssence = new class_243(centerOfEssence.method_10216(), 0.0, centerOfEssence.method_10215());
        class_243 vectorFromEssence = centerOfEssence.method_1020(centerOfRing).method_1031(0.0, centerOfRing.method_10214(), 0.0).method_1029();
        double angle = class_3532.method_15349((double)(-vectorFromEssence.method_10216()), (double)vectorFromEssence.method_10215()) + 1.5707963705062866;
        if (angle < 0.0) {
            angle += 3.1415927410125732;
        }
        angle *= 57.2957763671875;
        ElectricRingEntity ringEntity = (ElectricRingEntity)BzEntities.ELECTRIC_RING_ENTITY.get().method_5883((class_1937)serverLevel);
        if (ringEntity != null) {
            ringEntity.method_5780("the_bumblezone.yellow_essence_arena");
            ringEntity.method_36456((float)angle);
            if (y > 0) {
                ringEntity.method_36457(90.0f);
            } else if (y > -3) {
                ringEntity.method_36457(45.0f);
            }
            ringEntity.method_5814(centerOfRing.field_1352, centerOfRing.field_1351, centerOfRing.field_1350);
            ringEntity.method_22862();
            ringEntity.setEssenceController(essenceBlockEntity.getUUID());
            ringEntity.setEssenceControllerBlockPos(essenceBlockEntity.method_11016());
            ringEntity.setEssenceControllerDimension((class_5321<class_1937>)serverLevel.method_27983());
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(ringEntity.method_5667()));
            serverLevel.method_30771((class_1297)ringEntity);
        }
    }

    private static void spawnNewEnemy(class_3218 serverLevel, class_2338 blockPos, EssenceBlockEntity essenceBlockEntity, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        int yOffset;
        class_6862<class_1299<?>> enemyTagToUse = BzTags.ESSENCE_RADIANCE_ARENA_NORMAL_ENEMY;
        List entityTypeList = class_7923.field_41177.method_40266(enemyTagToUse).map(holders -> holders.method_40239().map(class_6880::comp_349).toList()).orElseGet(ArrayList::new);
        class_1299 entityTypeToSpawn = (class_1299)entityTypeList.get(serverLevel.method_8409().method_43048(entityTypeList.size()));
        class_1297 entity = entityTypeToSpawn.method_47821(serverLevel, blockPos.method_10069(0, yOffset = (essenceBlockEntity.getArenaSize().method_10264() - 2) / 2, 0), class_3730.field_16461);
        if (entity != null) {
            entity.method_5780("the_bumblezone.yellow_essence_arena");
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.method_5667()));
            UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.method_8409().method_43048(essenceBlockEntity.getPlayerInArena().size()));
            class_3222 player = serverLevel.method_8503().method_3760().method_14602(playerUUID);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = player;
                float maxHeart = Math.max(serverPlayer.method_6032(), serverPlayer.method_6063());
                float maxArmor = serverPlayer.method_6096();
                float mobHealthBoost = maxHeart / 10.0f + maxArmor / 2.0f;
                float mobAttackBoost = Math.max(maxHeart / 40.0f + maxArmor / 3.0f - 3.5f, 0.0f);
                boolean isEssenced = EssenceOfTheBees.hasEssence(serverPlayer);
                if (!isEssenced) {
                    mobHealthBoost *= 1.5f;
                    mobAttackBoost *= 1.5f;
                }
                if (entity instanceof class_1309) {
                    class_1324 livingEntityAttributeFollowRange;
                    class_1324 livingEntityAttributeFlyingSpeed;
                    class_1324 livingEntityAttributeSpeed;
                    class_1324 livingEntityAttributeKnockback;
                    class_1324 livingEntityAttributeAttack;
                    class_1309 livingEntity = (class_1309)entity;
                    class_1324 livingEntityAttributeHealth = livingEntity.method_5996(class_5134.field_23716);
                    if (livingEntityAttributeHealth != null) {
                        livingEntityAttributeHealth.method_26837(new class_1322(UUID.fromString("03c85bd0-09eb-11ee-be56-0242ac120002"), "Essence Arena Health Boost", (double)mobHealthBoost, class_1322.class_1323.field_6328));
                        livingEntity.method_6025(mobHealthBoost);
                    }
                    if ((livingEntityAttributeAttack = livingEntity.method_5996(class_5134.field_23721)) != null) {
                        livingEntityAttributeAttack.method_26837(new class_1322(UUID.fromString("355141f8-09eb-11ee-be56-0242ac120002"), "Essence Arena Damage Boost", (double)mobAttackBoost, class_1322.class_1323.field_6328));
                    }
                    if ((livingEntityAttributeKnockback = livingEntity.method_5996(class_5134.field_23722)) != null) {
                        livingEntityAttributeKnockback.method_26837(new class_1322(UUID.fromString("29143bb6-37d6-11ee-be56-0242ac120002"), "Essence Arena Knockback Boost", isEssenced ? 0.3 : 0.6, class_1322.class_1323.field_6328));
                    }
                    if ((livingEntityAttributeSpeed = livingEntity.method_5996(class_5134.field_23719)) != null) {
                        livingEntityAttributeSpeed.method_26837(new class_1322(UUID.fromString("39ca0496-fa37-488f-8199-c4779f1afe0c"), "Essence Arena Speed Boost", isEssenced ? 0.065 : 0.085, class_1322.class_1323.field_6328));
                    }
                    if ((livingEntityAttributeFlyingSpeed = livingEntity.method_5996(class_5134.field_23720)) != null) {
                        livingEntityAttributeFlyingSpeed.method_26837(new class_1322(UUID.fromString("c762c216-0a3a-11ee-be56-0242ac120002"), "Essence Arena Flying Speed Boost", isEssenced ? 0.065 : 0.085, class_1322.class_1323.field_6328));
                    }
                    if ((livingEntityAttributeFollowRange = livingEntity.method_5996(class_5134.field_23717)) != null) {
                        livingEntityAttributeFollowRange.method_26837(new class_1322(UUID.fromString("23a7a8a9-85bc-4dc3-9417-a4bd4b1b95a2"), "Essence Arena Sight Boost", 32.0, class_1322.class_1323.field_6328));
                    }
                }
                if (entity instanceof class_5354) {
                    class_5354 neutralMob = (class_5354)entity;
                    neutralMob.method_29514(Integer.MAX_VALUE);
                    neutralMob.method_29513(playerUUID);
                    neutralMob.method_5980((class_1309)serverPlayer);
                } else if (entity instanceof class_1308) {
                    class_1308 mob = (class_1308)entity;
                    mob.method_5980((class_1309)serverPlayer);
                    if (entity instanceof class_1463) {
                        class_1463 rabbit = (class_1463)entity;
                        rabbit.method_47853(class_1463.class_7990.field_41567);
                    }
                }
                if (entity instanceof class_1634) {
                    class_1634 vex = (class_1634)entity;
                    if (eventEntitiesInArena.size() > 25) {
                        vex.method_5803(true);
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.RADIANCE_EVENT.get().method_14833(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(class_3218 serverLevel, class_3222 serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((class_1657)serverPlayer, BzSounds.RADIANCE_EVENT.get().method_14833(), false);
        EssenceBlockYellow.removeBonusEffectsFromPlayer(serverPlayer);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }

    public void ringActivated(ElectricRingEntity electricRingEntity, EssenceBlockEntity essenceBlockEntity, class_3222 serverPlayer) {
        int ringsPassed = essenceBlockEntity.getExtraEventTrackingProgress();
        essenceBlockEntity.getEventEntitiesInArena().removeIf(e -> e.uuid().equals(electricRingEntity.method_5667()));
        if (ringsPassed + 1 >= 100) {
            EssenceBlockYellow.removeBonusEffectsFromPlayer(serverPlayer);
        } else if (EssenceOfTheBees.hasEssence(serverPlayer)) {
            serverPlayer.method_6092(new class_1293(class_1294.field_5904, essenceBlockEntity.getEventTimer(), ringsPassed / 7, false, false));
            serverPlayer.method_6092(new class_1293(class_1294.field_5913, essenceBlockEntity.getEventTimer(), Math.min(ringsPassed / 7, 8), false, false));
        }
        float newProgress = ++ringsPassed / 100;
        essenceBlockEntity.getEventBar().method_5408(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(ringsPassed);
    }

    private static void removeBonusEffectsFromPlayer(class_3222 serverPlayer) {
        if (serverPlayer.method_6059(class_1294.field_5913)) {
            serverPlayer.method_6016(class_1294.field_5913);
        }
        if (serverPlayer.method_6059(class_1294.field_5904)) {
            serverPlayer.method_6016(class_1294.field_5904);
        }
    }
}

