/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.blocks.SuperCandleBase;
import com.telepathicgrunt.the_bumblezone.blocks.SuperCandleWick;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class PotionCandleBlockEntity
extends class_2586 {
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    public static final int DEFAULT_MAX_DURATION = 12000;
    public static final int DEFAULT_RANGE = 3;
    public static final int DEFAULT_LINGER_TIME = 60;
    public static final int DEFAULT_NIGHT_VISION_LINGER_TIME = 240;
    public static final int DEFAULT_CALCULATED_EFFECT_APPLY_INTERVAL_TIME = 10;
    public static final int MAX_CALCULATED_EFFECT_APPLY_INTERVAL_TIME = 200;
    public static final String COLOR_TAG = "color";
    public static final String STATUS_EFFECT_TAG = "status";
    public static final String EFFECT_LEVEL_TAG = "amplifier";
    public static final String MAX_DURATION_TAG = "max_duration";
    public static final String CURRENT_DURATION_TAG = "current_duration";
    public static final String INSTANT_START_TIME_TAG = "instant_start_time";
    public static final String INFINITE_TAG = "infinite";
    public static final String RANGE_TAG = "range";
    public static final String LINGER_TIME_TAG = "linger_time";
    public static final String CALCULATED_EFFECT_APPLY_INTERVAL_TAG = "calculated_effect_apply_interval";
    private int color = 0xFFFFFF;
    private class_1291 mobEffect = null;
    private int effectLevel = 0;
    private int maxDuration = 12000;
    private int currentDuration = 0;
    private long instantStartTime = 0L;
    private boolean infinite = false;
    private int range = 3;
    private int lingerTime = 60;
    private int calculatedEffectApplyInterval = 10;

    protected PotionCandleBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public PotionCandleBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(BzBlockEntities.POTION_CANDLE.get(), blockPos, blockState);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int colorIn) {
        this.color = colorIn;
    }

    public class_1291 getMobEffect() {
        return this.mobEffect;
    }

    public void setMobEffect(class_1291 mobEffect) {
        this.mobEffect = mobEffect;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public int getEffectLevel() {
        return this.effectLevel;
    }

    public int getCurrentDuration() {
        return this.currentDuration;
    }

    public void resetCurrentDuration() {
        this.currentDuration = 0;
    }

    public void increaseCurrentDuration() {
        ++this.currentDuration;
    }

    public long getInstantStartTime() {
        return this.instantStartTime;
    }

    public void resetInstantStartTime() {
        this.instantStartTime = 0L;
    }

    public void setInstantStartTime(long startTime) {
        this.instantStartTime = startTime;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public int getRange() {
        return this.range;
    }

    public int getLingerTime() {
        return this.lingerTime;
    }

    public int getCalculatedEffectApplyInterval() {
        return this.calculatedEffectApplyInterval;
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.color = compoundTag.method_10545(COLOR_TAG) ? compoundTag.method_10550(COLOR_TAG) : 0xFFFFFF;
        this.mobEffect = compoundTag.method_10545(STATUS_EFFECT_TAG) && !compoundTag.method_10558(STATUS_EFFECT_TAG).trim().equals("") ? (class_1291)class_7923.field_41174.method_17966(new class_2960(compoundTag.method_10558(STATUS_EFFECT_TAG))).orElse(null) : null;
        this.effectLevel = compoundTag.method_10545(EFFECT_LEVEL_TAG) ? compoundTag.method_10550(EFFECT_LEVEL_TAG) : 0;
        this.maxDuration = compoundTag.method_10545(MAX_DURATION_TAG) ? compoundTag.method_10550(MAX_DURATION_TAG) : 12000;
        this.currentDuration = compoundTag.method_10545(CURRENT_DURATION_TAG) ? compoundTag.method_10550(CURRENT_DURATION_TAG) : 0;
        this.instantStartTime = compoundTag.method_10545(INSTANT_START_TIME_TAG) ? compoundTag.method_10537(INSTANT_START_TIME_TAG) : 0L;
        this.infinite = this.mobEffect == null || compoundTag.method_10545(INFINITE_TAG) && compoundTag.method_10577(INFINITE_TAG);
        this.range = compoundTag.method_10545(RANGE_TAG) ? compoundTag.method_10550(RANGE_TAG) : 3;
        int n = this.lingerTime = compoundTag.method_10545(LINGER_TIME_TAG) ? compoundTag.method_10550(LINGER_TIME_TAG) : 60;
        if (compoundTag.method_10545(CALCULATED_EFFECT_APPLY_INTERVAL_TAG)) {
            this.calculatedEffectApplyInterval = compoundTag.method_10550(CALCULATED_EFFECT_APPLY_INTERVAL_TAG);
        } else {
            boolean isInstant;
            this.calculatedEffectApplyInterval = PotionCandleBlockEntity.createIntervalTimeForEffectApply(this.mobEffect, this.effectLevel, this.lingerTime);
            boolean bl = isInstant = this.mobEffect != null && this.mobEffect.method_5561();
            if (!isInstant) {
                this.lingerTime += this.calculatedEffectApplyInterval;
            }
        }
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 8);
        }
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        this.saveFieldsToTag(compoundTag);
    }

    private void saveFieldsToTag(class_2487 compoundTag) {
        compoundTag.method_10569(COLOR_TAG, this.color);
        if (this.mobEffect != null) {
            compoundTag.method_10582(STATUS_EFFECT_TAG, class_7923.field_41174.method_10221((Object)this.mobEffect).toString());
        }
        compoundTag.method_10569(EFFECT_LEVEL_TAG, this.effectLevel);
        compoundTag.method_10569(MAX_DURATION_TAG, this.maxDuration);
        compoundTag.method_10569(CURRENT_DURATION_TAG, this.currentDuration);
        compoundTag.method_10544(INSTANT_START_TIME_TAG, this.instantStartTime);
        compoundTag.method_10556(INFINITE_TAG, this.mobEffect == null || this.infinite);
        compoundTag.method_10569(RANGE_TAG, this.range);
        compoundTag.method_10569(LINGER_TIME_TAG, this.lingerTime);
    }

    public void method_38240(class_1799 stack) {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag);
        class_1747.method_38073((class_1799)stack, (class_2591)this.method_11017(), (class_2487)compoundTag);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.saveFieldsToTag(tag);
        return tag;
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        if (blockEntity instanceof PotionCandleBlockEntity) {
            PotionCandleBlockEntity potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity;
            boolean isInstant = potionCandleBlockEntity.getMobEffect() != null && potionCandleBlockEntity.getMobEffect().method_5561();
            boolean instantPotionTime = PotionCandleBlockEntity.isInstantEffectApplyTime(level, potionCandleBlockEntity);
            if (blockState.method_28498((class_2769)SuperCandleBase.LIT) && ((Boolean)blockState.method_11654((class_2769)SuperCandleBase.LIT)).booleanValue()) {
                if (isInstant && instantPotionTime || level.method_8510() % (long)potionCandleBlockEntity.getCalculatedEffectApplyInterval() == 0L) {
                    if (!potionCandleBlockEntity.isInfinite() && potionCandleBlockEntity.getCurrentDuration() >= potionCandleBlockEntity.getMaxDuration()) {
                        SuperCandleWick.extinguish(null, level.method_8320(blockPos.method_10084()), (class_1936)level, blockPos.method_10084());
                        potionCandleBlockEntity.resetCurrentDuration();
                        potionCandleBlockEntity.resetInstantStartTime();
                    } else if (potionCandleBlockEntity.getMobEffect() != null && (!isInstant || instantPotionTime)) {
                        int diameter = potionCandleBlockEntity.getRange() * 2 + 1;
                        List livingEntities = level.method_8390(class_1309.class, class_238.method_30048((class_243)new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5), (double)diameter, (double)diameter, (double)diameter), e -> true);
                        int lingeringTime = isInstant ? 1 : potionCandleBlockEntity.getLingerTime();
                        for (class_1309 livingEntity : livingEntities) {
                            class_1293 mobEffectInstance;
                            boolean shouldApply = true;
                            if (!isInstant && livingEntity.method_6059(potionCandleBlockEntity.getMobEffect())) {
                                mobEffectInstance = livingEntity.method_6112(potionCandleBlockEntity.getMobEffect());
                                int currentEffectTick = mobEffectInstance.method_5584();
                                boolean bl = shouldApply = currentEffectTick < lingeringTime - 1;
                            }
                            if (!shouldApply) continue;
                            mobEffectInstance = new class_1293(potionCandleBlockEntity.getMobEffect(), isInstant ? lingeringTime : lingeringTime + potionCandleBlockEntity.getCalculatedEffectApplyInterval() - 1, Math.max(0, potionCandleBlockEntity.getEffectLevel() - 1), true, true, !potionCandleBlockEntity.getMobEffect().method_5561());
                            livingEntity.method_6092(mobEffectInstance);
                        }
                        if (isInstant && level instanceof class_3218) {
                            class_3218 serverLevel = (class_3218)level;
                            PotionCandleBlockEntity.spawnEffectParticles(serverLevel, blockPos, potionCandleBlockEntity.getMobEffect().method_5573(), potionCandleBlockEntity.getRange());
                        }
                    }
                }
                potionCandleBlockEntity.increaseCurrentDuration();
            }
        }
    }

    public static boolean isInstantEffectApplyTime(class_1937 world, PotionCandleBlockEntity potionCandleBlockEntity) {
        long thresholdTime;
        long trueTimePassed = world.method_8510() - potionCandleBlockEntity.getInstantStartTime();
        return trueTimePassed % (thresholdTime = PotionCandleBlockEntity.getInstantEffectThresholdTime(potionCandleBlockEntity.getEffectLevel())) == 0L;
    }

    public static long getInstantEffectThresholdTime(int amplifier) {
        return 200L + 150L * (long)((float)(amplifier * amplifier) * 0.6f);
    }

    public static int createIntervalTimeForEffectApply(class_1291 mobEffect, int effectLevel, int durationStartingPoint) {
        if (mobEffect == null) {
            return 10;
        }
        for (int interval = 10; interval < 200; ++interval) {
            if (!mobEffect.method_5552(interval + durationStartingPoint, effectLevel - 1)) continue;
            return interval;
        }
        return 10;
    }

    public static class_243 convertIntegerColorToRGB(int color) {
        double red = (double)(color >> 16 & 0xFF) / 255.0;
        double green = (double)(color >> 8 & 0xFF) / 255.0;
        double blue = (double)(color & 0xFF) / 255.0;
        class_243 colorRGB = new class_243(red, green, blue);
        return colorRGB;
    }

    private static void spawnEffectParticles(class_3218 world, class_2338 position, boolean beneficial, int range) {
        world.method_14199((class_2394)(beneficial ? class_2398.field_28479 : class_2398.field_11249), (double)position.method_10263() + 0.5, (double)position.method_10264() + 0.7, (double)position.method_10260() + 0.5, range * 10, (double)(range / 2), (double)(range / 2), (double)(range / 2), 0.1);
    }
}

