/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.essence;

import com.mojang.blaze3d.systems.RenderSystem;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.items.essence.KnowingEssence;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2384;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2611;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_8172;
import net.minecraft.class_8174;
import org.joml.Matrix4f;
import org.joml.Vector4d;

public class KnowingEssenceLootBlockOutlining {
    private static final double DRAW_RADIUS = 0.45;
    private static final double MIN_CORNER = 0.04999999999999999;
    private static final double MAX_CORNER = 0.95;
    private static final Vector4d VECTOR_4D_MIN = new Vector4d(0.04999999999999999, 0.04999999999999999, 0.04999999999999999, 1.0);
    private static final Vector4d VECTOR_4D_MAX = new Vector4d(0.95, 0.95, 0.95, 1.0);
    private static final LinkedHashSet<Long> CACHED_CHUNK_POS = new LinkedHashSet();
    private static final Long2ObjectOpenHashMap<CachedChunkData> CACHED_CHUNK_DATA = new Long2ObjectOpenHashMap();
    private static final Set<class_2248> CACHED_TARGET_BLOCKS = new ObjectOpenHashSet();
    private static final Set<class_2248> CACHED_NONTARGET_BLOCKS = new ObjectOpenHashSet();
    private static final int chunkRadius = 4;
    private static final int chunksToCheck = 81;
    private static final int chunkPerBatch = 3;
    private static final int chunkBatches = 27;
    private static final long scanAllChunkTimeframe = 1000L;
    private static final long targetScanTimeIncrement = 37L;
    private static long targetScanTime = 0L;
    private static long currentScanIncrement = 0L;

    public static void resetTargetBlockCache() {
        CACHED_TARGET_BLOCKS.clear();
        CACHED_NONTARGET_BLOCKS.clear();
    }

    public static void outlineLootBlocks(class_4587 poseStack, class_4184 camera, class_761 levelRenderer) {
        class_1657 player = GeneralUtilsClient.getClientPlayer();
        if (KnowingEssence.IsKnowingEssenceActive(player)) {
            class_1937 level = player.method_37908();
            class_243 cameraPos = camera.method_19326();
            KnowingEssenceLootBlockOutlining.scanChunks(cameraPos, level);
            KnowingEssenceLootBlockOutlining.drawOutlines(poseStack, cameraPos);
        } else if (!CACHED_CHUNK_POS.isEmpty()) {
            CACHED_CHUNK_DATA.clear();
            CACHED_CHUNK_POS.clear();
        }
    }

    private static void scanChunks(class_243 cameraPos, class_1937 level) {
        long currentTime = System.currentTimeMillis();
        if (currentTime > targetScanTime) {
            targetScanTime = currentTime + 37L;
            class_2338 worldSpot = class_2338.method_49638((class_2374)cameraPos);
            class_1923 centerChunkPos = new class_1923(worldSpot);
            int currentChunk = 0;
            HashSet<Long> copySet = new HashSet<Long>(CACHED_CHUNK_POS);
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    long chunkPosLong = class_1923.method_8331((int)(x + centerChunkPos.field_9181), (int)(z + centerChunkPos.field_9180));
                    copySet.remove(chunkPosLong);
                    if ((long)(++currentChunk) <= 3L * currentScanIncrement || (long)currentChunk > 3L * (currentScanIncrement + 1L)) continue;
                    class_2818 chunk = level.method_8497(x + centerChunkPos.field_9181, z + centerChunkPos.field_9180);
                    CACHED_CHUNK_DATA.put(chunkPosLong, (Object)new CachedChunkData((List<CachedDrawData>)new ObjectArrayList()));
                    CACHED_CHUNK_POS.add(chunkPosLong);
                    KnowingEssenceLootBlockOutlining.blockEntityScan(chunk, chunkPosLong);
                    KnowingEssenceLootBlockOutlining.blockScan(chunk, chunkPosLong);
                }
            }
            for (Long chunkPos : copySet) {
                CACHED_CHUNK_POS.remove(chunkPos);
                CACHED_CHUNK_DATA.remove(chunkPos.longValue());
            }
            if (++currentScanIncrement >= 27L) {
                currentScanIncrement = 0L;
            }
        }
    }

    private static void blockEntityScan(class_2818 chunk, long chunkPosLong) {
        for (Map.Entry blockEntityEntry : chunk.method_12214().entrySet()) {
            class_2586 blockEntity = (class_2586)blockEntityEntry.getValue();
            class_2680 blockState = blockEntity.method_11010();
            class_2248 block = blockState.method_26204();
            if (CACHED_NONTARGET_BLOCKS.contains(block)) continue;
            if (CACHED_TARGET_BLOCKS.contains(block) || (blockState.method_26164(BzTags.KNOWING_BLOCK_ENTITY_FORCED_HIGHLIGHTING) || blockEntity instanceof class_2621 || blockEntity instanceof class_8174 || blockEntity instanceof class_2611 || blockEntity instanceof class_8172 || block instanceof class_2336) && !blockState.method_26164(BzTags.KNOWING_BLOCK_ENTITY_PREVENT_HIGHLIGHTING)) {
                CACHED_TARGET_BLOCKS.add(block);
                class_2338 lootBlockPos = (class_2338)blockEntityEntry.getKey();
                int colorInt = block.method_26403().field_16011;
                int red = class_5253.class_5254.method_27765((int)colorInt);
                int green = class_5253.class_5254.method_27766((int)colorInt);
                int blue = class_5253.class_5254.method_27767((int)colorInt);
                ((CachedChunkData)KnowingEssenceLootBlockOutlining.CACHED_CHUNK_DATA.get((long)chunkPosLong)).cachedDrawData.add(new CachedDrawData(VECTOR_4D_MIN.x() + (double)lootBlockPos.method_10263(), VECTOR_4D_MIN.y() + (double)lootBlockPos.method_10264(), VECTOR_4D_MIN.z() + (double)lootBlockPos.method_10260(), VECTOR_4D_MAX.x() + (double)lootBlockPos.method_10263(), VECTOR_4D_MAX.y() + (double)lootBlockPos.method_10264(), VECTOR_4D_MAX.z() + (double)lootBlockPos.method_10260(), red, green, blue));
                continue;
            }
            CACHED_NONTARGET_BLOCKS.add(block);
        }
    }

    private static void blockScan(class_2818 chunk, long chunkPosLong) {
        for (int i = 0; i < chunk.method_32890(); ++i) {
            class_2826 levelChunkSection = chunk.method_38259(i);
            if (levelChunkSection.method_38292() || !levelChunkSection.method_19523(blockState -> !CACHED_NONTARGET_BLOCKS.contains(blockState.method_26204()) && (CACHED_TARGET_BLOCKS.contains(blockState.method_26204()) || blockState.method_26164(BzTags.KNOWING_BLOCK_FORCED_HIGHLIGHTING)) || blockState.method_26204() instanceof class_2384 && !blockState.method_26164(BzTags.KNOWING_BLOCK_PREVENT_HIGHLIGHTING))) continue;
            int minSectionY = chunk.method_31607() + i * 16;
            for (int sectionX = 0; sectionX < 16; ++sectionX) {
                for (int sectionZ = 0; sectionZ < 16; ++sectionZ) {
                    for (int sectionY = 0; sectionY < 16; ++sectionY) {
                        class_2680 blockState2 = levelChunkSection.method_12254(sectionX, sectionY, sectionZ);
                        class_2248 block = blockState2.method_26204();
                        if (CACHED_NONTARGET_BLOCKS.contains(block)) continue;
                        if (CACHED_TARGET_BLOCKS.contains(blockState2.method_26204()) || blockState2.method_26164(BzTags.KNOWING_BLOCK_FORCED_HIGHLIGHTING) || blockState2.method_26204() instanceof class_2384 && !blockState2.method_26164(BzTags.KNOWING_BLOCK_PREVENT_HIGHLIGHTING)) {
                            CACHED_TARGET_BLOCKS.add(block);
                            class_2338 lootBlockPos = new class_2338(sectionX + (chunk.method_12004().field_9181 << 4), minSectionY + sectionY, sectionZ + (chunk.method_12004().field_9180 << 4));
                            int colorInt = block.method_26403().field_16011;
                            int red = class_5253.class_5254.method_27765((int)colorInt);
                            int green = class_5253.class_5254.method_27766((int)colorInt);
                            int blue = class_5253.class_5254.method_27767((int)colorInt);
                            ((CachedChunkData)KnowingEssenceLootBlockOutlining.CACHED_CHUNK_DATA.get((long)chunkPosLong)).cachedDrawData.add(new CachedDrawData(VECTOR_4D_MIN.x() + (double)lootBlockPos.method_10263(), VECTOR_4D_MIN.y() + (double)lootBlockPos.method_10264(), VECTOR_4D_MIN.z() + (double)lootBlockPos.method_10260(), VECTOR_4D_MAX.x() + (double)lootBlockPos.method_10263(), VECTOR_4D_MAX.y() + (double)lootBlockPos.method_10264(), VECTOR_4D_MAX.z() + (double)lootBlockPos.method_10260(), red, green, blue));
                            continue;
                        }
                        CACHED_NONTARGET_BLOCKS.add(block);
                    }
                }
            }
        }
    }

    private static void drawOutlines(class_4587 poseStack, class_243 cameraPos) {
        if (!CACHED_CHUNK_DATA.isEmpty()) {
            boolean hasEntry = false;
            for (CachedChunkData cachedChunkData2 : CACHED_CHUNK_DATA.values()) {
                if (cachedChunkData2.cachedDrawData.isEmpty()) continue;
                hasEntry = true;
                break;
            }
            if (!hasEntry) {
                return;
            }
            poseStack.method_22903();
            class_289 tesselator = class_289.method_1348();
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.disableDepthTest();
            class_287 bufferbuilder = tesselator.method_1349();
            bufferbuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            Matrix4f lastPose = poseStack.method_23760().method_23761();
            CACHED_CHUNK_DATA.values().forEach(cachedChunkData -> cachedChunkData.cachedDrawData.forEach(cachedDrawData -> KnowingEssenceLootBlockOutlining.renderLineBox(bufferbuilder, lastPose, (float)(cachedDrawData.minX - cameraPos.method_10216()), (float)(cachedDrawData.minY - cameraPos.method_10214()), (float)(cachedDrawData.minZ - cameraPos.method_10215()), (float)(cachedDrawData.maxX - cameraPos.method_10216()), (float)(cachedDrawData.maxY - cameraPos.method_10214()), (float)(cachedDrawData.maxZ - cameraPos.method_10215()), cachedDrawData.red, cachedDrawData.green, cachedDrawData.blue)));
            tesselator.method_1350();
            poseStack.method_22909();
            RenderSystem.enableDepthTest();
            class_1921.method_23581().method_23518();
        }
    }

    private static void renderLineBox(class_287 builder, Matrix4f pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int red, int green, int blue) {
        builder.method_22918(pose, minX, minY, minZ).method_1336(red, green, blue, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        builder.method_22918(pose, maxX, minY, minZ).method_1336(red, green, blue, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        builder.method_22918(pose, minX, minY, minZ).method_1336(red, green, blue, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22918(pose, minX, maxY, minZ).method_1336(red, green, blue, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22918(pose, minX, minY, minZ).method_1336(red, green, blue, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(pose, minX, minY, maxZ).method_1336(red, green, blue, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(pose, maxX, minY, minZ).method_1336(red, green, blue, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22918(pose, maxX, maxY, minZ).method_1336(red, green, blue, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22918(pose, maxX, maxY, minZ).method_1336(red, green, blue, 255).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
        builder.method_22918(pose, minX, maxY, minZ).method_1336(red, green, blue, 255).method_22914(-1.0f, 0.0f, 0.0f).method_1344();
        builder.method_22918(pose, minX, maxY, minZ).method_1336(red, green, blue, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(pose, minX, maxY, maxZ).method_1336(red, green, blue, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(pose, minX, maxY, maxZ).method_1336(red, green, blue, 255).method_22914(0.0f, -1.0f, 0.0f).method_1344();
        builder.method_22918(pose, minX, minY, maxZ).method_1336(red, green, blue, 255).method_22914(0.0f, -1.0f, 0.0f).method_1344();
        builder.method_22918(pose, minX, minY, maxZ).method_1336(red, green, blue, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        builder.method_22918(pose, maxX, minY, maxZ).method_1336(red, green, blue, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        builder.method_22918(pose, maxX, minY, maxZ).method_1336(red, green, blue, 255).method_22914(0.0f, 0.0f, -1.0f).method_1344();
        builder.method_22918(pose, maxX, minY, minZ).method_1336(red, green, blue, 255).method_22914(0.0f, 0.0f, -1.0f).method_1344();
        builder.method_22918(pose, minX, maxY, maxZ).method_1336(red, green, blue, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        builder.method_22918(pose, maxX, maxY, maxZ).method_1336(red, green, blue, 255).method_22914(1.0f, 0.0f, 0.0f).method_1344();
        builder.method_22918(pose, maxX, minY, maxZ).method_1336(red, green, blue, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22918(pose, maxX, maxY, maxZ).method_1336(red, green, blue, 255).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22918(pose, maxX, maxY, minZ).method_1336(red, green, blue, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(pose, maxX, maxY, maxZ).method_1336(red, green, blue, 255).method_22914(0.0f, 0.0f, 1.0f).method_1344();
    }

    private record CachedChunkData(List<CachedDrawData> cachedDrawData) {
    }

    private record CachedDrawData(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int red, int green, int blue) {
    }
}

