/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.BzWorldSavedData;
import com.telepathicgrunt.the_bumblezone.events.BlockBreakEvent;
import com.telepathicgrunt.the_bumblezone.events.RegisterCommandsEvent;
import com.telepathicgrunt.the_bumblezone.events.RegisterVillagerTradesEvent;
import com.telepathicgrunt.the_bumblezone.events.RegisterWanderingTradesEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.AddBuiltinResourcePacks;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.DatapackSyncEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.RegisterDataSerializersEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.RegisterFlammabilityEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.RegisterReloadListenerEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.RegisterSpawnPlacementsEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.ServerGoingToStartEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.ServerGoingToStopEvent;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.TagsUpdatedEvent;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerItemAttackBlockEvent;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerItemUseEvent;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerItemUseOnBlockEvent;
import com.telepathicgrunt.the_bumblezone.fabric.FabricReloadListener;
import com.telepathicgrunt.the_bumblezone.fabricbase.FabricBaseEventManager;
import com.telepathicgrunt.the_bumblezone.mixin.fabric.fabricapi.BiomeModificationContextImplMixin;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FabricEventManager {
    public static void init() {
        AddBuiltinResourcePacks.EVENT.invoke(new AddBuiltinResourcePacks((id, displayName, mode) -> {
            ModContainer container = FabricEventManager.getModPack(id);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960(container.getMetadata().getId(), id.method_12832()), (ModContainer)container, (class_2561)displayName, (ResourcePackActivationType)FabricEventManager.toType(mode));
        }));
        FabricBaseEventManager.init();
        RegisterDataSerializersEvent.EVENT.invoke(new RegisterDataSerializersEvent((id, serializer) -> class_2943.method_12720((class_2941)serializer)));
        ServerTickEvents.END_WORLD_TICK.register(BzWorldSavedData::tick);
        ServerLifecycleEvents.SERVER_STARTING.register(a -> ServerGoingToStartEvent.EVENT.invoke(new ServerGoingToStartEvent(a)));
        ServerLifecycleEvents.SERVER_STOPPING.register(a -> ServerGoingToStopEvent.EVENT.invoke(ServerGoingToStopEvent.INSTANCE));
        ServerWorldEvents.LOAD.register((server, level) -> {
            FabricEventManager.setupWanderingTrades();
            FabricEventManager.setupVillagerTrades();
        });
        RegisterFlammabilityEvent.EVENT.invoke(new RegisterFlammabilityEvent((arg_0, arg_1, arg_2) -> ((FlammableBlockRegistry)FlammableBlockRegistry.getDefaultInstance()).add(arg_0, arg_1, arg_2)));
        RegisterReloadListenerEvent.EVENT.invoke(new RegisterReloadListenerEvent((id, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new FabricReloadListener((class_2960)id, (class_3302)listener))));
        RegisterSpawnPlacementsEvent.EVENT.invoke(new RegisterSpawnPlacementsEvent(FabricEventManager::registerPlacement));
        CommonLifecycleEvents.TAGS_LOADED.register((registry, client) -> TagsUpdatedEvent.EVENT.invoke(new TagsUpdatedEvent(registry, client)));
        PlayerBlockBreakEvents.BEFORE.register((level, player, pos, state, blockentity) -> !BlockBreakEvent.EVENT_LOWEST.invoke(new BlockBreakEvent(player, state)));
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> RegisterCommandsEvent.EVENT.invoke(new RegisterCommandsEvent((CommandDispatcher<class_2168>)dispatcher, environment, context)));
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> DatapackSyncEvent.EVENT.invoke(new DatapackSyncEvent(player)));
        AttackBlockCallback.EVENT.register(FabricEventManager::onItemAttackBlock);
        UseBlockCallback.EVENT.register(FabricEventManager::onItemUseOnBlock);
        UseItemCallback.EVENT.register(FabricEventManager::onItemUse);
    }

    public static void lateInit() {
        if (PlatformHooks.isModLoaded("resourcefulbees") && BzModCompatibilityConfigs.spawnResourcefulBeesHoneycombVeins) {
            BiomeModifications.create((class_2960)new class_2960("the_bumblezone", "resourceful_bees_compat")).add(ModificationPhase.ADDITIONS, context -> context.hasTag(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("the_bumblezone", "the_bumblezone"))), context -> {
                for (class_6880<class_6796> placedFeatureHolder : FabricEventManager.getPlacedFeaturesByTag(context, BzTags.RESOURCEFUL_BEES_COMBS)) {
                    class_3037 featureConfiguration = ((class_2975)((class_6796)placedFeatureHolder.comp_349()).comp_334().comp_349()).comp_333();
                    if (!(featureConfiguration instanceof class_3124)) continue;
                    class_3124 oreConfiguration = (class_3124)featureConfiguration;
                    if (!oreConfiguration.field_29063.stream().noneMatch(e -> e.field_29069.method_26215())) continue;
                    context.getGenerationSettings().addFeature(class_2893.class_2895.field_13176, (class_5321)placedFeatureHolder.method_40230().get());
                }
            });
        }
    }

    private static ModContainer getModPack(class_2960 pack) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                if (!mod.getMetadata().getId().startsWith("generated_") || !mod.findPath("resourcepacks/" + pack.method_12832()).isPresent()) continue;
                return mod;
            }
        }
        return (ModContainer)FabricLoader.getInstance().getModContainer(pack.method_12836()).orElseThrow();
    }

    private static <T extends class_1308> void registerPlacement(class_1299<T> type, RegisterSpawnPlacementsEvent.Placement<T> placement) {
        class_1317.method_20637(type, (class_1317.class_1319)placement.spawn(), (class_2902.class_2903)placement.height(), placement.predicate());
    }

    private static ResourcePackActivationType toType(AddBuiltinResourcePacks.PackMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case AddBuiltinResourcePacks.PackMode.USER_CONTROLLED -> ResourcePackActivationType.NORMAL;
            case AddBuiltinResourcePacks.PackMode.ENABLED_BY_DEFAULT -> ResourcePackActivationType.DEFAULT_ENABLED;
            case AddBuiltinResourcePacks.PackMode.FORCE_ENABLED -> ResourcePackActivationType.ALWAYS_ENABLED;
        };
    }

    private static void setupWanderingTrades() {
        Int2ObjectMap trades = class_3853.field_17724;
        List<class_3853.class_1652> basic = Arrays.stream((class_3853.class_1652[])trades.get(1)).collect(Collectors.toList());
        List<class_3853.class_1652> rare = Arrays.stream((class_3853.class_1652[])trades.get(2)).collect(Collectors.toList());
        RegisterWanderingTradesEvent.EVENT.invoke(new RegisterWanderingTradesEvent(basic::add, rare::add));
        trades.put(1, (Object)basic.toArray(new class_3853.class_1652[0]));
        trades.put(2, (Object)rare.toArray(new class_3853.class_1652[0]));
    }

    private static void setupVillagerTrades() {
        Map trades = class_3853.field_17067;
        for (class_3852 profession : class_7923.field_41195) {
            int i;
            if (profession == null) continue;
            Int2ObjectMap profTrades = trades.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap listings = new Int2ObjectOpenHashMap();
            for (i = 1; i <= 5; ++i) {
                if (profTrades.containsKey(i)) {
                    List list = Arrays.stream((class_3853.class_1652[])profTrades.get(i)).collect(Collectors.toList());
                    listings.put(i, list);
                    continue;
                }
                listings.put(i, new ArrayList());
            }
            RegisterVillagerTradesEvent.EVENT.invoke(new RegisterVillagerTradesEvent(profession, (arg_0, arg_1) -> FabricEventManager.lambda$setupVillagerTrades$14((Int2ObjectMap)listings, arg_0, arg_1)));
            for (i = 1; i <= 5; ++i) {
                profTrades.put(i, (Object)((List)listings.get(i)).toArray(new class_3853.class_1652[0]));
            }
        }
    }

    private static Iterable<class_6880<class_6796>> getPlacedFeaturesByTag(BiomeModificationContext context, class_6862<class_6796> placedFeatureTagKey) {
        class_5455 registryAccess = ((BiomeModificationContextImplMixin)context).bumblezone$getRegistries();
        class_2378 placedFeatureRegistry = registryAccess.method_30530(class_7924.field_41245);
        return placedFeatureRegistry.method_40286(placedFeatureTagKey);
    }

    public static class_1269 onItemAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        PlayerItemAttackBlockEvent event = new PlayerItemAttackBlockEvent(player, world, hand, player.method_5998(hand));
        class_1269 result = PlayerItemAttackBlockEvent.EVENT_HIGH.invoke(event);
        return result != null ? result : class_1269.field_5811;
    }

    public static class_1269 onItemUseOnBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        PlayerItemUseOnBlockEvent event = new PlayerItemUseOnBlockEvent(player, world, hand, hitResult, player.method_5998(hand));
        class_1269 result = PlayerItemUseOnBlockEvent.EVENT_HIGH.invoke(event);
        return result != null ? result : class_1269.field_5811;
    }

    public static class_1271<class_1799> onItemUse(class_1657 player, class_1937 level, class_1268 hand) {
        PlayerItemUseEvent event = new PlayerItemUseEvent(player, level, player.method_5998(hand));
        if (PlayerItemUseEvent.EVENT_HIGH.invoke(event)) {
            return class_1271.method_22427((Object)event.usingStack());
        }
        return class_1271.method_22430((Object)event.usingStack());
    }

    private static /* synthetic */ void lambda$setupVillagerTrades$14(Int2ObjectMap listings, Integer i, class_3853.class_1652 listing) {
        ((List)listings.get(i.intValue())).add(listing);
    }
}

