/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.events.entity.EntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.items.BzShieldItem;
import com.telepathicgrunt.the_bumblezone.mixin.items.PlayerDamageShieldInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.ItemExtension;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_8103;
import net.minecraft.class_8109;
import org.jetbrains.annotations.Nullable;

public class HoneyCrystalShield
extends BzShieldItem
implements ItemExtension {
    private static final int[] shieldDurabilityBoostPerLevel = new int[]{0, 20, 45, 75, 110, 150, 195, 245, 316, 632};
    private static final int maxShieldLevel = shieldDurabilityBoostPerLevel.length - 1;

    public HoneyCrystalShield(class_1792.class_1793 properties) {
        super(properties.method_7895(40));
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return repair.method_31573(BzTags.HONEY_CRYSTAL_SHIELD_REPAIR_ITEMS);
    }

    @Override
    public class_1304 bz$getEquipmentSlot(class_1799 stack) {
        return class_1304.field_6171;
    }

    @Nullable
    public class_1304 getEquipmentSlot(class_1799 stack) {
        return this.bz$getEquipmentSlot(stack);
    }

    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (stack.method_7985()) {
            int shieldLevel = Math.max(Math.min(stack.method_7948().method_10550("ShieldLevel"), maxShieldLevel), 0);
            tooltip.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.honey_crystal_shield.level_tooltip").method_27693(": " + (shieldLevel + 1)));
        }
    }

    @Override
    public int bz$getMaxDamage(class_1799 stack) {
        if (stack.method_7985()) {
            this.upgradeLegacyShield(stack);
            int shieldLevel = Math.max(Math.min(stack.method_7948().method_10550("ShieldLevel"), maxShieldLevel), 0);
            if (shieldLevel != 0) {
                return stack.method_7909().method_7841() + shieldDurabilityBoostPerLevel[shieldLevel];
            }
        }
        return stack.method_7909().method_7841();
    }

    public int getMaxDamage(class_1799 stack) {
        return this.bz$getMaxDamage(stack);
    }

    private void upgradeLegacyShield(class_1799 stack) {
        if (stack.method_7985() && !stack.method_7969().method_10545("ShieldLevel")) {
            int repairCost = stack.method_7948().method_10550("RepairCost");
            if (repairCost >= 32) {
                stack.method_7948().method_10569("ShieldLevel", maxShieldLevel);
            } else if (repairCost >= 16) {
                stack.method_7948().method_10569("ShieldLevel", maxShieldLevel - 1);
            } else if (repairCost >= 5) {
                stack.method_7948().method_10569("ShieldLevel", maxShieldLevel / 2);
            }
        }
    }

    @Override
    public void bz$setDamage(class_1799 stack, int damage) {
        int newDamage = damage;
        int oldDamage = stack.method_7919();
        int damageCaused = oldDamage - damage;
        int shieldLevel = stack.method_7948().method_10550("ShieldLevel");
        if (damageCaused < 0) {
            int reducedDamage = -1 * Math.min(-1, damageCaused + shieldLevel / 4);
            newDamage = Math.max(0, stack.method_7919() + reducedDamage);
        } else if (damageCaused > stack.method_7936() / 5) {
            stack.method_7948().method_10569("ShieldLevel", Math.min(maxShieldLevel, shieldLevel + 1));
        }
        stack.method_7948().method_10569("Damage", Math.max(0, newDamage));
    }

    public void setDamage(class_1799 stack, int damage) {
        this.bz$setDamage(stack, damage);
    }

    @Override
    public OptionalBoolean bz$canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        if (enchantment == class_1893.field_9101) {
            return OptionalBoolean.FALSE;
        }
        return OptionalBoolean.of(enchantment.field_9083.method_8177(stack.method_7909()));
    }

    public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        return this.bz$canApplyAtEnchantingTable(stack, enchantment).orElseGet(() -> enchantment.field_9083.method_8177(stack.method_7909()));
    }

    public int method_31569(class_1799 itemStack) {
        return Math.round(13.0f - (float)itemStack.method_7919() * 13.0f / (float)itemStack.method_7936());
    }

    public int method_31571(class_1799 itemStack) {
        float f = Math.max(0.0f, ((float)itemStack.method_7936() - (float)itemStack.method_7919()) / (float)itemStack.method_7936());
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean bz$canPerformAction(class_1799 stack, String toolAction) {
        return toolAction.equals("shield_block") && stack.method_31574((class_1792)this);
    }

    public static boolean handledPlayerHurtBehavior(EntityAttackedEvent event) {
        class_1309 class_13092 = event.entity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            HoneyCrystalShield.slowPhysicalAttackers(event.source(), player);
            return HoneyCrystalShield.damageShieldFromExplosionAndFire(event.source(), player);
        }
        return false;
    }

    public static boolean damageShieldFromExplosionAndFire(class_1282 source, class_1657 player) {
        class_8109 damageSources = player.method_37908().method_48963();
        if (player.method_6030().method_7909() instanceof HoneyCrystalShield && player.method_6039() && (source.method_48789(class_8103.field_42249) || source.method_48789(class_8103.field_42246))) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                BzCriterias.HONEY_CRYSTAL_SHIELD_BLOCK_INEFFECTIVELY_TRIGGER.trigger(serverPlayer);
            }
            if (source.method_48789(class_8103.field_42249)) {
                player.method_48761(0.0, 0.0);
                ((PlayerDamageShieldInvoker)player).bumblezone$callHurtCurrentlyUsedShield(Math.max(player.method_6030().method_7936() / 3, 18));
            } else if (source.method_48789(class_8103.field_42246) && !player.method_6059(class_1294.field_5918)) {
                if (source.method_48789(class_8103.field_42247)) {
                    ((PlayerDamageShieldInvoker)player).bumblezone$callHurtCurrentlyUsedShield(Math.max(player.method_6030().method_7936() / 6, 3));
                } else {
                    ((PlayerDamageShieldInvoker)player).bumblezone$callHurtCurrentlyUsedShield(Math.max(player.method_6030().method_7936() / 100, 3));
                    return false;
                }
            }
            if (player instanceof class_3222) {
                player.method_7259(class_3468.field_15372.method_14956((Object)player.method_6030().method_7909()));
            }
            return true;
        }
        return false;
    }

    public static void slowPhysicalAttackers(class_1282 source, class_1657 player) {
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            if ((!source.method_48789(class_8103.field_42249) || !source.method_48789(class_8103.field_43116)) && player.method_6030().method_7909() instanceof HoneyCrystalShield && player.method_6039()) {
                attacker.method_6092(new class_1293(class_1294.field_5909, 165, 1, true, true, false));
            }
        }
    }

    public static void setShieldCooldown(class_1657 playerEntity, class_1309 livingEntity) {
        float disableChance = 0.25f + (float)class_1890.method_8234((class_1309)livingEntity) * 0.05f;
        if (livingEntity.method_6051().method_43057() < disableChance) {
            playerEntity.method_7357().method_7906(BzItems.HONEY_CRYSTAL_SHIELD.get(), 100);
            livingEntity.method_37908().method_8421((class_1297)playerEntity, (byte)30);
        }
    }

    public static boolean damageHoneyCrystalShield(class_1657 player, float amount) {
        if (player.method_6030().method_7909() == BzItems.HONEY_CRYSTAL_SHIELD.get()) {
            if (amount >= 3.0f) {
                int damageToDo = 1 + class_3532.method_15375((float)amount);
                class_1268 hand = player.method_6058();
                player.method_6030().method_7956(damageToDo, (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
                if (player.method_6030().method_7960()) {
                    if (hand == class_1268.field_5808) {
                        player.method_5673(class_1304.field_6173, class_1799.field_8037);
                    } else {
                        player.method_5673(class_1304.field_6171, class_1799.field_8037);
                    }
                    player.method_6021();
                    player.method_5783(class_3417.field_15239, 0.8f, 0.8f + player.method_6051().method_43057() * 0.4f);
                }
            }
            return true;
        }
        return false;
    }
}

