/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.menus;

import com.telepathicgrunt.the_bumblezone.blocks.CrystallineFlower;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.CrystallineFlowerBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.menus.EnchantmentSkeleton;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.CrystallineFlowerEnchantmentPacket;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class CrystallineFlowerMenu
extends class_1703 {
    public static final int CONSUME_SLOT = 0;
    private static final int BOOK_SLOT = 1;
    private static final int ENCHANTED_SLOT = 2;
    public static final int CONSUME_SLOT_X = 47;
    public static final int CONSUME_SLOT_Y = 80;
    private static final int BOOK_SLOT_X = 92;
    private static final int BOOK_SLOT_Y = 28;
    private static final int ENCHANTED_SLOT_X = 136;
    private static final int ENCHANTED_SLOT_Y = 28;
    private final class_3914 access;
    private final class_1657 player;
    public final CrystallineFlowerBlockEntity crystallineFlowerBlockEntity;
    public final class_1735 consumeSlot;
    public final class_1735 bookSlot;
    public final class_1735 enchantedSlot;
    public class_2960 selectedEnchantment = null;
    public final class_3915 xpBarPercent = class_3915.method_17403();
    public final class_3915 xpTier = class_3915.method_17403();
    public final class_3915 tierCostUpper = class_3915.method_17403();
    public final class_3915 tierCostLower = class_3915.method_17403();
    public final class_3915 bottomBlockPosXUpper = class_3915.method_17403();
    public final class_3915 bottomBlockPosXLower = class_3915.method_17403();
    public final class_3915 bottomBlockPosYUpper = class_3915.method_17403();
    public final class_3915 bottomBlockPosYLower = class_3915.method_17403();
    public final class_3915 bottomBlockPosZUpper = class_3915.method_17403();
    public final class_3915 bottomBlockPosZLower = class_3915.method_17403();
    public final class_3915 playerHasXPForTier = class_3915.method_17403();
    public final class_3915 consumeSlotFullyObstructed = class_3915.method_17403();
    public final class_3915 tooManyEnchantmentsOnInput = class_3915.method_17403();
    private final class_1263 inputContainer = new class_1277(3){

        public void method_5431() {
            super.method_5431();
            CrystallineFlowerMenu.this.method_7609((class_1263)this);
        }
    };
    long lastSoundTime;

    public CrystallineFlowerMenu(int containerId, class_1661 playerInventory) {
        this(containerId, playerInventory, class_3914.field_17304, null);
    }

    public CrystallineFlowerMenu(int containerId, class_1661 playerInventory, final class_3914 access, final CrystallineFlowerBlockEntity crystallineFlowerBlockEntity) {
        super(BzMenuTypes.CRYSTALLINE_FLOWER.get(), containerId);
        int i;
        this.access = access;
        this.player = playerInventory.field_7546;
        this.crystallineFlowerBlockEntity = crystallineFlowerBlockEntity;
        this.consumeSlot = this.method_7621(new class_1735(this.inputContainer, 0, 47, 80){

            public boolean method_7680(class_1799 itemStack) {
                class_2343 entityBlock;
                class_1747 blockItem;
                if (!BzGeneralConfigs.crystallineFlowerConsumeItemUI) {
                    return false;
                }
                if (itemStack.method_31573(BzTags.CANNOT_CONSUMED_ITEMS)) {
                    return false;
                }
                if (!itemStack.method_7909().method_31568()) {
                    return false;
                }
                class_1792 class_17922 = itemStack.method_7909();
                return !(class_17922 instanceof class_1747) || !((class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2343) || !((entityBlock = (class_2343)class_17922).method_10123(class_2338.field_10980, blockItem.method_7711().method_9564()) instanceof class_1263);
            }

            public void method_7668() {
                this.field_7871.method_5431();
                CrystallineFlowerMenu.this.consumeSlotFullyObstructed();
                if (!CrystallineFlowerMenu.this.player.method_37908().method_8608()) {
                    crystallineFlowerBlockEntity.setConsumeSlotItems(CrystallineFlowerMenu.this.consumeSlot.method_7677());
                    crystallineFlowerBlockEntity.syncPillar();
                }
            }
        });
        this.bookSlot = this.method_7621(new class_1735(this.inputContainer, 1, 92, 28){

            public boolean method_7680(class_1799 itemStack) {
                return itemStack.method_31573(BzTags.CAN_BE_ENCHANTED_ITEMS);
            }

            public void method_7668() {
                this.field_7871.method_5431();
                class_1799 bookSlotItem = CrystallineFlowerMenu.this.bookSlot.method_7677();
                if (bookSlotItem.method_7960()) {
                    CrystallineFlowerMenu.this.selectedEnchantment = null;
                }
                if (!CrystallineFlowerMenu.this.player.method_37908().method_8608()) {
                    CrystallineFlowerMenu.this.setupResultSlot();
                    CrystallineFlowerMenu.this.method_7623();
                    crystallineFlowerBlockEntity.setBookSlotItems(CrystallineFlowerMenu.this.bookSlot.method_7677());
                    crystallineFlowerBlockEntity.syncPillar();
                }
            }
        });
        this.enchantedSlot = this.method_7621(new class_1735(this.inputContainer, 2, 136, 28){

            public boolean method_7680(class_1799 itemStack) {
                return false;
            }

            public void method_7667(class_1657 player, class_1799 itemStack) {
                access.method_17393((soundLevel, pos) -> {
                    long gameTime = soundLevel.method_8510();
                    if (CrystallineFlowerMenu.this.lastSoundTime != gameTime) {
                        soundLevel.method_8396(null, pos, BzSounds.CRYSTALLINE_FLOWER_USE.get(), class_3419.field_15245, 1.0f, 1.0f);
                        CrystallineFlowerMenu.this.lastSoundTime = gameTime;
                    }
                });
                class_1799 oldConsumeStack = CrystallineFlowerMenu.this.bookSlot.method_7677().method_7972();
                Map<class_2960, class_1889> oldAvailableEnchantments = CrystallineFlowerMenu.this.getAvailableEnchantments(oldConsumeStack);
                CrystallineFlowerMenu.this.bookSlot.method_7671(1);
                CrystallineFlowerMenu.this.drainFlowerXPLevel(GeneralUtils.merge(CrystallineFlowerMenu.this.tierCostUpper.method_17407(), CrystallineFlowerMenu.this.tierCostLower.method_17407()));
                if (!player.method_37908().method_8608()) {
                    class_1889 oldEnchantSelected = oldAvailableEnchantments.get(CrystallineFlowerMenu.this.selectedEnchantment);
                    CrystallineFlowerMenu.this.selectedEnchantment = null;
                    CrystallineFlowerMenu.this.setupResultSlot(class_7923.field_41176.method_10221((Object)oldEnchantSelected.field_9093));
                    CrystallineFlowerMenu.this.method_7623();
                    crystallineFlowerBlockEntity.setBookSlotItems(CrystallineFlowerMenu.this.bookSlot.method_7677());
                    crystallineFlowerBlockEntity.syncPillar();
                } else {
                    CrystallineFlowerMenu.this.selectedEnchantment = null;
                }
                super.method_7667(player, itemStack);
            }
        });
        int playerInvYOffset = 115;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, playerInvYOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, playerInvYOffset + 58));
        }
        this.selectedEnchantment = null;
        this.xpBarPercent.method_17404(0);
        this.xpTier.method_17404(0);
        this.tierCostUpper.method_17404(0);
        this.tierCostLower.method_17404(0);
        this.playerHasXPForTier.method_17404(0);
        this.consumeSlotFullyObstructed.method_17404(0);
        this.tooManyEnchantmentsOnInput.method_17404(0);
        this.bottomBlockPosXUpper.method_17404(0);
        this.bottomBlockPosXLower.method_17404(0);
        this.bottomBlockPosYUpper.method_17404(0);
        this.bottomBlockPosYLower.method_17404(0);
        this.bottomBlockPosZUpper.method_17404(0);
        this.bottomBlockPosZLower.method_17404(0);
        if (this.crystallineFlowerBlockEntity != null) {
            this.bottomBlockPosXUpper.method_17404(GeneralUtils.split(this.crystallineFlowerBlockEntity.method_11016().method_10263(), true));
            this.bottomBlockPosXLower.method_17404(GeneralUtils.split(this.crystallineFlowerBlockEntity.method_11016().method_10263(), false));
            this.bottomBlockPosYUpper.method_17404(GeneralUtils.split(this.crystallineFlowerBlockEntity.method_11016().method_10264(), true));
            this.bottomBlockPosYLower.method_17404(GeneralUtils.split(this.crystallineFlowerBlockEntity.method_11016().method_10264(), false));
            this.bottomBlockPosZUpper.method_17404(GeneralUtils.split(this.crystallineFlowerBlockEntity.method_11016().method_10260(), true));
            this.bottomBlockPosZLower.method_17404(GeneralUtils.split(this.crystallineFlowerBlockEntity.method_11016().method_10260(), false));
        }
        this.syncXpTier();
        this.method_17362(this.xpBarPercent);
        this.method_17362(this.xpTier);
        this.method_17362(this.tierCostUpper);
        this.method_17362(this.tierCostLower);
        this.method_17362(this.playerHasXPForTier);
        this.method_17362(this.consumeSlotFullyObstructed);
        this.method_17362(this.tooManyEnchantmentsOnInput);
        this.method_17362(this.bottomBlockPosXUpper);
        this.method_17362(this.bottomBlockPosXLower);
        this.method_17362(this.bottomBlockPosYUpper);
        this.method_17362(this.bottomBlockPosYLower);
        this.method_17362(this.bottomBlockPosZUpper);
        this.method_17362(this.bottomBlockPosZLower);
        if (this.crystallineFlowerBlockEntity != null) {
            this.bookSlot.method_7673(this.crystallineFlowerBlockEntity.getBookSlotItems());
            this.consumeSlot.method_7673(this.crystallineFlowerBlockEntity.getConsumeSlotItems());
            this.method_7623();
        }
    }

    public void method_34252() {
        super.method_34252();
        this.setupResultSlot();
    }

    private void syncXpTier() {
        if (this.crystallineFlowerBlockEntity != null) {
            int currentXP = this.crystallineFlowerBlockEntity.getCurrentXp();
            int maxXPForCurrentTier = this.crystallineFlowerBlockEntity.getMaxXpForTier(this.crystallineFlowerBlockEntity.getXpTier());
            this.xpBarPercent.method_17404((int)((float)currentXP / (float)maxXPForCurrentTier * 100.0f));
            this.xpTier.method_17404(this.crystallineFlowerBlockEntity.getXpTier());
            if (this.player.method_31549().field_7477) {
                this.playerHasXPForTier.method_17404(Math.min(7 - this.crystallineFlowerBlockEntity.getXpTier(), 3));
            } else {
                int tierAbleToBeBought = 0;
                int totalXPRequires = 0;
                long playerXP = EnchantmentUtils.getPlayerXP(this.player);
                for (int i = 0; i < 3; ++i) {
                    if (this.crystallineFlowerBlockEntity.getXpTier() + i >= 7) continue;
                    totalXPRequires += this.crystallineFlowerBlockEntity.getMaxXpForTier(this.crystallineFlowerBlockEntity.getXpTier() + i);
                    if (i == 0) {
                        totalXPRequires -= currentXP;
                    }
                    if ((long)totalXPRequires > playerXP) break;
                    ++tierAbleToBeBought;
                }
                this.playerHasXPForTier.method_17404(tierAbleToBeBought);
            }
            this.method_7623();
        }
    }

    public void method_7609(class_1263 inventory) {
    }

    public boolean clickMenuEnchantment(class_1657 player, class_2960 selectedEnchant) {
        this.selectedEnchantment = selectedEnchant;
        if (!player.method_37908().method_8608()) {
            this.setupResultSlot();
            this.method_7623();
        }
        return true;
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == -2) {
            this.drainPlayerXPLevel(1);
            if (!player.method_37908().method_8608()) {
                this.setupResultSlot();
                this.method_7623();
            }
            return true;
        }
        if (id == -3) {
            this.drainPlayerXPLevel(2);
            if (!player.method_37908().method_8608()) {
                this.setupResultSlot();
                this.method_7623();
            }
            return true;
        }
        if (id == -4) {
            this.drainPlayerXPLevel(3);
            if (!player.method_37908().method_8608()) {
                this.setupResultSlot();
                this.method_7623();
            }
            return true;
        }
        if (id == -5) {
            this.consumeItem();
            if (!player.method_37908().method_8608()) {
                this.setupResultSlot();
                this.method_7623();
            }
            return true;
        }
        return false;
    }

    private void consumeItem() {
        if (this.consumeSlot.method_7681() && this.crystallineFlowerBlockEntity != null && !this.crystallineFlowerBlockEntity.isMaxTier()) {
            class_1657 class_16572;
            int tiersToMax = 7 - this.crystallineFlowerBlockEntity.getXpTier();
            int topBlock = CrystallineFlower.flowerHeightAbove((class_4538)this.player.method_37908(), this.crystallineFlowerBlockEntity.method_11016());
            List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(tiersToMax, this.player.method_37908(), this.crystallineFlowerBlockEntity.method_11016().method_10086(topBlock + 1));
            int xpPerCount = CrystallineFlower.getXpPerItem(this.consumeSlot.method_7677());
            int itemCount = this.consumeSlot.method_7677().method_7947();
            long xpForStack = (long)itemCount * (long)xpPerCount;
            int xpToHighestAvailableTier = CrystallineFlower.getXpToHighestAvailableTier(this.crystallineFlowerBlockEntity, tiersToMax, obstructedAbove);
            int xpGranted = (int)Math.min((long)xpToHighestAvailableTier, xpForStack);
            int consumedItemCount = (int)Math.ceil((float)xpGranted / (float)xpPerCount);
            if (consumedItemCount == 0) {
                return;
            }
            this.crystallineFlowerBlockEntity.addXpAndTier(xpGranted);
            this.consumeSlot.method_7671(consumedItemCount);
            this.consumeSlotFullyObstructed();
            if (tiersToMax > 0 && this.crystallineFlowerBlockEntity.isMaxTier() && (class_16572 = this.player) instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                BzCriterias.GROW_CRYSTALLINE_FLOWER_TRIGGER.trigger(serverPlayer);
            }
            this.syncXpTier();
            this.crystallineFlowerBlockEntity.syncPillar();
        }
    }

    public void consumeSlotFullyObstructed() {
        boolean fullyObstructed = false;
        if (this.consumeSlot.method_7681() && this.crystallineFlowerBlockEntity != null) {
            if (!this.crystallineFlowerBlockEntity.isMaxTier()) {
                int topBlock = CrystallineFlower.flowerHeightAbove((class_4538)this.player.method_37908(), this.crystallineFlowerBlockEntity.method_11016());
                List<Boolean> obstructedAbove = CrystallineFlower.getObstructions(1, this.player.method_37908(), this.crystallineFlowerBlockEntity.method_11016().method_10086(topBlock + 1));
                if (!obstructedAbove.isEmpty() && obstructedAbove.get(0).booleanValue()) {
                    int xpPerCount = CrystallineFlower.getXpPerItem(this.consumeSlot.method_7677());
                    int xpToMaxTier = this.crystallineFlowerBlockEntity.getXpForNextTiers(1) - 1;
                    int itemsConsumable = xpToMaxTier / xpPerCount;
                    fullyObstructed = itemsConsumable == 0;
                }
            } else {
                fullyObstructed = true;
            }
            if (fullyObstructed) {
                this.consumeSlotFullyObstructed.method_17404(1);
            } else {
                this.consumeSlotFullyObstructed.method_17404(0);
            }
            this.method_7623();
            this.crystallineFlowerBlockEntity.setConsumeSlotItems(this.consumeSlot.method_7677());
            this.crystallineFlowerBlockEntity.syncPillar();
        }
    }

    private void drainPlayerXPLevel(int desiredTierUpgrade) {
        if (this.crystallineFlowerBlockEntity != null && !this.crystallineFlowerBlockEntity.isMaxTier()) {
            class_1657 class_16572;
            int xpObtained;
            boolean isSpotObstructed;
            List<Boolean> obstructions = CrystallineFlower.getObstructions(desiredTierUpgrade, this.crystallineFlowerBlockEntity.method_10997(), this.crystallineFlowerBlockEntity.method_11016().method_10086(this.crystallineFlowerBlockEntity.getXpTier()));
            int freeTierSpot = 0;
            Iterator<Boolean> iterator = obstructions.iterator();
            while (iterator.hasNext() && !(isSpotObstructed = iterator.next().booleanValue())) {
                ++freeTierSpot;
            }
            int xpRequested = this.crystallineFlowerBlockEntity.getXpForNextTiers(freeTierSpot);
            if (!this.player.method_31549().field_7477) {
                xpObtained = (int)Math.min(EnchantmentUtils.getPlayerXP(this.player), (long)xpRequested);
                this.player.method_7255(-xpRequested);
            } else {
                xpObtained = xpRequested;
            }
            this.crystallineFlowerBlockEntity.addXpAndTier(xpObtained);
            this.consumeSlotFullyObstructed();
            this.syncXpTier();
            if (desiredTierUpgrade > 0 && this.crystallineFlowerBlockEntity.isMaxTier() && (class_16572 = this.player) instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                BzCriterias.GROW_CRYSTALLINE_FLOWER_TRIGGER.trigger(serverPlayer);
            }
        }
    }

    private void drainFlowerXPLevel(int levelToConsume) {
        if (this.crystallineFlowerBlockEntity != null && !this.crystallineFlowerBlockEntity.isMinTier()) {
            class_1657 class_16572;
            this.crystallineFlowerBlockEntity.decreaseTier(levelToConsume);
            this.consumeSlotFullyObstructed();
            this.syncXpTier();
            if (levelToConsume >= 5 && (class_16572 = this.player) instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                BzCriterias.ENCHANT_CRYSTALLINE_FLOWER_TRIGGER.trigger(serverPlayer);
            }
        } else if (this.xpTier.method_17407() > 1) {
            this.xpTier.method_17404(Math.max(1, this.xpTier.method_17407() - levelToConsume));
        }
    }

    protected void method_7607(class_1657 player, class_1263 container) {
        this.enchantedSlot.field_7871.method_5441(this.enchantedSlot.field_7874);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.access.method_17393((level, blockPos) -> this.method_7607(player, this.inputContainer));
    }

    public boolean method_7597(class_1657 player) {
        return CrystallineFlowerMenu.method_17695((class_3914)this.access, (class_1657)player, (class_2248)BzBlocks.CRYSTALLINE_FLOWER.get());
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemStack = itemstack1.method_7972();
            if (index == this.enchantedSlot.field_7874) {
                if (!this.method_7616(itemstack1, 3, 39, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemstack1, itemStack);
            } else if (index != this.consumeSlot.field_7874 && index != this.bookSlot.field_7874) {
                if (!itemStack.method_31573(BzTags.CAN_BE_ENCHANTED_ITEMS) && !this.method_7616(itemstack1, this.consumeSlot.field_7874, this.consumeSlot.field_7874 + 1, false)) {
                    return class_1799.field_8037;
                }
                if (itemStack.method_31573(BzTags.CAN_BE_ENCHANTED_ITEMS) && !this.method_7616(itemstack1, this.bookSlot.field_7874, this.bookSlot.field_7874 + 1, false)) {
                    return class_1799.field_8037;
                }
                if (index >= 3 && index < 30 && !this.method_7616(itemstack1, 30, 39, false)) {
                    return class_1799.field_8037;
                }
                if (index >= 30 && index < 39 && !this.method_7616(itemstack1, 3, 30, false)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(itemstack1, 3, 39, false)) {
                return class_1799.field_8037;
            }
            if (itemstack1.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemstack1.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemstack1);
        }
        return itemStack;
    }

    private void setupResultSlot() {
        this.setupResultSlot(null);
    }

    private void setupResultSlot(class_2960 oldEnchantment) {
        class_1799 bookSlotItem = this.bookSlot.method_7677();
        if (bookSlotItem.method_7960() || this.xpTier.method_17407() <= 1) {
            this.tooManyEnchantmentsOnInput.method_17404(0);
            this.selectedEnchantment = null;
            if (this.enchantedSlot.method_7681()) {
                this.enchantedSlot.method_7673(class_1799.field_8037);
            }
            return;
        }
        int existingEnchantments = class_1890.method_8222((class_1799)bookSlotItem).size();
        if (existingEnchantments >= 3) {
            this.tooManyEnchantmentsOnInput.method_17404(1);
            this.selectedEnchantment = null;
            if (this.enchantedSlot.method_7681()) {
                this.enchantedSlot.method_7673(class_1799.field_8037);
            }
            return;
        }
        this.tooManyEnchantmentsOnInput.method_17404(0);
        class_1799 toEnchant = this.bookSlot.method_7677();
        if (!toEnchant.method_7960()) {
            class_1657 tierCost2;
            class_1799 tempCopy = toEnchant.method_7972();
            tempCopy.method_7939(1);
            Map<class_2960, class_1889> availableEnchantments = this.getAvailableEnchantments(tempCopy);
            if (availableEnchantments.isEmpty()) {
                if (this.enchantedSlot.method_7681()) {
                    this.enchantedSlot.method_7673(class_1799.field_8037);
                }
                this.selectedEnchantment = null;
            } else if (availableEnchantments.containsKey(oldEnchantment)) {
                this.selectedEnchantment = oldEnchantment;
            }
            if (this.selectedEnchantment != null && availableEnchantments.containsKey(this.selectedEnchantment)) {
                class_1889 enchantmentForItem = availableEnchantments.get(this.selectedEnchantment);
                if (tempCopy.method_31574(class_1802.field_8529)) {
                    class_1799 enchantedBook = class_1802.field_8598.method_7854();
                    enchantedBook.method_7939(1);
                    class_2487 compoundtag = tempCopy.method_7969();
                    if (compoundtag != null) {
                        enchantedBook.method_7980(compoundtag.method_10553());
                    }
                    tempCopy = enchantedBook;
                }
                if (tempCopy.method_31574(class_1802.field_8529) || tempCopy.method_31574(class_1802.field_8598)) {
                    class_1772.method_7807((class_1799)tempCopy, (class_1889)enchantmentForItem);
                } else {
                    tempCopy.method_7978(enchantmentForItem.field_9093, enchantmentForItem.field_9094);
                }
                if (!class_1799.method_7973((class_1799)tempCopy, (class_1799)this.enchantedSlot.method_7677())) {
                    this.enchantedSlot.method_7673(tempCopy);
                    int tierCost2 = EnchantmentUtils.getEnchantmentTierCost(enchantmentForItem);
                    this.tierCostUpper.method_17404(GeneralUtils.split(tierCost2, true));
                    this.tierCostLower.method_17404(GeneralUtils.split(tierCost2, false));
                }
            }
            if ((tierCost2 = this.player) instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)tierCost2;
                List<EnchantmentSkeleton> availableEnchantmentsSkeletons = availableEnchantments.values().stream().map(e -> {
                    class_2960 resourceLocation = class_7923.field_41176.method_10221((Object)e.field_9093);
                    return new EnchantmentSkeleton(resourceLocation.method_12832(), resourceLocation.method_12836(), e.field_9094, e.field_9093.method_8182(resourceLocation.method_12836().equals("minecraft") ? Math.max(e.field_9094, 2) : e.field_9094), e.field_9094 == e.field_9093.method_8183(), e.field_9093.method_8195(), e.field_9093.method_8193());
                }).toList();
                class_2960 selectedEnchant = this.selectedEnchantment == null ? new class_2960("minecraft", "empty") : this.selectedEnchantment;
                CrystallineFlowerEnchantmentPacket.sendToClient(serverPlayer, this.field_7763, availableEnchantmentsSkeletons, selectedEnchant);
            }
        }
    }

    @NotNull
    private Map<class_2960, class_1889> getAvailableEnchantments(class_1799 tempCopy) {
        int level = this.xpTier.method_17407() * BzGeneralConfigs.crystallineFlowerEnchantingPowerAllowedPerTier;
        return EnchantmentUtils.allAllowedEnchantsWithoutMaxLimit(level, tempCopy, this.xpTier.method_17407());
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return super.method_7613(stack, slot);
    }
}

