/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.items.recipes.PotionCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakePotionCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenRandomizeTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modinit.BzCreativeTabs;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3955;
import net.minecraft.class_6012;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public static final RecipeType<JEIQueenTradesInfo> QUEEN_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_trades", JEIQueenTradesInfo.class);
    public static final RecipeType<JEIQueenRandomizerTradesInfo> QUEEN_RANDOMIZE_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_color_randomizer_trades", JEIQueenRandomizerTradesInfo.class);

    private static void addInfo(IRecipeRegistration registration, class_1792 item) {
        registration.addIngredientInfo((Object)new class_1799((class_1935)item), (IIngredientType)VanillaTypes.ITEM_STACK, new class_2561[]{class_2561.method_43471((String)("the_bumblezone." + class_7923.field_41178.method_10221((Object)item).method_12832() + ".description"))});
    }

    private static void addInfo(IRecipeRegistration registration, class_3611 fluid) {
        JEIIntegration.addFluidInfo(registration, fluid, registration.getJeiHelpers().getPlatformFluidHelper());
    }

    private static <T> void addFluidInfo(IRecipeRegistration registration, class_3611 fluid, IPlatformFluidHelper<T> platformFluidHelper) {
        registration.addIngredientInfo(platformFluidHelper.create(fluid, 1L), (IIngredientType)platformFluidHelper.getFluidIngredientType(), new class_2561[]{class_2561.method_43471((String)("the_bumblezone." + class_7923.field_41173.method_10221((Object)fluid).method_12832() + ".description"))});
    }

    private static void registerExtraRecipes(class_1860<?> baseRecipe, IRecipeRegistration registration, boolean oneRecipeOnly) {
        if (baseRecipe instanceof PotionCandleRecipe) {
            PotionCandleRecipe potionCandleRecipe = (PotionCandleRecipe)baseRecipe;
            List<class_3955> extraRecipes = FakePotionCandleRecipeCreator.constructFakeRecipes(potionCandleRecipe, oneRecipeOnly);
            registration.addRecipes(RecipeTypes.CRAFTING, extraRecipes);
        }
    }

    public class_2960 getPluginUid() {
        return new class_2960("the_bumblezone", "jei_plugin");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        class_638 level;
        BzCreativeTabs.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> JEIIntegration.addInfo(registration, (class_1792)item.get()));
        JEIIntegration.addInfo(registration, (class_3611)BzFluids.SUGAR_WATER_FLUID.get());
        JEIIntegration.addInfo(registration, (class_3611)BzFluids.ROYAL_JELLY_FLUID.get());
        if (BzModCompatibilityConfigs.alternativeFluidToReplaceHoneyFluid.isEmpty()) {
            JEIIntegration.addInfo(registration, (class_3611)BzFluids.HONEY_FLUID.get());
        }
        if ((level = class_310.method_1551().field_1687) == null) {
            return;
        }
        level.method_8433().method_8130(new class_2960("the_bumblezone", "potion_candle/from_super_candles")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, true));
        level.method_8433().method_8130(new class_2960("the_bumblezone", "potion_candle/from_string_and_carvable_wax")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, false));
        LinkedList<JEIQueenTradesInfo> trades = new LinkedList<JEIQueenTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades.isEmpty()) {
            for (Pair<MainTradeRowInput, class_6012<WeightedTradeResult>> trade : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades) {
                for (WeightedTradeResult weightedTradeResult : ((class_6012)trade.getSecond()).method_34994()) {
                    trades.add(new JEIQueenTradesInfo((MainTradeRowInput)trade.getFirst(), weightedTradeResult));
                }
            }
        }
        registration.addRecipes(QUEEN_TRADES, trades);
        LinkedList<JEIQueenRandomizerTradesInfo> randomizerTrades = new LinkedList<JEIQueenRandomizerTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades.isEmpty()) {
            Object2ObjectOpenHashMap cacheJeiData = new Object2ObjectOpenHashMap();
            for (RandomizeTradeRowInput tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades) {
                class_6862<class_1792> itemTagKey = tradeEntry.tagKey().get();
                TagData tagData = cacheJeiData.getOrDefault(itemTagKey, null);
                if (tagData == null) {
                    List<class_1799> randomizeStack = tradeEntry.getWantItems().method_40239().map(e -> ((class_1792)e.comp_349()).method_7854()).toList();
                    tagData = new TagData(randomizeStack.size(), randomizeStack, class_1856.method_8106(itemTagKey));
                    cacheJeiData.put(itemTagKey, tagData);
                }
                randomizerTrades.add(new JEIQueenRandomizerTradesInfo(itemTagKey, tagData.jeiIngredient(), tagData.listSize(), tagData.jeiItems()));
            }
        }
        registration.addRecipes(QUEEN_RANDOMIZE_TRADES, randomizerTrades);
        List<class_1799> hangingGardensFlowers = GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_FLOWERS_BLOCKS);
        hangingGardensFlowers.addAll(GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_TALL_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_TALL_FLOWERS_BLOCKS));
        JEIIntegration.addComplexBlockTagInfo(registration, Pair.of((Object)".hanging_gardens_flowers.description", hangingGardensFlowers), Pair.of((Object)".crystalline_flower_can_be_placed_on.description", GeneralUtils.convertBlockTagsToItemStacks(BzTags.CRYSTALLINE_FLOWER_CAN_SURVIVE_ON, null)));
    }

    @SafeVarargs
    private static void addComplexBlockTagInfo(@NotNull IRecipeRegistration registration, Pair<String, List<class_1799>> ... structureInfo) {
        for (Pair<String, List<class_1799>> predicatePair : structureInfo) {
            registration.addIngredientInfo((List)predicatePair.getSecond(), (IIngredientType)VanillaTypes.ITEM_STACK, new class_2561[]{class_2561.method_43471((String)("the_bumblezone" + (String)predicatePair.getFirst()))});
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenRandomizeTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(BzItems.BEE_QUEEN_SPAWN_EGG.get().method_7854(), new RecipeType[]{QUEEN_TRADES});
        registration.addRecipeCatalyst(BzItems.BEE_QUEEN_SPAWN_EGG.get().method_7854(), new RecipeType[]{QUEEN_RANDOMIZE_TRADES});
    }

    record TagData(int listSize, List<class_1799> jeiItems, class_1856 jeiIngredient) {
    }
}

