/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla;

import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.Area;
import com.telepathicgrunt.the_bumblezone.worldgen.dimension.layer.vanilla.PixelTransformer;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import net.minecraft.class_1923;

public class LazyArea
implements Area {
    private final PixelTransformer transformer;
    private final Long2IntLinkedOpenHashMap cache;
    private final int maxCache;

    public LazyArea(Long2IntLinkedOpenHashMap long2IntLinkedOpenHashMap, int maxCache, PixelTransformer pixelTransformer) {
        this.cache = long2IntLinkedOpenHashMap;
        this.maxCache = maxCache;
        this.transformer = pixelTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get(int x, int z) {
        long longPos = class_1923.method_8331((int)x, (int)z);
        Long2IntLinkedOpenHashMap long2IntLinkedOpenHashMap = this.cache;
        synchronized (long2IntLinkedOpenHashMap) {
            int cachedBiomeInt = this.cache.get(longPos);
            if (cachedBiomeInt != Integer.MIN_VALUE) {
                return cachedBiomeInt;
            }
            int biomeInt = this.transformer.apply(x, z);
            this.cache.put(longPos, biomeInt);
            if (this.cache.size() > this.maxCache) {
                for (int n = 0; n < this.maxCache / 16; ++n) {
                    this.cache.removeFirstInt();
                }
            }
            return biomeInt;
        }
    }

    public int getMaxCache() {
        return this.maxCache;
    }
}

