/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.fabricmc.loader.api.FabricLoader;

public class TranslatedLegacy {
    public static final File CONFIG_FOLDER = FabricLoader.getInstance().getConfigDir().resolve("translated-legacy").toFile();
    public static final File META_FILE = new File(CONFIG_FOLDER, "pack.mcmeta");
    public static final long MONTH = 2628000000L;

    public static void updateLanguageList() {
        boolean update = false;
        if (!CONFIG_FOLDER.exists()) {
            CONFIG_FOLDER.mkdirs();
            update = true;
        }
        if (!update) {
            if (META_FILE.exists()) {
                long lastModified = META_FILE.lastModified() + 2628000000L;
                if (System.currentTimeMillis() > lastModified) {
                    update = true;
                }
            } else {
                update = true;
            }
        }
        try {
            URL mcmetaURL = new URL(TranslatedLegacy.getRedirectedUrl("https://translations.catcore.fr/mcmeta"));
            if (update) {
                InputStream inputStream = mcmetaURL.openStream();
                Files.copy(inputStream, META_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getLangFile(String mcVersion, String code) {
        File versionFolder = new File(CONFIG_FOLDER, mcVersion);
        boolean update = false;
        if (!versionFolder.exists()) {
            update = true;
            versionFolder.mkdirs();
        }
        File langFile = new File(versionFolder, code + ".json");
        if (!update) {
            if (langFile.exists()) {
                long lastModified = langFile.lastModified() + 2628000000L;
                if (System.currentTimeMillis() > lastModified) {
                    update = true;
                }
            } else {
                update = true;
            }
        }
        if (update) {
            try {
                URL url = new URL(TranslatedLegacy.getRedirectedUrl("https://translations.catcore.fr/lang/" + mcVersion + "/" + code));
                InputStream inputStream = url.openStream();
                Files.copy(inputStream, langFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return langFile;
    }

    public static String getRedirectedUrl(String url) throws MalformedURLException, IOException {
        HttpURLConnection connection;
        String finalUrl = url;
        do {
            String redirectedUrl;
            connection = (HttpURLConnection)new URL(finalUrl).openConnection();
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            connection.setRequestMethod("GET");
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode < 300 || responseCode >= 400 || (redirectedUrl = connection.getHeaderField("Location")) == null) break;
            finalUrl = redirectedUrl;
        } while (connection.getResponseCode() != 200);
        connection.disconnect();
        return finalUrl.replaceAll(" ", "%20");
    }
}

