/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy.font;

import fr.catcore.translatedlegacy.font.Style;
import fr.catcore.translatedlegacy.font.api.GameProvider;
import fr.catcore.translatedlegacy.font.renderable.RenderableItem;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GlyphContainer {
    private final List<RenderableItem> renderables;
    private final Style style;

    public GlyphContainer(List<RenderableItem> renderables, Style style) {
        this.renderables = renderables;
        this.style = style;
    }

    public void render(int x, int y, int defaultColor, int blitOffset, GameProvider game, boolean flag) {
        int currentX = x;
        float alpha = (float)(defaultColor >> 24 & 0xFF) / 255.0f;
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        float red = (float)(defaultColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(defaultColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(defaultColor & 0xFF) / 255.0f;
        if (this.style != null && this.style.color != null) {
            red = this.style.color.r;
            green = this.style.color.g;
            blue = this.style.color.b;
            if (flag) {
                red /= 4.0f;
                green /= 4.0f;
                blue /= 4.0f;
            }
        }
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        for (RenderableItem renderable : this.renderables) {
            int currentY = y;
            int height = renderable.getHeight();
            if (height > 8) {
                currentY -= height - 9;
            }
            renderable.beforeRender();
            renderable.draw(game, currentX, currentY, blitOffset, this.style != null ? this.style.italic : false);
            int currentWidth = renderable.getWidth();
            if (this.style != null) {
                if (this.style.bold.booleanValue()) {
                    renderable.draw(game, currentX + 1, currentY, blitOffset, this.style.italic);
                    ++currentWidth;
                }
                game.doDecorations(currentX, y, currentWidth, 9.0f, this.style.strikethrough, this.style.underline);
            }
            currentX += currentWidth;
        }
    }

    public int getWidth() {
        return this.renderables.stream().mapToInt(RenderableItem::getWidth).sum();
    }

    public int getHeight() {
        return this.renderables.stream().mapToInt(RenderableItem::getHeight).max().orElse(8);
    }
}

