/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.translatedlegacy.font;

import fr.catcore.translatedlegacy.util.GLUtils;
import fr.catcore.translatedlegacy.util.NativeImage;
import java.io.Closeable;
import org.lwjgl.opengl.GL11;

public class NativeTexture
implements Closeable {
    private final NativeImage image;
    private final int pointer;

    public NativeTexture(NativeImage image) {
        this.image = image;
        this.pointer = GLUtils.generateTextureId();
        GLUtils.prepareImage(this.pointer, image.getWidth(), image.getHeight());
        GL11.glBindTexture((int)3553, (int)this.pointer);
        image.upload(0, 0, 0, false);
    }

    public void bind() {
        GL11.glBindTexture((int)3553, (int)this.pointer);
    }

    @Override
    public void close() {
        if (this.image != null) {
            this.image.close();
        }
        GLUtils.releaseTextureId(this.pointer);
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }
}

